/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin.activity;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;

public class ActivitySkipPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivitySkipPlugin.class);

    public boolean hasTrueCondition(AgentExecution execution) {
        block12: {
            try {
                String billNo = null;
                if (execution instanceof ExecutionEntityImpl) {
                    billNo = ((ExecutionEntityImpl)execution).getBillNo();
                } else if (execution instanceof PreComputatorExecutionEntityImpl) {
                    billNo = ((PreComputatorExecutionEntityImpl)execution).getBillNo();
                } else if (execution instanceof TaskEntityImpl) {
                    billNo = ((TaskEntityImpl)execution).getBillNo();
                }
                if (Objects.isNull(billNo)) {
                    LOGGER.info("Can not got bill no.");
                    return false;
                }
                WorkflowElement currentFlowElement = execution.getCurrentFlowElement();
                String template = ((AuditTask)currentFlowElement).getTemplate();
                String entityNumber = execution.getEntityNumber();
                QFilter numberFilter = new QFilter("billno", "=", (Object)billNo);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{numberFilter});
                if (dynamicObject == null) break block12;
                Long billId = dynamicObject.getLong("id");
                try {
                    DynamicObject instanceDyn = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSActivityGroupInsService", (String)"queryActivityGroupInsById", (Object[])new Object[]{billId});
                    if (instanceDyn == null) {
                        return false;
                    }
                    DynamicObjectCollection entryentity = instanceDyn.getDynamicObjectCollection("entryentity");
                    List activityNumbers = entryentity.stream().filter(entry -> "1".equals(entry.getString("status"))).map(entry -> entry.getString("activity.number")).collect(Collectors.toList());
                    if (!activityNumbers.contains(template)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            catch (Exception exception) {
                LOGGER.error("Got exception when invoke method.", (Throwable)exception);
            }
        }
        return false;
    }
}

