/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.ext.data.idi.model.EntryColumnHighLight;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.ext.data.idi.model.HighLightHandler;
import kd.bos.form.AbstractFormView;

public class KeyWordHighLight
extends BaseHighLight {
    private EntryColumnHighLight[] entryColumnHighLights;
    protected Map<String, EntryColumnHighLight> cacheEntryHighLightIndex;

    public EntryColumnHighLight[] getEntryColumnHighLights() {
        return this.entryColumnHighLights;
    }

    public void setEntryColumnHighLights(EntryColumnHighLight[] entryColumnHighLights) {
        this.entryColumnHighLights = entryColumnHighLights;
    }

    public void createCache() {
        this.cacheEntryHighLightIndex = new HashMap<String, EntryColumnHighLight>(5);
        if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
            for (EntryColumnHighLight entryHighLight : this.entryColumnHighLights) {
                this.cacheEntryHighLightIndex.put(entryHighLight.getEntryName(), entryHighLight);
            }
        }
    }

    public HighLightCursor previousCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        this.createCache();
        if (curHighLightCursor.isHead()) {
            return this.previousHeadFieldCursor(curHighLightCursor.getHeadField());
        }
        EntryColumnHighLight[] entryHighLights = this.getEntryColumnHighLights();
        boolean returnHead = false;
        for (int i = 0; i < entryHighLights.length; ++i) {
            EntryColumnHighLight entryHighLight = entryHighLights[i];
            if (!entryHighLight.getEntryName().equals(curHighLightCursor.getEntryName())) continue;
            HighLightCursor cursor = entryHighLight.previousCursor(curHighLightCursor);
            if (cursor == null) {
                returnHead = true;
                break;
            }
            return cursor;
        }
        if (returnHead) {
            return this.previousHeadFieldCursor(curHighLightCursor.getEntryName());
        }
        return null;
    }

    private HighLightCursor previousHeadFieldCursor(String headFieldOrEntryName) {
        int i;
        String[] headFields = this.getHeadFields();
        if (headFields == null || headFields.length <= 0) {
            if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
                headFields = new String[this.entryColumnHighLights.length];
                for (i = 0; i < this.entryColumnHighLights.length; ++i) {
                    headFields[i] = this.entryColumnHighLights[i].getEntryName();
                }
            } else {
                return null;
            }
        }
        for (i = 0; i < headFields.length; ++i) {
            EntryColumnHighLight entryHighLight;
            if (!headFieldOrEntryName.equals(headFields[i])) continue;
            int preIndex = i - 1;
            if (preIndex < 0) {
                preIndex += headFields.length;
            }
            if ((entryHighLight = this.cacheEntryHighLightIndex.get(headFields[preIndex])) == null) {
                return new HighLightCursor(headFields[preIndex]);
            }
            HighLightCursor cursor = entryHighLight.findEnd();
            if (cursor == null) continue;
            return cursor;
        }
        return null;
    }

    private HighLightCursor nextHeadFieldCursor(String headFieldOrEntryName) {
        int i;
        String[] headFields = this.getHeadFields();
        if (headFields == null || headFields.length <= 0) {
            if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
                headFields = new String[this.entryColumnHighLights.length];
                for (i = 0; i < this.entryColumnHighLights.length; ++i) {
                    headFields[i] = this.entryColumnHighLights[i].getEntryName();
                }
            } else {
                return null;
            }
        }
        for (i = 0; i < headFields.length; ++i) {
            EntryColumnHighLight entryHighLight;
            if (!headFieldOrEntryName.equals(headFields[i])) continue;
            int nextIndex = i + 1;
            if (nextIndex >= headFields.length) {
                nextIndex %= headFields.length;
            }
            if ((entryHighLight = this.cacheEntryHighLightIndex.get(headFields[nextIndex])) == null) {
                return new HighLightCursor(headFields[nextIndex]);
            }
            HighLightCursor cursor = entryHighLight.findFirst();
            if (cursor == null) continue;
            return cursor;
        }
        return null;
    }

    public HighLightCursor nextCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        this.createCache();
        if (curHighLightCursor.isHead()) {
            return this.nextHeadFieldCursor(curHighLightCursor.getHeadField());
        }
        EntryColumnHighLight[] entryHighLights = this.getEntryColumnHighLights();
        boolean returnHead = false;
        for (int i = 0; i < entryHighLights.length; ++i) {
            EntryColumnHighLight entryHighLight = entryHighLights[i];
            if (!entryHighLight.getEntryName().equals(curHighLightCursor.getEntryName())) continue;
            HighLightCursor cursor = entryHighLight.nextCursor(curHighLightCursor);
            if (cursor == null) {
                returnHead = true;
                break;
            }
            return cursor;
        }
        if (returnHead) {
            return this.nextHeadFieldCursor(curHighLightCursor.getEntryName());
        }
        return null;
    }

    public HighLightCursor findFirstCursor() {
        block4: {
            block3: {
                String[] headFields = this.getHeadFields();
                if (headFields == null || headFields.length <= 0) break block3;
                this.createCache();
                for (int i = 0; i < headFields.length; ++i) {
                    EntryColumnHighLight entryHighLight = this.cacheEntryHighLightIndex.get(headFields[i]);
                    if (entryHighLight == null) {
                        return new HighLightCursor(headFields[i]);
                    }
                    HighLightCursor cursor = entryHighLight.findFirst();
                    if (cursor == null) continue;
                    return cursor;
                }
                break block4;
            }
            EntryColumnHighLight[] entryHighLights = this.getEntryColumnHighLights();
            if (entryHighLights == null || entryHighLights.length <= 0) break block4;
            for (EntryColumnHighLight entryHighLight : entryHighLights) {
                HighLightCursor cursor = entryHighLight.findFirst();
                if (cursor == null) continue;
                return cursor;
            }
        }
        return null;
    }

    public void createHighLightCommand(AbstractFormView billView, HighLightCursor cursor) {
        if (billView == null) {
            return;
        }
        String[] headFields = this.getHeadFields();
        if (headFields != null && headFields.length > 0) {
            HashSet<String> entryNameSet = new HashSet<String>(3);
            if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
                for (EntryColumnHighLight entryColumnHighLight : this.entryColumnHighLights) {
                    entryNameSet.add(entryColumnHighLight.getEntryName());
                }
            }
            Object[] objectArray = headFields;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object field = objectArray[i];
                if (entryNameSet.contains(field)) continue;
                Map<String, Object> ctls = HighLightHandler.createHeadCommand((String)field, cursor != null && cursor.isHead() && cursor.ignoreHeadField((String)field));
                billView.updateControlMetadata((String)field, ctls);
            }
        }
        if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
            for (EntryColumnHighLight entryColumnHighLight : this.entryColumnHighLights) {
                entryColumnHighLight.createHighLightCommand(billView, cursor);
            }
        }
        HighLightHandler.createScrollIntoView(cursor, billView);
    }

    public void createHighLightCommandToNewCursor(AbstractFormView billView, HighLightCursor newCursor) {
        if (billView == null) {
            return;
        }
        if (newCursor != null && newCursor.isHead()) {
            Map<String, Object> ctls = HighLightHandler.createHeadCommand(newCursor.getHeadField(), true);
            billView.updateControlMetadata(newCursor.getHeadField(), ctls);
        } else if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
            for (EntryColumnHighLight entryColumnHighLight : this.entryColumnHighLights) {
                entryColumnHighLight.createHighLightCommandToNewCursor(billView, newCursor);
            }
        }
        HighLightHandler.createScrollIntoView(newCursor, billView);
    }

    public void createCommandToCancel(AbstractFormView billView) {
        if (billView == null) {
            return;
        }
        String[] headFields = this.getHeadFields();
        if (headFields != null && headFields.length > 0) {
            for (String field : headFields) {
                Map<String, Object> ctls = HighLightHandler.createHeadCommandCancel(field);
                billView.updateControlMetadata(field, ctls);
            }
        }
        if (this.entryColumnHighLights != null && this.entryColumnHighLights.length > 0) {
            for (EntryColumnHighLight entryColumnHighLight : this.entryColumnHighLights) {
                entryColumnHighLight.createCommandToCancel(billView);
            }
        }
    }
}

