/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.validation.DeleteTransferBillValidator;
import kd.bos.ext.scmc.validation.TransferBillValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DeleteTransferBillOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(DeleteTransferBillOpAction.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TransferBillValidator());
        e.addValidator((AbstractValidator)new DeleteTransferBillValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities2 = e.getDataEntities();
        if (dataEntities2 == null || dataEntities2.length < 1) {
            return;
        }
        String billmapping = this.getOption().getVariableValue("billmapping", null);
        if (StringUtils.isBlank((CharSequence)billmapping)) {
            return;
        }
        Map billMapping = (Map)SerializationUtils.fromJsonString((String)billmapping, Map.class);
        if (billMapping == null || billMapping.isEmpty()) {
            return;
        }
        this.deleteTransferBill(dataEntities2, billMapping);
    }

    private void deleteTransferBill(DynamicObject[] dataEntities2, Map<Long, List<Long>> billMapping) {
        try {
            String formId = dataEntities2[0].getDynamicObjectType().getName();
            ArrayList<Long> successPkIds = new ArrayList<Long>(10);
            for (DynamicObject bill : dataEntities2) {
                String billstatus = bill.getString("billstatus");
                if (!"A".equals(billstatus)) continue;
                successPkIds.add((Long)bill.getPkValue());
            }
            if (successPkIds.isEmpty()) {
                return;
            }
            ArrayList<Long> needDeleteTransferId = new ArrayList<Long>(10);
            for (Map.Entry<Long, List<Long>> entry : billMapping.entrySet()) {
                Long srcBillId = entry.getKey() instanceof Long ? entry.getKey() : Long.valueOf(Long.parseLong(String.valueOf(entry.getKey())));
                if (!successPkIds.contains(srcBillId)) continue;
                List<Long> transferBillId = entry.getValue();
                needDeleteTransferId.addAll(transferBillId);
            }
            if (needDeleteTransferId == null || needDeleteTransferId.isEmpty()) {
                return;
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"VMIService", (String)"deleteTransferBill", (Object[])new Object[]{formId, successPkIds, needDeleteTransferId});
            if (result != null && !result.isEmpty() && result.get("success") instanceof Boolean && !((Boolean)result.get("success")).booleanValue() && result.get("message") instanceof String && StringUtils.isNotBlank(result.get("message"))) {
                String message = (String)result.get("message");
                log.error("scmc-pm: VMIService.deleteTransferBill failure --> " + message);
                throw new KDBizException(message);
            }
        }
        catch (Exception ex) {
            log.error("\u5220\u9664\u7269\u6743\u8f6c\u79fb\u5355\u51fa\u9519\uff0c", (Throwable)ex);
            throw ex;
        }
        finally {
            this.releaseVMIOPMutex();
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.releaseVMIOPMutex();
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.releaseVMIOPMutex();
    }

    private void releaseVMIOPMutex() {
        String mutexedids = this.getOption().getVariableValue("mutexedids", null);
        if (StringUtils.isBlank((CharSequence)mutexedids)) {
            return;
        }
        List billids = (List)SerializationUtils.fromJsonString((String)mutexedids, List.class);
        if (billids == null || billids.isEmpty()) {
            return;
        }
        log.info("\u91ca\u653e\u7f51\u7edc\u4e92\u65a5\u9501\u5f00\u59cb\uff0c" + billids.size());
        HashSet<Long> releaseSuccessIds = new HashSet<Long>(10);
        if (billids == null || billids.isEmpty()) {
            return;
        }
        String entityKey = "pm_transferbill";
        try (DataMutex dataMutex = DataMutex.create();){
            ArrayList mutexRequireList = new ArrayList(1);
            for (Long billId : billids) {
                if (billId == null || billId.compareTo(0L) == 0) continue;
                HashMap<String, String> requireParam = new HashMap<String, String>();
                requireParam.put("dataObjId", billId.toString());
                requireParam.put("groupId", "default_netctrl");
                requireParam.put("entityKey", entityKey);
                requireParam.put("operationKey", "vmioperate");
                mutexRequireList.add(requireParam);
            }
            Map mutexResult = dataMutex.batchRelease(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                if (!ret.booleanValue()) continue;
                releaseSuccessIds.add(Long.parseLong(objId));
            }
        }
        catch (Exception e) {
            log.error("VMI\u91ca\u653e\u4e92\u65a5\u9501\u5f02\u5e38\uff0c", (Throwable)e);
        }
        if (!releaseSuccessIds.isEmpty()) {
            billids.removeAll(releaseSuccessIds);
            if (billids.isEmpty()) {
                this.getOption().removeVariable("mutexedids");
            } else {
                this.getOption().setVariableValue("mutexedids", SerializationUtils.toJsonString((Object)billids));
            }
        }
        log.info("\u91ca\u653e\u7f51\u7edc\u4e92\u65a5\u9501\u7ed3\u675f\uff0c\u91ca\u653e\u6210\u529f\u5730\u5355\u636e\u4e3a" + releaseSuccessIds.size());
    }
}

