/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule.asyncop.settle;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;

public class GenerateSettleECOpAction
extends AbstractOpBizRuleAction {
    private static final String SCENES_CODE = "ism_intersettle";
    private static final String SERVICE_NAME = "InterSettleECService";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        OperateOption option = this.getOption();
        boolean isIgnore = "true".equalsIgnoreCase(option.getVariableValue("ismoperate", "false"));
        if (isIgnore) {
            return;
        }
        this.callECService(e.getDataEntities());
        super.endOperationTransaction(e);
    }

    private void callECService(DynamicObject[] entities) {
        if (entities == null || entities.length == 0) {
            return;
        }
        BillEntityType entityType = (BillEntityType)entities[0].getDataEntityType();
        String entityTypeStr = entityType.getName();
        String idKey = entityType.getPrimaryKey().getName();
        ArrayList<Long> billIds = new ArrayList<Long>(entities.length);
        ArrayList<String> bussinesInfos = new ArrayList<String>(entities.length);
        for (DynamicObject entity : entities) {
            long id = entity.getLong(idKey);
            billIds.add(id);
            bussinesInfos.add(entityTypeStr + "#" + id);
        }
        CommonParam param = new CommonParam();
        param.put((Object)"entitytype", (Object)entityType.getName());
        param.put((Object)"ids", (Object)SerializationUtils.toJsonString(billIds));
        param.put((Object)"curuserid", (Object)RequestContext.get().getUserId());
        try {
            GenerateSettleECOpAction.execute(entityType.getDBRouteKey(), bussinesInfos, (Param)param);
        }
        catch (Exception e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static void execute(String dbRoute, List<String> businessInfo, Param param) throws Exception {
        ECGlobalSession.begin((String)SCENES_CODE, (DBRoute)DBRoute.of((String)dbRoute), (Propagation)Propagation.REQUIRES_NEW);
        ECGlobalSession.register((String)"scmc", (String)"ism", (String)SERVICE_NAME, (Param)param, null, (String)null);
        ECGlobalSession.setBusinessType((String)"GenerateSettleECOpAction");
        if (CollectionUtils.isNotEmpty(businessInfo)) {
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.setAsync((boolean)true);
    }
}

