/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.bizrule.asyncop.sn;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.sn.constant.SCMCBillEntryConst;
import kd.bos.ext.scmc.sn.helper.SerialNumberHelper;
import kd.bos.ext.scmc.validation.SerialNumberSaveValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SNHandleOpAction
extends AbstractOpBizRuleAction {
    private boolean isFromDataBase = true;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        SCMCBillEntryConst.getSelectorListForAcc().forEach(field -> e.getFieldKeys().add(field));
        SNHandleOpAction.getSubEntryList().forEach(field -> e.getFieldKeys().add(field));
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.afterentity.seq");
        String billType = this.billEntityType.getName();
        Set<String> serialCols = SerialNumberHelper.getSerialCols(billType);
        e.getFieldKeys().addAll(serialCols);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String operationKey = (String)this.operateMeta.get("type");
        if ("save".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities != null && dataEntities.length != 0) {
                this.isFromDataBase = dataEntities[0].getDataEntityState().getFromDatabase();
                if (this.isFromDataBase) {
                    e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
                }
            }
        } else if ("delete".equals(operationKey) || "submit".equals(operationKey) || "unaudit".equals(operationKey)) {
            e.addValidator((AbstractValidator)new SerialNumberSaveValidator());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        try (TraceSpan span = Tracer.create((String)"BillTplSaveOp", (String)"endOperationTransaction");){
            DynamicObject[] entities = e.getDataEntities();
            if (entities == null || entities.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff01", (String)"SNHandleOpAction_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            String operationKey = e.getOperationKey();
            if ("save".equals(operationKey)) {
                SerialNumberHelper.saveSNHandle(entities, this.isFromDataBase);
            } else if ("delete".equals(operationKey)) {
                SerialNumberHelper.operateCallSNService(e.getDataEntities(), operationKey);
            } else if ("audit".equals(operationKey)) {
                SerialNumberHelper.callSnService(entities, operationKey);
            } else if ("submit".equals(operationKey) || "unsubmit".equals(operationKey) || "unaudit".equals(operationKey)) {
                SerialNumberHelper.operateCallSNService(e.getDataEntities(), operationKey);
            }
        }
    }

    public static List<String> getSubEntryList() {
        List<String> selectors = Arrays.asList("ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "warehouse", "location", "lot", "lotnumber", "producedate", "expirydate", "project", "baseunit", "baseqty", "qty", "unit2nd", "qtyunit2nd", "entrycomment");
        selectors.forEach(field -> selectors.set(selectors.indexOf(field), field + "1"));
        return selectors;
    }
}

