/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.operation;

import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.ext.scmc.changemodel.helper.ChangeDisplayHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeLogHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.form.IFormController;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReviseOp
extends FormOperate
implements IConfirmCallBack {
    private OperationResult operationResult = new OperationResult();

    public OperationResult invokeOperation() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(((Object)((Object)this)).getClass().getName(), (IConfirmCallBack)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5bf9\u5f53\u524d\u5355\u636e\u8fdb\u884c\u66f4\u6b63\uff1f", (String)"ReviseOp_9", (String)"bos-ext-scmc", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        return this.operationResult;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        MessageBoxResult result = e.getResult();
        String callBackId = e.getCallBackId();
        if (((Object)((Object)this)).getClass().getName().equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            if (this.getView() instanceof IListView) {
                this.invokeListOperation();
            } else {
                this.invokeBillOperation();
            }
        }
    }

    private void invokeListOperation() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"ReviseOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
        } else {
            String entityId = ((IListView)this.getView()).getBillFormId();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (pks.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u4efb\u4f55\u6570\u636e\uff0c\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff01", (String)"ReviseOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            if (pks.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u66f4\u6b63\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ReviseOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            if (!QueryServiceHelper.exists((String)entityId, (Object)pks[0])) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"ReviseOp_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            Boolean isCanRevise = ChangeModelHelper.isBillCanRevise(entityId, (Long)pks[0]);
            if (!Boolean.TRUE.equals(isCanRevise)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(entityId);
            if (canReviseFields == null || canReviseFields.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u4e2d\u4e0d\u5b58\u5728\u53ef\u66f4\u6b63\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            String changeStatus = ChangeLogHelper.getChangeStatus(entityId, pks[0]);
            if ("B".equals(changeStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_7", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            if ("B2".equals(changeStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u66f4\u6b63\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
                this.operationResult.setSuccess(false);
                return;
            }
            String billNo = selectedRows.get(0).getBillNo();
            MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pks[0]), billNo, "default_netctrl", entityId, this.getOperateKey(), true, null);
            StringBuilder errorMsg = new StringBuilder();
            boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errorMsg);
            if (!isMutexLocked) {
                this.getView().showTipNotification(errorMsg.toString());
                this.operationResult.setSuccess(false);
                return;
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(entityId);
            billShowParameter.setPkId(pks[0]);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.EDIT);
            billShowParameter.setCustomParam("opkey" + pks[0], (Object)"revise");
            billShowParameter.addCustPlugin("kd.bos.ext.scmc.changemodel.plugin.ReviseFormPlugin");
            this.getView().getPageCache().put("isRevise" + pks[0], "true");
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void invokeBillOperation() {
        String changeStatusProp;
        IDataModel model = this.getView().getModel();
        if (!(model instanceof IBillModel)) {
            return;
        }
        IFormController formController = (IFormController)this.getView().getService(IFormController.class);
        if (formController == null) {
            return;
        }
        String entityId = this.getView().getFormShowParameter().getFormId();
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Object pkId = ((IBillModel)this.getView().getModel()).getPKValue();
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        IValidatorHanlder pkProp = (IValidatorHanlder)this.getView().getModel().getDataEntityType().getPrimaryKey();
        if (billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW || pkProp.getValueComparator().compareValue(pkId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u65b0\u589e\u72b6\u6001\u4e0b\u6267\u884c\u66f4\u6b63\u64cd\u4f5c\u3002", (String)"ReviseOp_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        Boolean isCanRevise = ChangeModelHelper.isBillCanRevise(entityId, (Long)pkId);
        if (!Boolean.TRUE.equals(isCanRevise)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(entityId);
        if (canReviseFields == null || canReviseFields.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u65b9\u6848\u4e2d\u4e0d\u5b58\u5728\u53ef\u66f4\u6b63\u7684\u5b57\u6bb5\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        String changeStatus = ChangeLogHelper.getChangeStatus(entityId, pkId);
        if ("B".equals(changeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_7", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        if ("B2".equals(changeStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u66f4\u6b63\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u66f4\u6b63\u3002", (String)"ReviseOp_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.operationResult.setSuccess(false);
            return;
        }
        String billNo = "";
        if (((BillEntityType)dataEntityType).getBillNo() != null) {
            billNo = model.getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
        }
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), billNo, "default_netctrl", entityId, this.getOperateKey(), true, null);
        StringBuilder errorMsg = new StringBuilder();
        boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errorMsg);
        if (!isMutexLocked) {
            this.getView().showTipNotification(errorMsg.toString());
            this.operationResult.setSuccess(false);
            return;
        }
        ChangeDisplayHelper.setReviseDisplay(this.getView(), canReviseFields);
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(entityId);
        if (fieldMapping != null && (changeStatusProp = fieldMapping.get("changestatus")) != null && dataEntityType.getProperty(changeStatusProp) != null) {
            this.getView().getModel().setValue(changeStatusProp, (Object)"B1");
            this.getView().getModel().setDataChanged(false);
        }
        billShowParameter.addCustPlugin("kd.bos.ext.scmc.changemodel.plugin.ReviseFormPlugin");
        billShowParameter.setCustomParam("opkey" + pkId, (Object)"revise");
        this.getView().cacheFormShowParameter();
    }
}

