/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.operation;

import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.changemodel.helper.ChangeDisplayHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeLogHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;

public class ReviseSubmitOp
extends DefaultEntityOperate {
    private static final Log log = LogFactory.getLog(ReviseSubmitOp.class);

    protected boolean beforeInvokeOperation(OperationResult result) {
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(this.getEntityId());
        if (fieldMapping != null) {
            fieldMapping.forEach((k, v) -> this.getOption().setVariableValue(k, v));
        }
        if (this.getView() instanceof IBillView) {
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey" + pkValue);
            if (StringUtils.isNotEmpty((CharSequence)opKey)) {
                this.getOption().setVariableValue("isNeedValidStatus", "false");
            } else {
                this.getOption().setVariableValue("isNeedValidStatus", "true");
            }
            Object pk = this.getView().getModel().getDataEntity().getPkValue();
            String status = ChangeLogHelper.getChangeStatusByLog(this.getEntityId(), pk);
            if (StringUtils.isEmpty((CharSequence)opKey) && !"B1".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u201c\u66f4\u6b63\u201d\u64cd\u4f5c\uff0c\u518d\u8fdb\u884c\u201c\u66f4\u6b63\u63d0\u4ea4\u201d\u3002", (String)"ReviseSubmitOp_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            boolean isChanged = this.getView().getModel().getDataChanged();
            if (StringUtils.isNotEmpty((CharSequence)opKey) && !"B1".equals(status) && !isChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u53d1\u751f\u6539\u53d8\uff0c\u65e0\u9700\u91cd\u590d\u201c\u66f4\u6b63\u63d0\u4ea4\u201d\u3002", (String)"ReviseSubmitOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        } else {
            this.getOption().setVariableValue("isNeedValidStatus", "true");
        }
        return true;
    }

    protected OperationResult callBillOperationService() {
        try {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            OperationServiceImpl operationService = new OperationServiceImpl();
            OperationResult opResult = operationService.localInvokeOperation(this.getOperateKey(), new DynamicObject[]{dataEntity}, this.getOption());
            return opResult;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u201c\u66f4\u6b63\u63d0\u4ea4\u201d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d8\u66f4\u65b9\u6848\u76f8\u5173\u914d\u7f6e\u3002", (String)"ReviseSubmitOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        if (opResult.isSuccess() && this.getView() instanceof IBillView) {
            Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(this.getEntityId());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
            DynamicProperty prop = dataEntityType.getProperty(fieldMapping.get("changestatus"));
            if (prop != null) {
                this.getView().getModel().setValue(prop.getName(), (Object)"B2");
            }
            Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(this.getEntityId());
            for (String field : canReviseFields) {
                IDataEntityType parent = dataEntityType.findProperty(field).getParent();
                if (parent instanceof EntryType) {
                    this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{field});
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{field});
            }
            ChangeDisplayHelper.clearChangeFieldMark(this.getView(), canReviseFields);
            Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
            String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey" + pkValue);
            if (StringUtils.isNotEmpty((CharSequence)opKey)) {
                String entityName = this.getView().getModel().getDataEntityType().getName();
                MutexHelper.release((String)entityName, (String)opKey, (String)String.valueOf(pkValue));
            }
            this.getView().getFormShowParameter().setCustomParam("opkey" + pkValue, null);
            this.getView().cacheFormShowParameter();
            this.getView().updateView();
        }
    }
}

