/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.plugin.CaLogRollbackValidator;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class CaLogRollbackPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CaLogRollbackPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.cagenerid");
        e.getFieldKeys().add("entryentity.sourceid");
        e.getFieldKeys().add("entryentity.sourcetype");
        e.getFieldKeys().add("entryentity.generatstatus");
        e.getFieldKeys().add("castatus");
        e.getFieldKeys().add("casourceid");
        e.getFieldKeys().add("casourcetype");
        e.getFieldKeys().add("wfparams");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CaLogRollbackValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            try {
                long srcBillId = data.getLong("casourceid");
                DynamicObject billTypeOb = data.getDynamicObject("casourcetype");
                this.rollBackBillOp(data);
                this.rollBackRemoteInterface(data);
                String billType = billTypeOb.getString("number");
                CommonUtil.removeAllReserveByBillRollBack(billType, srcBillId);
                this.rollBackSrmData(billType, srcBillId);
                data.set("castatus", (Object)"3");
            }
            finally {
                SaveServiceHelper.update((DynamicObject)data);
            }
        }
    }

    private void rollBackBillOp(DynamicObject data) {
        DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
        HashMap<String, List<Long>> caBilledMap = new HashMap<String, List<Long>>(16);
        HashMap<String, List<Long>> caBillMap = new HashMap<String, List<Long>>(16);
        for (DynamicObject entry : entryEntity) {
            long generateBillPk = entry.getLong("cagenerid");
            long sourceId = entry.getLong("sourceid");
            DynamicObject billType = entry.getDynamicObject("sourcetype");
            String billTypeName = billType.getString("number");
            this.addBillCollection(caBilledMap, sourceId, billTypeName);
            this.addBillCollection(caBillMap, generateBillPk, billTypeName);
        }
        this.batchUpdateStatus(caBilledMap);
        this.billDoOp(caBillMap, data);
    }

    private void batchUpdateStatus(Map<String, List<Long>> caBilledMap) {
        for (Map.Entry<String, List<Long>> entry : caBilledMap.entrySet()) {
            this.updateCaBilledStatus(entry.getValue(), entry.getKey());
        }
    }

    private void billDoOp(Map<String, List<Long>> caBilledMap, DynamicObject data) {
        OperateOption option = CommonUtil.getCaOption();
        for (Map.Entry<String, List<Long>> entry : caBilledMap.entrySet()) {
            String billType = entry.getKey();
            QFilter qFilter = new QFilter("id", "in", entry.getValue());
            DynamicObjectCollection queryList = QueryServiceHelper.query((String)billType, (String)"id,billstatus", (QFilter[])qFilter.toArray());
            ArrayList<Object> auditBills = new ArrayList<Object>(8);
            ArrayList<Object> submitBills = new ArrayList<Object>(8);
            ArrayList<Object> saveBills = new ArrayList<Object>(8);
            for (DynamicObject ob : queryList) {
                String status = ob.getString("billstatus");
                Object id = ob.get("id");
                if ("C".equals(status)) {
                    auditBills.add(id);
                    saveBills.add(id);
                } else if ("B".equals(status)) {
                    submitBills.add(id);
                    saveBills.add(id);
                } else if ("A".equals(status)) {
                    saveBills.add(id);
                }
                this.executeOp(billType, auditBills, option, data, BillOpEnum.UNAUDIT);
                this.executeOp(billType, submitBills, option, data, BillOpEnum.UNSUBMIT);
                this.executeOp(billType, saveBills, option, data, BillOpEnum.DELETE);
            }
        }
    }

    private OperationResult executeOp(String billType, List<Object> generatBillList, OperateOption option, DynamicObject data, BillOpEnum op) {
        if (CollectionUtils.isEmpty(generatBillList)) {
            return null;
        }
        Object[] generaBills = generatBillList.toArray(new Object[generatBillList.size()]);
        OperationResult result = OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)billType, (Object[])generaBills, (OperateOption)option);
        this.setGenerateBillEntry(billType, result.getSuccessPkIds(), data, op);
        if (!result.isSuccess()) {
            String errDetail = CommonUtil.getErrDetail(result);
            logger.error(op.getOpName() + "\u51b2\u9500\u5355\u636e" + billType + "\u5931\u8d25\uff1a" + errDetail);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u51b2\u9500\u5355\u636e\u5931\u8d25\uff1a%2$s", (String)"ChargeAgainstOp_7", (String)"bos-ext-scmc", (Object[])new Object[0]), op.getOpName(), errDetail));
        }
        logger.info(op.getOpName() + "\u51b2\u9500\u5355\u636e\u6210\u529f");
        return result;
    }

    private void setGenerateBillEntry(String billType, List<Object> successPkIds, DynamicObject data, BillOpEnum op) {
        if (CollectionUtils.isEmpty(successPkIds)) {
            return;
        }
        DynamicObjectCollection entryEntitys = data.getDynamicObjectCollection("entryentity");
        HashSet<Object> pks = new HashSet<Object>(successPkIds);
        for (DynamicObject entry : entryEntitys) {
            long generateBillPk = entry.getLong("cagenerid");
            DynamicObject type = entry.getDynamicObject("sourcetype");
            String billTypeName = type.getString("number");
            if (!pks.contains(generateBillPk) || !billType.equals(billTypeName)) continue;
            switch (op) {
                case SAVE: {
                    entry.set("generatstatus", (Object)"1");
                    break;
                }
                case SUBMIT: {
                    entry.set("generatstatus", (Object)"2");
                    break;
                }
                case AUDIT: {
                    entry.set("generatstatus", (Object)"3");
                    break;
                }
                case DELETE: {
                    entry.set("generatstatus", (Object)"4");
                    break;
                }
                case UNAUDIT: {
                    entry.set("generatstatus", (Object)"1");
                    break;
                }
                case UNSUBMIT: {
                    entry.set("generatstatus", (Object)"1");
                    break;
                }
            }
        }
    }

    private void addBillCollection(Map<String, List<Long>> caBilledMap, long generateBillPk, String billTypeName) {
        List<Long> caBillList = caBilledMap.get(billTypeName);
        if (caBillList == null) {
            caBillList = new ArrayList<Long>(16);
        }
        caBillList.add(generateBillPk);
        caBilledMap.put(billTypeName, caBillList);
    }

    private void rollBackSrmData(String billType, long pk) {
        Map<String, Object> srmSyncData = CommonUtil.buildSrmSyncData(billType, pk, "0");
        if (srmSyncData != null) {
            logger.info("\u8c03\u7528\u534f\u540csrm\u63a5\u53e3,\u53c2\u6570\u4e3a:" + JSONObject.toJSONString(srmSyncData));
            Object o = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurWriteOffStatus", (Object[])new Object[]{srmSyncData});
            logger.info("\u8c03\u7528\u534f\u540csrm\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u4e3a:" + JSONObject.toJSONString((Object)o));
        }
    }

    private void rollBackRemoteInterface(DynamicObject data) {
        Map<String, List<Map<String, Object>>> listMap = this.getInterfaceRollbackParams(data);
        this.requestWf(listMap, "apWfResults", "ap", "writtenOffVerifyRollBack");
        this.requestWf(listMap, "apRedWfRecordResults", "ap", "redVerifyRecordRollBack");
        this.requestWf(listMap, "arWfResults", "ar", "writtenOffVerifyRollBack");
        this.requestWf(listMap, "arRedWfRecordResults", "ar", "redVerifyRecordRollBack");
    }

    private Map<String, List<Map<String, Object>>> getInterfaceRollbackParams(DynamicObject data) {
        String wfParams = data.getString("wfparams");
        Map listMap = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)wfParams)) {
                listMap = (Map)JSONUtils.cast((String)wfParams, Map.class);
            }
        }
        catch (IOException e1) {
            logger.error("JSON\u8f6c\u6362\u5f02\u5e38,", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"JSON\u8f6c\u6362\u5f02\u5e38", (String)"CaLogRollbackPlugin_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        return listMap;
    }

    private void requestWf(Map<String, List<Map<String, Object>>> jsonObject, String param, String appId, String method) {
        if (jsonObject == null) {
            return;
        }
        List<Map<String, Object>> apWfResults = jsonObject.get(param);
        CommonUtil.rollbackWfRecord(apWfResults, appId, method);
    }

    private void updateCaBilledStatus(List<Long> billIdList, String billType) {
        CaModelFieldCaChe modelField = new CaModelFieldCaChe();
        String isChargeOffed = modelField.getCaModelField(billType).getIsChargeOffed();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        String dbRouteKey = dataEntityType.getDBRouteKey();
        String sql = this.buidlUpdateSql(billIdList, isChargeOffed, dataEntityType);
        DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)sql, (Object[])new Object[]{Boolean.FALSE});
    }

    private String buidlUpdateSql(List<Long> billIdList, String isChargeOffed, MainEntityType dataEntityType) {
        DynamicProperty property = dataEntityType.getProperty(isChargeOffed);
        String dbField = property.getAlias();
        String alias = dataEntityType.getAlias();
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(alias).append(" set ").append(dbField).append(" = ? where fid in (");
        for (int i = 0; i < billIdList.size(); ++i) {
            Long aLong = billIdList.get(i);
            sql.append(aLong);
            if (i >= billIdList.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }
}

