/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.service.impl;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.ext.scmc.chargeagainst.log.CaLogVo;
import kd.bos.ext.scmc.chargeagainst.log.LogEntry;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class CaLogServiceImpl
implements CaLogService {
    private static final Log logger = LogFactory.getLog(CaLogServiceImpl.class);
    private CaLogVo vo = new CaLogVo();

    @Override
    public CaLogVo getCaLogVo() {
        return this.vo;
    }

    @Override
    public void saveCaLog() {
        this.saveLog(this.vo);
    }

    @Override
    public void setCaLogHead(DynamicObject bill) {
        String billNo = CommonUtil.getBillNo(bill);
        String billType = bill.getDataEntityType().getName();
        this.vo.setCaSourceType(billType);
        this.vo.setCaSourceBillno(billNo);
        this.vo.setCaSourceId(bill.getPkValue());
        this.vo.setTraceId(RequestContext.get().getTraceId());
    }

    @Override
    public void buildCaLogCaBillEntryData(DynamicObject caBill, DynamicObject copyBill) {
        List<LogEntry> list = this.getCaLogVo().getLogEntries();
        String billNoKey = ((BillEntityType)caBill.getDataEntityType()).getBillNo();
        String billNo = caBill.getString(billNoKey);
        LogEntry logEntry = new LogEntry();
        logEntry.setSource(caBill);
        logEntry.setSourceBillNo(billNo);
        logEntry.setSourceType(caBill.getDataEntityType().getName());
        logEntry.setCaGenerBillNo(CommonUtil.getBillNo(copyBill));
        logEntry.setCagener(copyBill);
        list.add(logEntry);
    }

    private void saveLog(CaLogVo vo) {
        try {
            Object[] save;
            DynamicObject caLog = BusinessDataServiceHelper.newDynamicObject((String)"im_chargeagainst_log");
            caLog.set("casourceid", vo.getCaSourceId());
            caLog.set("casourcebillno", (Object)vo.getCaSourceBillno());
            caLog.set("casourcetype", vo.getCaSourceType());
            caLog.set("cabillfailcause", (Object)vo.getCaBillFailcause());
            caLog.set("createdate", (Object)new Date());
            caLog.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            caLog.set("castatus", (Object)vo.getCastatus());
            caLog.set("wfparams", (Object)vo.getWfParamData());
            caLog.set("traceid", (Object)vo.getTraceId());
            DynamicObjectCollection caLogEntry = caLog.getDynamicObjectCollection("entryentity");
            List<LogEntry> list = vo.getLogEntries();
            for (LogEntry entry : list) {
                DynamicObject logEntry = caLogEntry.addNew();
                logEntry.set("sourcebillno", (Object)entry.getSourceBillNo());
                logEntry.set("sourceid", entry.getSourceBill().getPkValue());
                logEntry.set("sourcetype", entry.getSourceType());
                logEntry.set("cagenerbillno", (Object)entry.getCaGenerBillNo());
                logEntry.set("cagenerid", entry.getCagenerBill().getPkValue());
                logEntry.set("generatstatus", (Object)entry.getGeneratStatus());
                logEntry.set("failmessage", (Object)entry.getFailMessage());
            }
            if (null != vo.getPk()) {
                caLog.set("id", vo.getPk());
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"im_chargeagainst_log"), (Object[])new Object[]{vo.getPk()});
            }
            if ((save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{caLog})) != null && save.length > 0) {
                vo.setPk(caLog.getPkValue());
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u65e5\u5fd7\u51fa\u9519;", (Throwable)e);
        }
    }

    @Override
    public void updateCaLogStatusAndFailCause() {
        DynamicObject caLog = BusinessDataServiceHelper.loadSingle((Object)this.vo.getPk(), (String)"im_chargeagainst_log");
        caLog.set("castatus", (Object)this.vo.getCastatus());
        caLog.set("cabillfailcause", (Object)this.vo.getCaBillFailcause());
        List<LogEntry> list = this.vo.getLogEntries();
        DynamicObjectCollection caLogEntry = caLog.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : caLogEntry) {
            String sourceBillNo = entry.getString("sourcebillno");
            LogEntry entryLog = list.stream().filter(n -> sourceBillNo.equals(n.getSourceBillNo())).findFirst().orElse(null);
            if (entryLog == null) continue;
            entry.set("generatstatus", (Object)entryLog.getGeneratStatus());
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{caLog});
    }
}

