/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.handle.BillOpHandle;
import kd.bos.ext.scmc.chargeagainst.handle.RedBlueBillHandle;
import kd.bos.ext.scmc.chargeagainst.handle.RemoteServiceHandle;
import kd.bos.ext.scmc.chargeagainst.handle.RollbackHandle;
import kd.bos.ext.scmc.chargeagainst.log.CaLogVo;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.service.ChargeAgainstService;
import kd.bos.ext.scmc.chargeagainst.service.impl.CaLogServiceImpl;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.vo.CaPageVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ChargeAgainstServiceImpl
implements ChargeAgainstService {
    private static final Log logger = LogFactory.getLog(ChargeAgainstServiceImpl.class);
    private OperateOption option;
    private DynamicObject caBill;
    private CaLogService caLogService;
    private Boolean isRollback = Boolean.FALSE;
    private CaModelFieldCaChe modelField = new CaModelFieldCaChe();
    private RedBlueBillHandle redBlueBillHandle;
    private RemoteServiceHandle remoteServiceHandle;
    private BillOpHandle billOpHandle;
    private RollbackHandle rollbackHandle;

    public static ChargeAgainstService build(OperateOption option) {
        ChargeAgainstServiceImpl service = new ChargeAgainstServiceImpl();
        service.setOption(option);
        service.init();
        return service;
    }

    private void init() {
        this.caBill = this.getCaBilled();
        this.caLogService = new CaLogServiceImpl();
        String reason = this.getOption().getVariableValue("careason");
        String dateString = this.getOption().getVariableValue("cadate");
        Date caDate = new Date(Long.parseLong(dateString));
        String bookDateString = this.getOption().getVariableValue("bookDate");
        Date bookDate = new Date(Long.parseLong(bookDateString));
        CaPageVo caPageVo = new CaPageVo(this.caBill, reason, caDate, bookDate, this.modelField);
        this.remoteServiceHandle = RemoteServiceHandle.build(this.caLogService, caPageVo);
        this.redBlueBillHandle = RedBlueBillHandle.build(this.option, this.caLogService, this.remoteServiceHandle, caPageVo);
        this.billOpHandle = BillOpHandle.build(this.caLogService);
        this.rollbackHandle = RollbackHandle.build(this.remoteServiceHandle, this.redBlueBillHandle, this.billOpHandle, this.caLogService, caPageVo);
    }

    private DynamicObject getCaBilled() {
        String bills = this.getOption().getVariableValue("caBillPk");
        String billType = this.getOption().getVariableValue("caBillType");
        return BusinessDataServiceHelper.loadSingle((Object)bills, (String)billType);
    }

    @Override
    public void start() {
        try {
            this.caLogService.setCaLogHead(this.caBill);
            this.startCaService();
            this.getCaLogVo().setCastatus("1");
        }
        catch (Exception e) {
            logger.error("\u51b2\u9500\u5355\u636e\u64cd\u4f5c\u5931\u8d25 !", (Throwable)e);
            this.getCaLogVo().setCaBillFailcause(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.rollbackHandle.rollbackData();
            throw new KDBizException(e.getMessage());
        }
        finally {
            this.caLogService.saveCaLog();
        }
    }

    private void startCaService() {
        this.redBlueBillHandle.copyBillAndCaWfRecord(Collections.singletonList(this.caBill));
        this.updateCaBilledStatus(Boolean.TRUE);
        this.remoteServiceHandle.removeAllReserveByBill();
        this.billOpHandle.billOpService(this.redBlueBillHandle.getAllCaBill());
        this.remoteServiceHandle.caInterfaceService(this.redBlueBillHandle.getRedBlueBills());
    }

    @Override
    public void rollback() {
        logger.info("\u5f00\u59cb\u51b2\u9500\u56de\u6eda\u64cd\u4f5crollback");
        if (this.isRollback.booleanValue()) {
            this.rollbackHandle.rollbackData();
        }
        logger.info("\u5f00\u59cb\u51b2\u9500\u56de\u6eda\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public void setRollbackStatus(Boolean rollbackStatus, String failMessage) {
        this.isRollback = rollbackStatus;
        this.getCaLogVo().setCaBillFailcause(failMessage);
    }

    private CaLogVo getCaLogVo() {
        return this.caLogService.getCaLogVo();
    }

    private void updateCaBilledStatus(Boolean status) {
        Map<String, List<DynamicObject>> allCabilleds = this.redBlueBillHandle.getAllCaBilled();
        for (Map.Entry<String, List<DynamicObject>> cabilled : allCabilleds.entrySet()) {
            this.batchUpdate(status, cabilled);
        }
    }

    private void batchUpdate(Boolean status, Map.Entry<String, List<DynamicObject>> cabilled) {
        String billType = cabilled.getKey();
        List<DynamicObject> caBillList = cabilled.getValue();
        String isChargeOffed = this.modelField.getCaModelField(billType).getIsChargeOffed();
        for (DynamicObject ob : caBillList) {
            ob.set(isChargeOffed, (Object)status);
        }
        SaveServiceHelper.update((DynamicObject[])caBillList.toArray(new DynamicObject[caBillList.size()]));
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }
}

