/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.creditcontrol.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CreditDynamicRoleList
extends AbstractListPlugin {
    private Map<Object, String> creditControlStatusMap;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideToolBarItems();
        String init = this.getPageCache().get("init");
        if (init == null) {
            Toolbar toolBar = new Toolbar();
            toolBar.setKey("toolbarap");
            toolBar.setView(this.getView());
            toolBar.insertControls(0, this.createRuntimeBarItem());
            this.getPageCache().put("init", "true");
        }
    }

    private void hideToolBarItems() {
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        Map listToolBar = FormMetadataCache.getListToolBar((String)lsp.getBillFormId());
        List toolBarItems = (List)listToolBar.get("items");
        if (toolBarItems != null) {
            LinkedList<String> hiddenKeys = new LinkedList<String>();
            for (Map toolBarItem : toolBarItems) {
                Object op = toolBarItem.get("opk");
                if ("refresh".equals(op) || "close".equals(op)) continue;
                hiddenKeys.add((String)toolBarItem.get("id"));
            }
            this.getView().setVisible(Boolean.FALSE, hiddenKeys.toArray(new String[0]));
        }
    }

    private List<Map<String, Object>> createRuntimeBarItem() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("flexpanelap6");
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey("bar_creditcontrol");
        barItemAp.setId("bar_creditcontrol");
        barItemAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4fe1\u7528\u53d7\u63a7", (String)"CreditDynamicRoleList_0", (String)"bos-ext-scmc", (Object[])new Object[0])));
        barItemAp.setOperationStyle(Integer.valueOf(1));
        DropdownItem dropdownItem = new DropdownItem();
        dropdownItem.setId("bar_cancelcreditcontrol");
        dropdownItem.setKey("bar_cancelcreditcontrol");
        dropdownItem.setTitle(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u4fe1\u7528\u53d7\u63a7", (String)"CreditDynamicRoleList_1", (String)"bos-ext-scmc", (Object[])new Object[0])));
        barItemAp.getDropdownItems().add(dropdownItem);
        headPanelAp.getItems().add(barItemAp);
        return (List)headPanelAp.createControl().get("items");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_creditcontrol".equals(itemKey)) {
            this.setCreditControlStatus("1");
        } else if ("bar_cancelcreditcontrol".equals(itemKey)) {
            this.setCreditControlStatus("0");
            this.deleteArchive();
        }
    }

    private void setCreditControlStatus(String status) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            String errorMessage = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CreditDynamicRoleList_2", (String)"bos-ext-scmc", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMessage);
            return;
        }
        HashSet<Object> pks = new HashSet<Object>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            pks.add(row.getPrimaryKeyValue());
        }
        HashSet<Object> masterIds = new HashSet<Object>();
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObjectCollection baseDatas = QueryServiceHelper.query((String)lsp.getBillFormId(), (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        for (DynamicObject baseData : baseDatas) {
            masterIds.add(baseData.get("masterid"));
        }
        long roleId = this.getRoleId();
        if (roleId == 0L) {
            return;
        }
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter roleValueFilter = new QFilter("rolevalueid", "in", masterIds);
        DynamicObject[] statusDatas = BusinessDataServiceHelper.load((String)"ccm_controlstatus", (String)"role,rolevalueid,controlstatus", (QFilter[])new QFilter[]{roleFilter, roleValueFilter});
        HashSet notFoundPks = new HashSet(masterIds);
        for (DynamicObject data : statusDatas) {
            Object rolePk = data.get("rolevalueid");
            notFoundPks.remove(rolePk);
            data.set("controlstatus", (Object)status);
        }
        DynamicObject[] newStatusDatas = new DynamicObject[notFoundPks.size()];
        int index = 0;
        for (Object pk : notFoundPks) {
            DynamicObject newStatusData = BusinessDataServiceHelper.newDynamicObject((String)"ccm_controlstatus");
            newStatusData.set("role", (Object)roleId);
            newStatusData.set("rolevalueid", pk);
            newStatusData.set("controlstatus", (Object)status);
            newStatusDatas[index++] = newStatusData;
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])statusDatas);
                SaveServiceHelper.save((DynamicObject[])newStatusDatas);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refresh();
        String message = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"CreditDynamicRoleList_3", (String)"bos-ext-scmc", (Object[])new Object[0]);
        this.getView().showSuccessNotification(message);
    }

    private void refresh() {
        ListView view = (ListView)this.getView();
        view.refresh();
    }

    private long getRoleId() {
        Object roleId = this.getView().getFormShowParameter().getCustomParam("roleid");
        if (roleId == null) {
            return 0L;
        }
        return Long.parseLong(roleId.toString());
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        long roleId = this.getRoleId();
        if (roleId == 0L) {
            return;
        }
        DynamicObjectCollection datas = e.getPageData();
        HashSet<Object> masterIds = new HashSet<Object>(datas.size());
        for (DynamicObject data : datas) {
            masterIds.add(data.get("masterid"));
        }
        this.creditControlStatusMap = new HashMap<Object, String>(masterIds.size());
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter roleValueFilter = new QFilter("rolevalueid", "in", masterIds);
        DynamicObjectCollection statusDatas = QueryServiceHelper.query((String)"ccm_controlstatus", (String)"rolevalueid,controlstatus", (QFilter[])new QFilter[]{roleFilter, roleValueFilter});
        for (DynamicObject data : statusDatas) {
            this.creditControlStatusMap.put(data.get("rolevalueid"), data.getString("controlstatus"));
        }
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        Object source = e.getSource();
        if (source instanceof DynamicTextColumnDesc && "creditcontrolstatus".equals(key = ((DynamicTextColumnDesc)source).getKey())) {
            DynamicObject rowData = e.getRowData();
            Object pk = rowData.get("masterid");
            String status = this.creditControlStatusMap.get(pk);
            if (status == null) {
                String statusDisplayValue = ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"CreditDynamicRoleList_4", (String)"bos-ext-scmc", (Object[])new Object[0]);
                e.setFormatValue((Object)statusDisplayValue);
            } else if ("0".equals(status)) {
                String statusDisplayValue = ResManager.loadKDString((String)"\u9ed8\u8ba4", (String)"CreditDynamicRoleList_4", (String)"bos-ext-scmc", (Object[])new Object[0]);
                e.setFormatValue((Object)statusDisplayValue);
            } else if ("1".equals(status)) {
                String statusDisplayValue = ResManager.loadKDString((String)"\u53d7\u63a7", (String)"CreditDynamicRoleList_6", (String)"bos-ext-scmc", (Object[])new Object[0]);
                e.setFormatValue((Object)statusDisplayValue);
            } else {
                e.setFormatValue((Object)status);
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        DynamicTextListColumn col = new DynamicTextListColumn();
        String caption = ResManager.loadKDString((String)"\u4fe1\u7528\u53d7\u63a7\u72b6\u6001", (String)"CreditDynamicRoleList_7", (String)"bos-ext-scmc", (Object[])new Object[0]);
        col.setCaption(new LocaleString(caption));
        col.setKey("creditcontrolstatus");
        col.setFieldName("creditcontrolstatus");
        col.setSeq(3);
        col.setVisible(11);
        args.getDynamicTextListColumns().add(col);
        int insertIndex = 0;
        List listColumns = args.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            String key;
            IListColumn column = (IListColumn)listColumns.get(i);
            if (!(column instanceof ListColumn) || !"name".equals(key = ((ListColumn)column).getFieldKey())) continue;
            insertIndex = i;
            break;
        }
        listColumns.add(insertIndex + 1, col);
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString("masterid"));
        listColumn.setKey("masterid");
        listColumn.setListFieldKey("masterid");
        listColumn.setFieldName("masterid");
        listColumn.setVisible(0);
        args.addListColumn((IListColumn)listColumn);
    }

    private void deleteArchive() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        HashSet roleIdPks = new HashSet(selectedRows.size());
        selectedRows.stream().forEach(selectedRow -> roleIdPks.add(selectedRow.getPrimaryKeyValue()));
        HashSet<String> masterIds = new HashSet<String>(selectedRows.size());
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObjectCollection baseDatas = QueryServiceHelper.query((String)lsp.getBillFormId(), (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", roleIdPks)});
        baseDatas.stream().forEach(baseData -> masterIds.add(String.valueOf(baseData.getLong("masterid"))));
        List<Long> deleteArchiveIds = this.getDeleteArchiveIds(masterIds);
        if (!ObjectUtils.isEmpty(deleteArchiveIds)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ccm_archive"), (Object[])deleteArchiveIds.toArray(new Long[0]));
        }
    }

    private List<Long> getDeleteArchiveIds(Set<String> masterIds) {
        LinkedList<Long> deleteArchiveIds = new LinkedList<Long>();
        Object[] schemes = BusinessDataServiceHelper.load((String)"ccm_scheme", (String)"dimension", (QFilter[])new QFilter[]{new QFilter("autocreatearchive", "=", (Object)true)});
        if (ObjectUtils.isEmpty((Object[])schemes)) {
            return deleteArchiveIds;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(schemes.length);
        for (Object scheme : schemes) {
            DynamicObjectCollection entry = scheme.getDynamicObject("dimension").getDynamicObjectCollection("entry");
            if (entry.size() != 1) continue;
            schemeIds.add(scheme.getLong("id"));
        }
        QFilter filter = new QFilter("scheme", "in", schemeIds);
        filter.and(new QFilter("reducesum", "=", (Object)0));
        filter.and(new QFilter("increasesum", "=", (Object)0));
        filter.and(new QFilter("dimensionvalue", "in", masterIds));
        DynamicObjectCollection archives = QueryServiceHelper.query((String)"ccm_archive", (String)"id", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)archives)) {
            return deleteArchiveIds;
        }
        HashSet archiveIds = new HashSet(archives.size());
        archives.stream().forEach(archive -> archiveIds.add(archive.getLong("id")));
        DynamicObjectCollection archiveApplys = QueryServiceHelper.query((String)"ccm_archive_apply", (String)"entry.archiveid", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.archiveid", "in", archiveIds)});
        HashSet archiveIdsByApply = new HashSet(archiveApplys.size());
        archiveApplys.stream().forEach(archiveApply -> archiveIdsByApply.add(archiveApply.getLong("entry.archiveid")));
        LinkedList<Long> autoArchiveIds = new LinkedList<Long>();
        for (Long archive2 : archiveIds) {
            if (archiveIdsByApply.contains(archive2)) continue;
            autoArchiveIds.add(archive2);
        }
        DynamicObjectCollection journals = QueryServiceHelper.query((String)"ccm_journal", (String)"archiveid", (QFilter[])new QFilter[]{new QFilter("archiveid", "in", autoArchiveIds)});
        if (ObjectUtils.isEmpty((Object)journals)) {
            return autoArchiveIds;
        }
        HashSet archiveIdsByJournal = new HashSet(journals.size());
        journals.stream().forEach(journal -> archiveIdsByJournal.add(journal.getLong("archiveid")));
        for (Long autoArchiveId : autoArchiveIds) {
            if (archiveIdsByJournal.contains(autoArchiveId)) continue;
            deleteArchiveIds.add(autoArchiveId);
        }
        return deleteArchiveIds;
    }
}

