/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.creditcontrol.operation.bizrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class UpdateCreditBalanceOpAction
extends AbstractOpBizRuleAction {
    private static Log logger = LogFactory.getLog(UpdateCreditBalanceOpAction.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Set<String> creditEntityConfigField = UpdateCreditBalanceOpAction.getSelectors(this.billEntityType.getName());
        e.getFieldKeys().addAll(creditEntityConfigField);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] billArray = e.getDataEntities();
        if (billArray == null || billArray.length <= 0) {
            return;
        }
        logger.info("platform bos-ext updatecreditbalanceopaction begin to update balance.");
        this.defaultCreditUpdate(billArray);
        logger.info("platform bos-ext updatecreditbalanceopaction end.");
    }

    private void defaultCreditUpdate(DynamicObject[] billArray) {
        List checkResult;
        Map<String, List> results = this.invokeCreditService(billArray);
        if (results != null && (checkResult = results.get("checkResults")) != null) {
            for (Map result : checkResult) {
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue() || !"error".equals(result.get("messageType"))) continue;
                String billno = (String)result.get("billno");
                throw new KDBizException(billno + ":" + result.get("message"));
            }
        }
    }

    private Map<String, List> invokeCreditService(DynamicObject[] billArray) {
        String operationKey = (String)this.operateMeta.get("key");
        return (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ccm", (String)"CreditService", (String)"updateAndReturnLock", (Object[])new Object[]{billArray, operationKey});
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        DynamicObject[] dataEnitites = e.getDataEntitys();
        if (dataEnitites == null || dataEnitites.length == 0) {
            return;
        }
        logger.info("ccm: begin to rollback.");
        ArrayList<Long> rollBackIds = new ArrayList<Long>(dataEnitites.length);
        for (DynamicObject entity : dataEnitites) {
            rollBackIds.add(entity.getLong("id"));
        }
        this.rollBackJournal(rollBackIds);
        logger.info("ccm: rollback finished.");
    }

    private void rollBackJournal(List<Long> rollBackIds) {
        String operationKey = (String)this.operateMeta.get("key");
        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ccm", (String)"CreditService", (String)"rollbackCreditJournal", (Object[])new Object[]{rollBackIds, operationKey});
    }

    private static Set<String> getSelectors(String entityKey) {
        Set selectorFieldSet = (Set)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ccm", (String)"CreditService", (String)"getCreditEntityConfigField", (Object[])new Object[]{entityKey});
        return selectorFieldSet;
    }
}

