/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GenLotCodeNum
extends FormOperate {
    private Map<String, String> param = new HashMap<String, String>();
    private static final String COL_ENTRYFIELD = "entryfield";
    private static final String COL_MATERIAL = "material";
    private static final String COL_LOTMAP = "lotmap";
    private static Log logger = LogFactory.getLog(GenLotCodeNum.class);

    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Map mapParam = new HashMap();
        Object objValue = opMeta.get("parameter");
        Map paramValue = new HashMap();
        if (objValue instanceof Map) {
            paramValue = (Map)objValue;
        }
        if (StringUtils.isNotBlank(paramValue)) {
            Object paramJson = paramValue.get("parameter");
            mapParam = (Map)SerializationUtils.fromJsonString((String)((String)paramJson), Map.class);
            this.param.put(COL_ENTRYFIELD, (String)mapParam.get(COL_ENTRYFIELD));
            this.param.put(COL_MATERIAL, (String)mapParam.get(COL_MATERIAL));
            this.param.put(COL_LOTMAP, (String)mapParam.get(COL_LOTMAP));
        }
    }

    public OperationResult invokeOperation() {
        long begin = System.currentTimeMillis();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject cloneDataEntity = (DynamicObject)OrmUtils.clone((IDataEntityBase)dataEntity, (boolean)false, (boolean)true);
        int flag = 0;
        if (dataEntity != null) {
            String formId = dataEntity.getDataEntityType().getName();
            for (DynamicObject row : cloneDataEntity.getDynamicObjectCollection(this.param.get(COL_ENTRYFIELD))) {
                String lotnum = row.getString(this.param.get(COL_LOTMAP));
                if ("im_transdirbill".equals(formId)) {
                    DynamicObject org = dataEntity.getDynamicObject("org");
                    DynamicObject material = row.getDynamicObject(this.param.get(COL_MATERIAL));
                    if (null == material) continue;
                    DynamicObject inMaterial = this.getInMaterial(org, material);
                    if (null != inMaterial) {
                        row.set(this.param.get(COL_MATERIAL), (Object)inMaterial);
                    }
                }
                if (!row.getBoolean(this.param.get(COL_MATERIAL) + ".enablelot") || lotnum == null || !StringUtils.isEmpty((CharSequence)lotnum.trim())) continue;
                ++flag;
            }
        }
        if (flag == 0) {
            return super.invokeOperation();
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{cloneDataEntity, this.param});
        long end = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u6279\u53f7\u603b\u65f6\u95f4\uff1a" + (end - begin) + "ms");
        String lotKey = this.param.get(COL_LOTMAP);
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>(12);
        for (Map.Entry entry : map.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            if (value.startsWith("ERROR")) {
                sb.append(value.substring("ERROR".length()));
                sb.append("\n");
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)value, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(GenLotCodeNum.getMsgGenLotCodeNumExp(), sb.toString(), MessageTypes.Commit);
        }
        return super.invokeOperation();
    }

    private static String getMsgGenLotCodeNumExp() {
        return ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"GenLotCodeNum_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
    }

    private DynamicObject getInMaterial(DynamicObject org, DynamicObject material) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bd_materialinventoryinfo");
        ArrayList selectorSet = new ArrayList(dt.getAllFields().keySet());
        DynamicObject[] materialinventory = BusinessDataServiceHelper.load((String)"bd_materialinventoryinfo", (String)String.join((CharSequence)",", selectorSet), (QFilter[])new QFilter[]{new QFilter("masterid.id", "=", (Object)material.getLong("masterid.id")), baseDataFilter});
        DynamicObject materialInfo = materialinventory[0];
        String privateCtrlStrategy = "7";
        for (DynamicObject dynamicObject : materialinventory) {
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if (!privateCtrlStrategy.equals(ctrlStrategy)) continue;
            materialInfo = dynamicObject;
        }
        return materialInfo;
    }
}

