/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.quote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.quote.events.AfterDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.events.BeforeDoQuoteEventArgs;
import kd.bos.ext.scmc.operation.quote.plugin.IQuoteDataHadler;
import kd.bos.ext.scmc.operation.quote.plugin.impl.QuoteDataHadler;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class QuoteOp
extends FormOperate
implements ICloseCallBack {
    private static final String PK_PLUGINS = "plugins";
    public static final String SPLIT = "\\.";
    public static final String RESULT_SPLIT = "\\$\\$";
    public static final String REGEX_SPLIT = "$$";
    public static final String ISCOVER_KEY = "iscover";
    private Map<String, Object> mapParam;
    private List<Integer> selectRows = new ArrayList<Integer>();
    private List<Integer> noPriceRows = new ArrayList<Integer>();
    private String orgPosition;
    private String orgEntry;
    private String orgSign;
    private boolean hasHeadPriceField;
    private boolean hasEntryPriceField;
    private String schemeEntry;
    private boolean islistener;
    private static String HEAD_FLAG = "header";
    private static String ENTRY_FLAG = "entry";
    private static String PRICE_FLAG = "result";

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map custParamObj = (Map)arg0.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    public OperationResult invokeOperation() {
        Map settingParam = (Map)this.mapParam.get("settingparam");
        String PluginsStr = (String)settingParam.get(PK_PLUGINS);
        String orgsign = (String)settingParam.get("orgsign");
        String islistener = (String)settingParam.get("islistener");
        this.islistener = "Y".equals(islistener);
        Set<Long> orgIds = this.collectOrgId(orgsign);
        HashMap<String, String> quoteParam = new HashMap<String, String>();
        quoteParam.put("auto", "0");
        Map priceMapKey = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{orgIds.toArray(new Long[orgIds.size()]), this.getEntityType(), quoteParam});
        ArrayList removeKey = new ArrayList(priceMapKey.size());
        priceMapKey.forEach((k, v) -> {
            if (v.get("success") == null || Boolean.FALSE.equals(v.get("success"))) {
                removeKey.add(k);
            }
        });
        removeKey.forEach(rk -> {
            Map cfr_ignored_0 = (Map)priceMapKey.remove(rk);
        });
        if (priceMapKey.size() == 0) {
            return super.invokeOperation();
        }
        if (!this.checkOrgPostion(priceMapKey)) {
            return super.invokeOperation();
        }
        HashMap<Long, List<Integer>> orgRowMap = new HashMap<Long, List<Integer>>();
        if (HEAD_FLAG.equals(this.orgPosition)) {
            IDataModel model = this.getView().getModel();
            DynamicObject org = (DynamicObject)model.getValue(this.orgSign);
            if (org != null) {
                orgRowMap.put((Long)org.getPkValue(), this.selectRows);
            }
        } else {
            this.buildSelectRows4Entry(orgRowMap);
        }
        if (orgRowMap.size() == 0) {
            return super.invokeOperation();
        }
        Map<Long, List<Map<String, Object>>> propertiesMap = this.buildMap4Entry(priceMapKey, orgRowMap, orgIds);
        Map priceMapObj = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"quoteByMapIgnoreExpWithParam", (Object[])new Object[]{propertiesMap, this.getEntityType(), quoteParam});
        ArrayList removeResultKey = new ArrayList(priceMapObj.size());
        priceMapObj.forEach((k, v) -> {
            if (v.get("success") == null || Boolean.FALSE.equals(v.get("success"))) {
                removeResultKey.add(k);
            }
        });
        removeResultKey.forEach(rk -> {
            Map cfr_ignored_0 = (Map)priceMapObj.remove(rk);
        });
        if (StringUtils.isNotBlank((CharSequence)PluginsStr)) {
            List pluginMap = (List)SerializationUtils.fromJsonString((String)PluginsStr, List.class);
            List<IQuoteDataHadler> pluginInstances = this.getAllplugins(pluginMap);
            BeforeDoQuoteEventArgs beforeArgs = new BeforeDoQuoteEventArgs(priceMapObj);
            beforeArgs.setModel(this.getView().getModel());
            int[] quoteRows = new int[this.selectRows.size()];
            for (int i = 0; i < this.selectRows.size(); ++i) {
                quoteRows[i] = this.selectRows.get(i);
            }
            beforeArgs.setSelectRows(quoteRows);
            AfterDoQuoteEventArgs afterArgs = new AfterDoQuoteEventArgs();
            afterArgs.setView(this.getView());
            afterArgs.setSelectRows(quoteRows);
            afterArgs.setIslistener(this.islistener);
            for (IQuoteDataHadler plugin2 : pluginInstances) {
                plugin2.beforeDoQuoteOperation(beforeArgs);
                if (!beforeArgs.cancel) continue;
                if (!StringUtils.isNotBlank((CharSequence)beforeArgs.getCancelMessage())) {
                    return null;
                }
                String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a%s", (String)"QuoteOp_1", (String)"bos-ext-scmc", (Object[])new Object[0]), beforeArgs.getCancelMessage());
                throw new KDBizException(message);
            }
            this.bindDataToModel(priceMapObj);
            pluginInstances.forEach(plugin -> plugin.afterDoQuoteOperation(afterArgs));
        } else {
            this.bindDataToModel(priceMapObj);
        }
        return super.invokeOperation();
    }

    private void setAllRows() {
        block4: {
            this.selectRows = new ArrayList<Integer>();
            if (!StringUtils.isNotEmpty((CharSequence)this.getSchemeEntry())) break block4;
            DynamicObjectCollection col = this.getView().getModel().getEntryEntity(this.getSchemeEntry());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.getSchemeEntry());
            if (entryGrid.getSelectRows().length == 0) {
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject entryInfo = (DynamicObject)col.get(i);
                    this.selectRows.add((Integer)entryInfo.get("seq") - 1);
                }
            } else {
                int[] selects;
                for (int rowIndex : selects = entryGrid.getSelectRows()) {
                    this.selectRows.add(rowIndex);
                }
            }
        }
    }

    private void setNoPriceRow(List<String> priceTotalFields, String schemeEntry) {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection col = model.getEntryEntity(schemeEntry);
        this.noPriceRows = new ArrayList<Integer>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)col.get(i);
            boolean needQuote = true;
            for (String filed : priceTotalFields) {
                if (!(entryInfo.get(filed) instanceof BigDecimal) || ((BigDecimal)entryInfo.get(filed)).compareTo(BigDecimal.ZERO) == 0) continue;
                needQuote = false;
                break;
            }
            if (!needQuote) continue;
            this.noPriceRows.add((Integer)entryInfo.get("seq") - 1);
        }
    }

    private Set<Long> collectOrgId(String orgsign) {
        HashSet<Long> orgIDSet = new HashSet<Long>();
        IDataModel model = this.getView().getModel();
        if (StringUtils.isEmpty((CharSequence)orgsign)) {
            String message = "\u53d6\u4ef7\u5931\u8d25\uff1a\u83b7\u53d6\u4ef7\u683c\u64cd\u4f5c\u672a\u914d\u7f6e\u3010\u53d6\u4ef7\u7ec4\u7ec7\u3011\u5b57\u6bb5\u3002";
            message = ResManager.loadKDString((String)message, (String)"QuoteOp_5", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String[] orgDevideFiled = orgsign.split(SPLIT);
        if (orgDevideFiled.length > 2) {
            String message = "\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u5927\u4e8e2\u3002";
            message = ResManager.loadKDString((String)message, (String)"QuoteOp_6", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (orgDevideFiled.length == 2) {
            this.orgSign = orgDevideFiled[orgDevideFiled.length - 1];
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)this.getEntityType());
            IDataEntityProperty orgProperty = (IDataEntityProperty)type.getAllFields().get(this.orgSign);
            if (orgProperty != null) {
                if (orgProperty.getParent() instanceof EntryType) {
                    this.orgEntry = orgDevideFiled[orgDevideFiled.length - 2];
                    DynamicObjectCollection colls = model.getEntryEntity(this.orgEntry);
                    this.orgSign = orgDevideFiled[orgDevideFiled.length - 1];
                    for (int i = 0; i < colls.size(); ++i) {
                        int row = (Integer)((DynamicObject)colls.get(i)).get("seq") - 1;
                        DynamicObject entryOrg = (DynamicObject)model.getValue(this.orgSign, row);
                        if (entryOrg == null) continue;
                        orgIDSet.add((Long)entryOrg.getPkValue());
                    }
                    this.orgPosition = ENTRY_FLAG;
                } else {
                    this.orgSign = orgDevideFiled[orgDevideFiled.length - 1];
                    DynamicObject org = (DynamicObject)model.getValue(this.orgSign);
                    if (org != null) {
                        orgIDSet.add((Long)org.getPkValue());
                    }
                    this.orgPosition = HEAD_FLAG;
                }
            }
        }
        if (orgIDSet.size() == 0) {
            String message = "\u53d6\u4ef7\u5931\u8d25\uff1a\u672a\u9009\u62e9\u53d6\u4ef7\u7ec4\u7ec7\u3002";
            message = ResManager.loadKDString((String)message, (String)"QuoteOp_4", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return orgIDSet;
    }

    private List<IQuoteDataHadler> getAllplugins(List<Map<String, Object>> pluginMap) {
        ArrayList<String> pluginNames = new ArrayList<String>();
        ArrayList<IQuoteDataHadler> pluginInstances = new ArrayList<IQuoteDataHadler>();
        if (pluginMap != null) {
            for (Map<String, Object> map : pluginMap) {
                pluginNames.add((String)map.get("ClassName"));
            }
        }
        try {
            if (pluginNames.size() > 0) {
                for (String pluginName : pluginNames) {
                    IQuoteDataHadler plugin = StringUtils.isNotBlank((CharSequence)pluginName) ? (IQuoteDataHadler)Class.forName(pluginName).newInstance() : new QuoteDataHadler();
                    pluginInstances.add(plugin);
                }
            }
            return pluginInstances;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String message = "\u53d6\u4ef7\u5931\u8d25\uff1a\u83b7\u53d6\u53d6\u4ef7\u63d2\u4ef6\u5f02\u5e38\u3002";
            message = ResManager.loadKDString((String)message, (String)"QuoteOp_2", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    private void bindDataToModel(Map<Long, Map<String, Object>> priceMapObj) {
        Object value;
        Object filed;
        Object fileds;
        IDataModel model = this.getView().getModel();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityType());
        Map allFields = mainEntityType.getAllFields();
        HashSet<Object> headFiledSet = new HashSet<Object>();
        HashSet<Object> entryFiledSet = new HashSet<Object>();
        ArrayList<Object> headFields = new ArrayList<Object>(16);
        for (Map<String, Object> map : priceMapObj.values()) {
            for (String priceKey : map.keySet()) {
                fileds = priceKey.split(RESULT_SPLIT);
                if (((String[])fileds).length != 2) continue;
                filed = fileds[1];
                value = map.get(priceKey);
                if (this.isRealChanged(model.getValue((String)filed), value)) {
                    headFields.add(filed);
                }
                if (value != null && "0".equals(value.toString())) continue;
                headFiledSet.add(filed);
                model.setValue((String)filed, value);
            }
        }
        if (headFields.size() > 0) {
            ArrayList headFieldsAlias = new ArrayList(headFields.size());
            MainEntityType mainEntityType2 = MetadataServiceHelper.getDataEntityType((String)this.getEntityType());
            Map map = mainEntityType2.getAllFields();
            StringBuilder tipMsg = new StringBuilder();
            for (String string : headFields) {
                headFieldsAlias.add(((IDataEntityProperty)map.get(string)).getDisplayName().getLocaleValue());
            }
            String message = ResManager.loadKDString((String)"\u5355\u5934\u5b57\u6bb5\uff1a%1$s \u53d1\u751f\u4e86\u53d8\u66f4\u6216\u88ab\u6e05\u7a7a\u3002", (String)"QuoteOp_8", (String)"bos-ext-scmc", (Object[])new Object[0]);
            tipMsg.append(String.format(message, String.join((CharSequence)",", headFieldsAlias)));
            this.getView().showSuccessNotification(tipMsg.toString());
        }
        if (!this.islistener) {
            model.beginInit();
        }
        for (Map map : priceMapObj.values()) {
            for (String priceKey : map.keySet()) {
                String string;
                Object iscover_value;
                fileds = priceKey.split(RESULT_SPLIT);
                if (((Object)fileds).length != 4) continue;
                filed = fileds[3];
                int rowindex = Integer.parseInt((String)fileds[2]) - 1;
                if (ISCOVER_KEY.equals(filed) || ((iscover_value = map.get(string = (String)fileds[0] + REGEX_SPLIT + (String)fileds[1] + REGEX_SPLIT + (String)fileds[2] + REGEX_SPLIT + ISCOVER_KEY)) == null || !"B".equals(iscover_value.toString())) && !this.noPriceRows.contains(rowindex)) continue;
                value = map.get(priceKey);
                if (allFields.get(filed) instanceof BasedataProp && value != null && (new Long("0").equals(value) || "0".equals(value.toString()))) {
                    value = null;
                }
                entryFiledSet.add(filed);
                model.setValue((String)filed, value, rowindex);
            }
        }
        if (!this.islistener) {
            model.endInit();
            headFiledSet.forEach(f -> this.getView().updateView(f));
            if (StringUtils.isNotEmpty((CharSequence)this.getSchemeEntry()) && this.selectRows.size() > BigDecimal.TEN.intValue()) {
                this.getView().updateView(this.getSchemeEntry());
            } else {
                for (int i = 0; i < this.selectRows.size(); ++i) {
                    for (String string : entryFiledSet) {
                        this.getView().updateView(string, this.selectRows.get(i).intValue());
                    }
                }
            }
        }
    }

    private static Object getValue(String[] dividePropertys, int startIndex, DynamicObject source) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return source.get(dividePropertys[startIndex]);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return QuoteOp.getValue(dividePropertys, ++startIndex, source);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private boolean checkOrgPostion(Map<Long, Map<String, Object>> priceMapKey) {
        ArrayList resultTotalFields = new ArrayList();
        priceMapKey.forEach((k, v) -> {
            List resultFields = (List)v.get(PRICE_FLAG);
            resultFields.forEach(p -> {
                if (!resultTotalFields.contains(p)) {
                    resultTotalFields.add(p);
                }
            });
        });
        ArrayList<String> entryResultFields = new ArrayList<String>();
        ArrayList<String> headResultFields = new ArrayList<String>();
        for (String resultField : resultTotalFields) {
            if (resultField.split(SPLIT).length == 1) {
                this.hasHeadPriceField = true;
                headResultFields.add(resultField);
                continue;
            }
            this.hasEntryPriceField = true;
            entryResultFields.add(resultField);
        }
        if (entryResultFields.size() > 0) {
            ArrayList<String> priceTotalFields = new ArrayList<String>();
            for (int i = 0; i < entryResultFields.size(); ++i) {
                String r = (String)entryResultFields.get(i);
                String[] resultField = r.split(SPLIT);
                priceTotalFields.add(resultField[resultField.length - 1]);
                this.schemeEntry = resultField[resultField.length - 2];
            }
            this.setNoPriceRow(priceTotalFields, this.schemeEntry);
        } else {
            priceMapKey.forEach((k, v) -> {
                List entryConditonFields = (List)v.get(ENTRY_FLAG);
                if (entryConditonFields != null && entryConditonFields.size() > 0) {
                    String r = (String)entryConditonFields.get(0);
                    String[] conditionField = r.split(SPLIT);
                    this.schemeEntry = conditionField[conditionField.length - 2];
                }
            });
        }
        this.setAllRows();
        if (this.hasEntryPriceField && ENTRY_FLAG.equals(this.orgPosition) && !this.getOrgEntry().equals(this.schemeEntry)) {
            String message = "\u53d6\u4ef7\u5931\u8d25\uff1a\u53d6\u4ef7\u65b9\u6848\u4e2d\u914d\u7f6e\u7684\u4ef7\u683c\u8fd4\u56de\u5b57\u6bb5\u548c\u53d6\u4ef7\u7ec4\u7ec7\u5b57\u6bb5\u4e0d\u5728\u540c\u4e00\u4e2a\u5206\u5f55\u3002";
            message = ResManager.loadKDString((String)message, (String)"QuoteOp_7", (String)"bos-ext-scmc", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return true;
    }

    private Map<Long, List<Map<String, Object>>> buildMap4Entry(Map<Long, Map<String, Object>> priceMapKey, Map<Long, List<Integer>> orgMap, Set<Long> orgIds) {
        IDataModel model = this.getView().getModel();
        DynamicObject curObj = model.getDataEntity(true);
        HashMap headMap = new HashMap();
        HashMap<Long, List<Map<String, Object>>> propertiesMap = new HashMap<Long, List<Map<String, Object>>>();
        for (Long orgID : orgIds) {
            String entryName;
            ArrayList parasList = new ArrayList();
            List<Integer> rowList = orgMap.get(orgID);
            if (this.hasEntryPriceField && rowList.size() == 0) continue;
            Map<String, Object> keys = priceMapKey.get(orgID);
            List headKeys = (List)keys.get(HEAD_FLAG);
            List entryKeys = (List)keys.get(ENTRY_FLAG);
            this.genPKValue(curObj);
            headKeys.forEach(l -> headMap.put(l, QuoteOp.getValue(l.split(SPLIT), 0, curObj)));
            String string = entryName = StringUtils.isEmpty((CharSequence)this.getSchemeEntry()) ? this.orgEntry : this.getSchemeEntry();
            if (StringUtils.isNotEmpty((CharSequence)entryName) && rowList.size() >= 0) {
                DynamicObjectCollection col = model.getEntryEntity(entryName);
                for (int i = 0; i < rowList.size(); ++i) {
                    HashMap map = new HashMap();
                    DynamicObject entryInfo = (DynamicObject)col.get(rowList.get(i).intValue());
                    this.genPKValue(entryInfo);
                    entryKeys.forEach(l -> map.put(l, QuoteOp.getValue(l.split(SPLIT), 1, entryInfo)));
                    map.putAll(headMap);
                    parasList.add(map);
                }
            } else {
                parasList.add(headMap);
            }
            propertiesMap.put(orgID, parasList);
        }
        return propertiesMap;
    }

    private void buildSelectRows4Entry(Map<Long, List<Integer>> orgRowMap) {
        IDataModel model = this.getView().getModel();
        if (this.selectRows.size() > 0) {
            for (int row : this.selectRows) {
                DynamicObject org = (DynamicObject)model.getValue(this.orgSign, row);
                if (org == null) continue;
                List list = orgRowMap.computeIfAbsent((Long)org.getPkValue(), k -> new ArrayList());
                list.add(row);
            }
        } else {
            DynamicObjectCollection colls = model.getEntryEntity(this.orgEntry);
            for (int i = 0; colls != null && i < colls.size(); ++i) {
                DynamicObject org = ((DynamicObject)colls.get(i)).getDynamicObject(this.orgSign);
                if (org == null) continue;
                orgRowMap.computeIfAbsent((Long)org.getPkValue(), k -> new ArrayList());
            }
        }
    }

    private String getOrgEntry() {
        if (HEAD_FLAG.equals(this.orgPosition)) {
            return "";
        }
        return this.orgEntry;
    }

    private String getSchemeEntry() {
        return this.schemeEntry;
    }

    private String getEntityType() {
        String entityType = this.getView().getEntityId();
        return entityType;
    }

    private void genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
    }

    private boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return false;
        }
        if (oldObject == null && newObject != null) {
            return true;
        }
        if (oldObject != null && newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
        } else if (oldObject instanceof DynamicObject) {
            if (!((DynamicObject)oldObject).getPkValue().equals(newObject) && (Long)newObject != 0L) {
                return true;
            }
        } else {
            return !oldObject.equals(newObject);
        }
        return false;
    }
}

