/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.bizrule;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.scmc.paramentity.bizrule.LotParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;

public class SaveLotOpBizRulePlugin
extends AbstractOpBizRuleParameterEdit {
    private static final String COL_ENTRYFIELD = "entryfield";
    private static final String KEY_ISSECOND = "issecond";
    private static final String ROW = "row";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_METADATA = "metadata";
    private static final String KEY_METADATAKEY = "metadatakey";
    private static final String KEY_CURRENTMETADATA = "currentmetadata";
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";
    private static final String KEY_mainMapping = "mainmapping";
    private static final String KEY_movemapping = "movemapping";
    private static final String KEY_snEntity = "bd_lot";
    private static final String KEY_moveEntity = "bd_lotmovetrack";
    private static final String ENTITY_propMapping = "scmc_rule_savelotmapping";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray metaContext = (JSONArray)formShowParameter.getCustomParam("MetaContext");
        JSONObject metaData = metaContext.getJSONArray(0).getJSONObject(0);
        String currentNumber = metaData.getString("Key");
        String pageId = Uuid16.create().toString();
        this.getPageCache().put("pageid", pageId);
        Map ob = this.getOriParameter();
        this.buildEntryFieldCombo();
        LotParameter param = new LotParameter();
        if (!ObjectUtils.isEmpty((Object)ob)) {
            String json = SerializationUtils.toJsonString((Object)ob);
            param = (LotParameter)SerializationUtils.fromJsonString((String)json, LotParameter.class);
            this.showMappingParam(KEY_mainMapping, KEY_snEntity, currentNumber, param.getMainFields());
            this.showMappingParam(KEY_movemapping, KEY_moveEntity, currentNumber, param.getMoveFields());
            this.setDefaultEntryProp(param);
        }
        this.getModel().setValue(KEY_ISSECOND, (Object)param.isSecond());
        this.showMappingParam(KEY_mainMapping, KEY_snEntity, currentNumber, param.getMainFields());
        this.showMappingParam(KEY_movemapping, KEY_moveEntity, currentNumber, param.getMoveFields());
    }

    private void showMappingParam(String targetKey, String targetEntity, String currentNumber, List<Map<String, Object>> paramList) {
        String pageId = Uuid16.create().toString();
        this.getPageCache().put(targetKey, pageId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(ENTITY_propMapping);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setPageId(pageId);
        parameter.setCustomParam("entitynumber", (Object)targetEntity);
        parameter.setCustomParam("currentnumber", (Object)currentNumber);
        parameter.setCustomParam("datalist", paramList);
        this.getView().showForm(parameter);
    }

    private void buildEntryFieldCombo() {
        List formContext = this.getFormContext();
        ArrayList<ComboItem> operateParamItems = new ArrayList<ComboItem>();
        for (Map field : (List)formContext.get(0)) {
            String fieldType = field.get("_Type_").toString();
            if (!fieldType.equalsIgnoreCase("EntryEntity") && !fieldType.equalsIgnoreCase("TreeEntryEntity") && !fieldType.equalsIgnoreCase("SubEntryEntity")) continue;
            operateParamItems.add(new ComboItem(new LocaleString(field.get("Name").toString()), field.get("Key").toString()));
        }
        if (operateParamItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl(COL_ENTRYFIELD);
            combo.setComboItems(operateParamItems);
            this.getModel().setValue(COL_ENTRYFIELD, (Object)((ComboItem)operateParamItems.get(0)).getValue());
        }
    }

    private void setDefaultEntryProp(LotParameter param) {
        if (StringUtils.isNotEmpty((CharSequence)param.getMainEntryKey())) {
            this.getModel().setValue(COL_ENTRYFIELD, (Object)param.getMainEntryKey());
        }
    }

    public String getParameter() {
        LotParameter parameter = new LotParameter();
        parameter.setMainFields(this.getPropMapping(KEY_mainMapping));
        parameter.setMoveFields(this.getPropMapping(KEY_movemapping));
        parameter.setMainEntryKey(this.getModel().getDataEntity().getString(COL_ENTRYFIELD));
        parameter.setSecond(this.getModel().getDataEntity().getBoolean(KEY_ISSECOND));
        return SerializationUtils.toJsonString((Object)parameter);
    }

    private List<Map<String, Object>> getPropMapping(String pageIdKey) {
        String pageId = this.getPageCache().get(pageIdKey);
        IDataModel model = this.getView().getView(pageId).getModel();
        ArrayList<Map<String, Object>> Fields = new ArrayList<Map<String, Object>>();
        int entryRowCount = model.getEntryRowCount(KEY_ENTRYENTITY);
        if (entryRowCount > 0) {
            for (int i = 0; i < entryRowCount; ++i) {
                Object curNumber = model.getValue(KEY_CURRENTMETADATAKEY, i);
                if (!StringUtils.isNotBlank((Object)curNumber)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ROW, i);
                map.put(KEY_METADATA, model.getValue(KEY_METADATA, i));
                map.put(KEY_METADATAKEY, model.getValue(KEY_METADATAKEY, i));
                map.put(KEY_CURRENTMETADATA, model.getValue(KEY_CURRENTMETADATA, i));
                map.put(KEY_CURRENTMETADATAKEY, curNumber);
                Fields.add(map);
            }
        }
        return Fields;
    }
}

