/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.plugin.operation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;

public class InvAvbOpSettingPlugin
extends AbstractFormPlugin {
    private static final String KEY_METADATA = "metadata";
    public static final String METADATAKEY = "metadatakey";
    public static final String ENTRYENTITY = "entryentity";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entitynumber");
        String entryKey = (String)formShowParameter.getCustomParam("entrykey");
        String entryNoupdateFieldkey = (String)formShowParameter.getCustomParam("entrynoupdatefieldkey");
        this.setEntryFieldKey(entityNumber);
        List dataList = (List)this.getView().getFormShowParameter().getCustomParam("datalist");
        IDataModel model = this.getModel();
        HashMap metaKeySeqMap = new HashMap();
        DynamicObjectCollection entries = (DynamicObjectCollection)model.getValue(ENTRYENTITY);
        AtomicInteger rowNum = new AtomicInteger();
        entries.forEach(entry -> metaKeySeqMap.put(entry.getString(METADATAKEY), rowNum.getAndIncrement()));
        model.setValue("entrykey", (Object)entryKey);
        model.setValue("entrynoupdatefieldkey", (Object)entryNoupdateFieldkey);
        if (dataList != null) {
            int size = dataList.size();
            for (int i = 0; i < size; ++i) {
                Map data = (Map)dataList.get(i);
                Integer row = (Integer)metaKeySeqMap.get(data.get(METADATAKEY));
                if (row == null) continue;
                model.setValue("currentmetadata", data.get("currentmetadata"), row.intValue());
                model.setValue("currentmetadatakey", data.get("currentmetadatakey"), row.intValue());
                model.setValue("qfilter", data.get("qfilter"), row.intValue());
                model.setValue("update", data.get("update"), row.intValue());
            }
        }
    }

    private void setEntryFieldKey(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        String entityName = entityMetadata.getRootEntity().getName().getLocaleValue();
        TextEdit textEdit = (TextEdit)this.getControl(KEY_METADATA);
        textEdit.setText(entityName);
        this.getView().updateView();
        List fields = entityMetadata.getRootEntity().getItems();
        ArrayList list = new ArrayList(fields.size());
        for (EntityItem field : fields) {
            HashMap<String, String> fieldItem = new HashMap<String, String>();
            fieldItem.put("key", field.getKey());
            fieldItem.put("name", field.getName().toString());
            list.add(fieldItem);
        }
        if (list != null && list.size() > 0) {
            int size = list.size();
            this.getView().getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
            for (int i = 0; i < size; ++i) {
                Map map = (Map)list.get(i);
                this.getModel().setValue(KEY_METADATA, map.get("name"), i);
                this.getModel().setValue(METADATAKEY, map.get("key"), i);
            }
        }
    }
}

