/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BillBackStageTaskValidate
extends AbstractValidator {
    private static final String BUSINESSKEY = "businesskey";
    private static final String CHECK_CONSISTENCY = "ECServiceHelperExt";
    private static final String IS_IGNORE_TASK_VALIDATE = "isIgnoreTaskValidate";

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        OperateOption option = this.validateContext.getOption();
        boolean isIgnore = "true".equalsIgnoreCase(option.getVariableValue(IS_IGNORE_TASK_VALIDATE, "false"));
        if (option != null && isIgnore) {
            return;
        }
        String operationName = this.getOperationName();
        ExtendedDataEntity[] datas = this.getDataEntities();
        ArrayList<String> idList = new ArrayList<String>(this.dataEntities.length);
        String billFormId = "";
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            billFormId = bill.getDataEntityType().getName();
            idList.add(bill.getString("id"));
        }
        this.asyServiceCheck(datas, billFormId, idList, operationName);
        this.businessEventCheck(datas, billFormId, idList, operationName);
    }

    private void asyServiceCheck(ExtendedDataEntity[] datas, String billFormId, List<String> idList, String operationName) {
        ArrayList<String> checkIdList = new ArrayList<String>(idList.size());
        for (String id : idList) {
            checkIdList.add(billFormId + "#" + id);
        }
        List unFinishedIds = TxCheckUtil.loadUnfinishedTx(checkIdList);
        if (!ObjectUtils.isEmpty((Object)unFinishedIds)) {
            for (ExtendedDataEntity data : datas) {
                DynamicObject bill = data.getDataEntity();
                String billForm = bill.getDataEntityType().getName();
                String id = bill.getString("id");
                String checkId = billForm + "#" + id;
                if (!unFinishedIds.contains(checkId)) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1\u903b\u8f91\uff0c\u4e0d\u80fd%1$s\uff0c\u8bf7\u901a\u8fc7\u201c\u5206\u5e03\u5f0f\u7ba1\u7406-\u5206\u5e03\u5f0f\u4e8b\u52a1-\u4e8b\u52a1\u67e5\u8be2\u201d\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"BillBackStageTaskValidate_0", (String)"bos-ext-scmc", (Object[])new Object[0]), operationName));
            }
        }
    }

    private void businessEventCheck(ExtendedDataEntity[] datas, String billFormId, List<String> idList, String operationName) {
        QFilter qFilter = new QFilter("entitynumber", "=", (Object)billFormId);
        QFilter qFilter1 = new QFilter("state", "=", (Object)"executing");
        QFilter qFilter2 = new QFilter(BUSINESSKEY, "in", idList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"evt_job", (String)BUSINESSKEY, (QFilter[])qFilter.and(qFilter1).and(qFilter2).toArray(), (String)"");
        ArrayList<String> unFinishedIds = new ArrayList<String>(datas.length);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String businesskey = row.getString(BUSINESSKEY);
            unFinishedIds.add(businesskey);
        }
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            String id = bill.getString("id");
            if (!unFinishedIds.contains(id)) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u4e1a\u52a1\u4e8b\u4ef6\uff0c\u4e0d\u80fd%1$s\uff0c\u8bf7\u5728\u201c\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u65e5\u5fd7\u201d\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"BillBackStageTaskValidate_1", (String)"bos-ext-scmc", (Object[])new Object[0]), operationName));
        }
    }
}

