/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class InnerSettleValidate
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(InnerSettleValidate.class);

    public void validate() {
        boolean isIgnore;
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        OperateOption option = this.validateContext.getOption();
        boolean bl = isIgnore = "true".equalsIgnoreCase(option.getVariableValue("ismoperate", "false")) || "true".equalsIgnoreCase(option.getVariableValue("vmioperate", "false"));
        if (option != null && isIgnore) {
            return;
        }
        Map result = null;
        logger.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u68c0\u67e5\u670d\u52a1\u8c03\u7528\u5f00\u59cb\u3002");
        if (this.isUseIdToCheck()) {
            String entityName = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
            HashSet<Long> ids = new HashSet<Long>();
            for (ExtendedDataEntity data : this.dataEntities) {
                long billId = (Long)data.getBillPkId();
                ids.add(billId);
            }
            result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"checkCanSettleByIds", (Object[])new Object[]{entityName, ids});
        } else {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"checkCanSettleByDynamicObjects", (Object[])new Object[]{Collections.singletonList(this.dataEntities[0].getDataEntity())});
        }
        logger.info("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u68c0\u67e5\u670d\u52a1\u8c03\u7528\u7ed3\u675f\u3002");
        if (!result.isEmpty()) {
            for (ExtendedDataEntity data : this.dataEntities) {
                long billId = (Long)data.getBillPkId();
                String billFailInfo = (String)result.get(billId);
                if (StringUtils.isEmpty((Object)billFailInfo)) continue;
                String failInfo = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u68c0\u67e5\u5931\u8d25\uff1a%s", (String)"ismcheckfail", (String)"bos-ext-scmc", (Object[])new Object[0]), billFailInfo);
                this.addFatalErrorMessage(data, failInfo);
            }
        }
    }

    private boolean isUseIdToCheck() {
        DynamicObject dataEntity = this.dataEntities[0].getDataEntity();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        if (!dataEntityState.getFromDatabase()) {
            return false;
        }
        OperateOption option = this.validateContext.getOption();
        if ("true".equalsIgnoreCase(option.getVariableValue("islistviewop4mutex", "false")) || this.dataEntities.length > 1) {
            return true;
        }
        if (dataEntityState.isBizChanged()) {
            return false;
        }
        MainEntityType entityType = (MainEntityType)this.dataEntities[0].getDataEntity().getDataEntityType();
        Map entities = entityType.getAllEntities();
        for (EntityType it : entities.values()) {
            if (!it.getClass().equals(EntryType.class)) continue;
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection(it.getName());
            for (DynamicObject entry : entries) {
                if (!entry.getDataEntityState().isBizChanged()) continue;
                return false;
            }
        }
        return true;
    }
}

