/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class WfRecordBillListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(WfRecordBillListPlugin.class);
    private static final String ENTRY_BACK_WF = "entryBackWf";
    private static final String BACK_WRITE_OFF = "backwriteoff";
    private static final String BACK_WF_OP = "backwfop";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (BACK_WRITE_OFF.equals(operateKey)) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.error("\u7761\u7720\u5931\u8d25,", (Throwable)e);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals(BACK_WF_OP)) {
            args.setCancel(true);
            DynamicObject dynamicObject = this.getEntryData(args);
            if (dynamicObject == null) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"backWriteOff", (Object[])new Object[]{new DynamicObject[]{dynamicObject}, ENTRY_BACK_WF});
            this.getView().invokeOperation("refresh");
        }
    }

    private DynamicObject getEntryData(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        String entityKey = billList.getEntityId();
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        Object pk = billList.getFocusRowPkId();
        Object entryEntityKey = currentSelectedRowInfo.getEntryPrimaryKeyValue();
        DynamicObject wfRecord = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityKey);
        DynamicObjectCollection entryList = wfRecord.getDynamicObjectCollection("entry");
        return entryList.stream().filter(n -> n.getPkValue().equals(entryEntityKey)).findFirst().orElse(null);
    }
}

