/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff.wfmanual.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDException;
import kd.bos.ext.scmc.wirteoff.util.MsmodGridConfigDAO;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.CreateEntryUtil;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.WfManualUtil;
import kd.bos.ext.scmc.wirteoff.wfmanual.consts.WfBillListField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WfManualPluginHelper {
    private static Log logger = LogFactory.getLog(WfManualPluginHelper.class);
    private static final String[] entryKeys = new String[]{"entry_a", "entry_b", "entry_c", "entry_d"};
    private static final String[] entrySuffix = new String[]{"_a", "_b", "_c", "_d"};
    private IFormView view;

    public WfManualPluginHelper(IFormView view) {
        this.view = view;
    }

    public List<GridConfigurationRow> buildData(String formId, String entryId) {
        List<GridConfigurationRow> gridConfigByMeta = this.getFieldApInfo(formId, entryId);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        List<GridConfigurationRow> gridConfigByDB = MsmodGridConfigDAO.getGridConfig(formId, entryId, userId);
        Iterator<GridConfigurationRow> it = gridConfigByDB.iterator();
        while (it.hasNext()) {
            GridConfigurationRow gridConfigurationRowByDB = it.next();
            if (!gridConfigByMeta.contains(gridConfigurationRowByDB)) {
                it.remove();
            }
            for (GridConfigurationRow gridConfigurationRowByMeta : gridConfigByMeta) {
                if (!StringUtils.equals((CharSequence)gridConfigurationRowByDB.getFieldKey(), (CharSequence)gridConfigurationRowByMeta.getFieldKey())) continue;
                gridConfigurationRowByDB.setFieldName(gridConfigurationRowByMeta.getFieldName());
            }
        }
        gridConfigByDB.addAll(gridConfigByMeta.stream().filter(t -> !gridConfigByDB.contains(t)).collect(Collectors.toList()));
        return gridConfigByDB;
    }

    private List<GridConfigurationRow> getFieldApInfo(String formId, String entryId) {
        Objects.requireNonNull(entryId);
        Objects.requireNonNull(formId);
        List<ControlAp<?>> controller = this.createController(this.getView());
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        items.addAll(controller);
        String entryApId = null;
        for (ControlAp ctlAp : items) {
            if (!(ctlAp instanceof EntryAp) || !Objects.equals(entryId, ctlAp.getKey())) continue;
            entryApId = ctlAp.getId();
            break;
        }
        ArrayList<GridConfigurationRow> currentFields = new ArrayList<GridConfigurationRow>();
        for (ControlAp ctlAp : items) {
            OperationStatus operationStatus;
            BillOperationStatus billOperationStatus;
            if (ctlAp.getKey().equals("org_b")) {
                System.out.println("xiexie");
            }
            if (!(ctlAp instanceof EntryFieldAp) && !(ctlAp instanceof EntryFieldGroupAp) && !(ctlAp instanceof EntryFieldContainerAp) && !(ctlAp instanceof OperationColumnAp) || !Objects.equals(entryApId, ctlAp.getParentId())) continue;
            System.out.println("\u6ee1\u8db3\u7ed3\u679c:" + ctlAp.getName());
            if (ctlAp.isHidden() || !ctlAp.getVisible().contains("init")) continue;
            String visible = ctlAp.getVisible();
            if (this.getView() instanceof BillView ? (billOperationStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) == BillOperationStatus.ADDNEW && !StringUtils.contains((CharSequence)visible, (CharSequence)"new") || billOperationStatus == BillOperationStatus.EDIT && !StringUtils.contains((CharSequence)visible, (CharSequence)"edit") || billOperationStatus == BillOperationStatus.VIEW && !StringUtils.contains((CharSequence)visible, (CharSequence)"view") || billOperationStatus == BillOperationStatus.SUBMIT && !StringUtils.contains((CharSequence)visible, (CharSequence)"submit") || billOperationStatus == BillOperationStatus.AUDIT && !StringUtils.contains((CharSequence)visible, (CharSequence)"audit") : (operationStatus = this.getView().getFormShowParameter().getStatus()) == OperationStatus.ADDNEW && !StringUtils.contains((CharSequence)visible, (CharSequence)"new") || operationStatus == OperationStatus.EDIT && !StringUtils.contains((CharSequence)visible, (CharSequence)"edit") || operationStatus == OperationStatus.VIEW && !StringUtils.contains((CharSequence)visible, (CharSequence)"view")) continue;
            LocaleString name = ctlAp.getName();
            String textAlign = ctlAp.getTextAlign();
            String key = ctlAp.getKey();
            int width = 0;
            if (ctlAp.getWidth() != null) {
                for (Map.Entry entry : ctlAp.getWidth().entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue())) || ((String)entry.getValue()).contains("%")) continue;
                    width = Integer.parseInt(((String)entry.getValue()).replace("px", "").split("\\.")[0]);
                    break;
                }
            }
            GridConfigurationRow bean = new GridConfigurationRow(name, width, textAlign, key);
            currentFields.add(bean);
        }
        return currentFields;
    }

    public List<ControlAp<?>> createController(IFormView view) {
        List<WfBillListField> fieldsList = WfManualUtil.getBillListFields(this.getView());
        ArrayList list = new ArrayList();
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            EntryAp dynamicEntryAp = CreateEntryUtil.createDynamicEntryAp(entryKeys[i], billListField);
            EntryGrid entryGrid = (EntryGrid)view.getControl(entryKeys[i]);
            List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(view);
                entryGrid.getItems().add(fieldEdit);
            }
            list.addAll(dynamicEntryAp.getItems());
        }
        return list;
    }

    public List<WfBillListField> init(String wfTypeNumber, FormShowParameter formShowParameter) {
        QFilter qFilter = new QFilter("number", "=", (Object)wfTypeNumber);
        Map writeoffTypeMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_writeofftype", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Map)writeoffTypeMap)) {
            throw new KDException(ResManager.LoadKDString((String)"\u6838\u9500\u7c7b\u522b\u4e0d\u5b58\u5728,\u8bf7\u5148\u8f93\u5165\u6838\u9500\u7c7b\u522b\u53c2\u6570", (String)"bos-ext-scmc"));
        }
        ArrayList wfTypeList = new ArrayList(writeoffTypeMap.values());
        String formId = formShowParameter.getFormId();
        DynamicObjectCollection wfBills = ((DynamicObject)wfTypeList.get(0)).getDynamicObjectCollection("writeoffbillentry");
        ArrayList<WfBillListField> fieldsList = new ArrayList<WfBillListField>();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (int i = 0; i < wfBills.size(); ++i) {
            DynamicObject wfBill = (DynamicObject)wfBills.get(i);
            String billType = wfBill.getString("writeoffbillnumber");
            String alias = wfBill.getString("alias");
            DynamicObjectCollection wfFieldSubentry = wfBill.getDynamicObjectCollection("wffieldsubentry");
            ArrayList<String> assisFields = new ArrayList<String>(4);
            for (DynamicObject subEntry : wfFieldSubentry) {
                String wfFieldKey = subEntry.getString("writeofffieldkey");
                boolean wfCalcField = subEntry.getBoolean("writeoffcalcfield");
                String valueMethod = subEntry.getString("valuemethod");
                if (wfCalcField) {
                    if ("B".equals(valueMethod) || "C".equals(valueMethod)) {
                        map.put((String)alias + "mainField", "curwfdata");
                        continue;
                    }
                    String[] split = wfFieldKey.split("\\.");
                    if (split.length > 1) {
                        map.put((String)alias + "mainField", split[split.length - 1]);
                        continue;
                    }
                    map.put((String)alias + "mainField", wfFieldKey);
                    continue;
                }
                assisFields.add(wfFieldKey);
            }
            map.put((String)alias + "assisField", assisFields);
            map.put((String)alias + "suffix", entrySuffix[i]);
        }
        QFilter filter = new QFilter("writeofftype.number", "=", (Object)wfTypeNumber);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObject fieldConfs = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_wfmanual_fieldconf", (QFilter[])filter.toArray());
        if (fieldConfs == null) {
            return fieldsList;
        }
        DynamicObjectCollection entryEntity = fieldConfs.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            WfBillListField billListField = new WfBillListField();
            billListField.setFormId(formId);
            ArrayList<Map<String, Object>> fieldListTwo = new ArrayList<Map<String, Object>>(16);
            DynamicObject wfbill = entry.getDynamicObject("wfbill");
            String number = wfbill.getString("writeoffbillnumber");
            String alias = wfbill.getString("falias");
            billListField.setBillType(number);
            HashMap<String, String> mainItem = new HashMap<String, String>(4);
            DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntryEntity) {
                HashMap<String, String> item = new HashMap<String, String>(4);
                boolean checkBox = subEntry.getBoolean("showcolumn");
                String fieldKey = subEntry.getString("fieldkey");
                String fieldName = subEntry.getString("fieldname");
                String mainField = (String)map.get(alias + "mainField");
                if (fieldKey.equals(mainField)) {
                    mainItem.put("fieldName", fieldKey + map.get(alias + "suffix"));
                    mainItem.put("fieldInitName", fieldKey);
                    mainItem.put("fieldCaption", fieldName);
                    continue;
                }
                if (!checkBox) continue;
                item.put("fieldName", fieldKey + map.get(alias + "suffix"));
                item.put("fieldInitName", fieldKey);
                item.put("fieldCaption", fieldName);
                fieldListTwo.add(item);
            }
            fieldListTwo.add(mainItem);
            String mainField = (String)map.get(alias + "mainField");
            HashMap<String, String> item = new HashMap<String, String>(4);
            item.put("fieldName", mainField + "_cur" + map.get(alias + "suffix"));
            item.put("fieldInitName", mainField);
            item.put("fieldCaption", "\u672c\u6b21\u6838\u9500\u6570\u636e");
            if ("curwfdata".equals(mainField)) {
                item.put("isformula", "true");
            }
            fieldListTwo.add(item);
            billListField.setFields(fieldListTwo);
            fieldsList.add(billListField);
        }
        String billListFields = JSONObject.toJSONString(fieldsList);
        formShowParameter.setCustomParam("billListFields", (Object)billListFields);
        return fieldsList;
    }

    public void registDynamicProps(MainEntityType newMainType) {
        List<WfBillListField> fieldsList = WfManualUtil.getBillListFields(this.getView());
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(entryKeys[i]);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billListField.getBillType());
            for (Map<String, Object> field : billListField.getFields()) {
                this.buildProp(entryType, dataEntityType, field);
            }
        }
    }

    private void buildProp(EntryType entryType, MainEntityType dataEntityType, Map<String, Object> field) {
        String billField = (String)field.get("fieldInitName");
        logger.info("\u6ce8\u518cprop\u5b57\u6bb5:" + billField);
        if ("curwfdata".equals(billField)) {
            this.addMainFieldProp(entryType, field);
            return;
        }
        IDataEntityProperty property = dataEntityType.findProperty(billField);
        if (property == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)property.getAlias())) {
            return;
        }
        if (property instanceof BasedataProp) {
            BasedataProp property1 = (BasedataProp)property;
            String alias = property1.getAlias();
            LongProp pRefId = new LongProp(true);
            pRefId.setPrimaryKey(false);
            pRefId.setName(field.get("fieldName") + "_id");
            BasedataProp basedataProp = new BasedataProp();
            basedataProp.setName((String)field.get("fieldName"));
            basedataProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            basedataProp.setDbIgnore(false);
            basedataProp.setAlias(alias);
            String baseEntityId = property1.getBaseEntityId();
            if (baseEntityId == null) {
                return;
            }
            logger.info("\u57fa\u7840\u8d44\u6599registDynamicProps:" + baseEntityId);
            basedataProp.setBaseEntityId(baseEntityId);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            basedataProp.setComplexType((IDataEntityType)entityType);
            basedataProp.setRefIdProp((IDataEntityProperty)pRefId);
            basedataProp.setRefIdPropName(field.get("fieldName") + "_id");
            entryType.registerSimpleProperty((DynamicSimpleProperty)pRefId);
            entryType.registerComplexProperty((DynamicComplexProperty)basedataProp);
        } else if (property instanceof ComboProp) {
            ComboProp comboProp = new ComboProp();
            comboProp.setName((String)field.get("fieldName"));
            comboProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            comboProp.setDbIgnore(true);
            comboProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        } else if (property instanceof BooleanProp) {
            BooleanProp comboProp = new BooleanProp();
            comboProp.setName((String)field.get("fieldName"));
            comboProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            comboProp.setDbIgnore(true);
            comboProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        } else if (property instanceof DateProp) {
            DateProp dateProp = new DateProp();
            dateProp.setName((String)field.get("fieldName"));
            dateProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            dateProp.setDbIgnore(true);
            dateProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)dateProp);
        } else if (property instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = new DateTimeProp();
            dateTimeProp.setName((String)field.get("fieldName"));
            dateTimeProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            dateTimeProp.setDbIgnore(true);
            dateTimeProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)dateTimeProp);
        } else if (property instanceof TimeProp) {
            TimeProp timeProp = new TimeProp();
            timeProp.setName((String)field.get("fieldName"));
            timeProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            timeProp.setDbIgnore(true);
            timeProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)timeProp);
        } else if (property instanceof DecimalProp) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName((String)field.get("fieldName"));
            decimalProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        } else {
            TextProp textProp2 = new TextProp();
            textProp2.setName((String)field.get("fieldName"));
            textProp2.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
            textProp2.setDbIgnore(true);
            textProp2.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp2);
        }
    }

    private void addMainFieldProp(EntryType entryType, Map<String, Object> field) {
        DecimalProp decimalProp = new DecimalProp();
        decimalProp.setName((String)field.get("fieldName"));
        decimalProp.setDisplayName(new LocaleString((String)field.get("fieldCaption")));
        decimalProp.setDbIgnore(true);
        decimalProp.setAlias("");
        entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
    }

    public void buildPropTwo(String entryKey, Map<String, Object> field, OnGetControlArgs e) {
        String fieldName = (String)field.get("fieldName");
        if (!e.getKey().equals(fieldName)) {
            return;
        }
        System.out.println("\u6ce8\u518c\u5b57\u6bb5:" + fieldName + "\u5206\u5f55:" + entryKey);
        Map allFields = this.getView().getModel().getDataEntityType().getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)allFields.get(fieldName);
        if (property == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)property.getAlias())) {
            return;
        }
        if (property instanceof BasedataProp) {
            BasedataEdit basedataEdit = new BasedataEdit();
            basedataEdit.setKey((String)field.get("fieldName"));
            basedataEdit.setView(this.getView());
            basedataEdit.setEntryKey(entryKey);
            e.setControl((Control)basedataEdit);
        } else if (property instanceof ComboProp) {
            ComboEdit comboEdit = new ComboEdit();
            comboEdit.setKey((String)field.get("fieldName"));
            comboEdit.setView(this.getView());
            comboEdit.setEntryKey(entryKey);
            e.setControl((Control)comboEdit);
        } else if (property instanceof BooleanProp) {
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(e.getKey());
            fieldEdit.setEntryKey(entryKey);
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        } else if (property instanceof DateProp) {
            DateEdit dateEdit = new DateEdit();
            dateEdit.setKey(e.getKey());
            dateEdit.setEntryKey(entryKey);
            dateEdit.setView(this.getView());
            e.setControl((Control)dateEdit);
        } else if (property instanceof DateTimeProp) {
            DateTimeEdit dateEdit = new DateTimeEdit();
            dateEdit.setKey(e.getKey());
            dateEdit.setEntryKey(entryKey);
            dateEdit.setView(this.getView());
            e.setControl((Control)dateEdit);
        } else if (property instanceof TimeProp) {
            TimeEdit timeEdit = new TimeEdit();
            timeEdit.setKey(e.getKey());
            timeEdit.setEntryKey(entryKey);
            timeEdit.setView(this.getView());
            e.setControl((Control)timeEdit);
        } else if (property instanceof DecimalProp) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(e.getKey());
            decimalEdit.setEntryKey(entryKey);
            decimalEdit.setView(this.getView());
            e.setControl((Control)decimalEdit);
        } else {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setEntryKey(entryKey);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    private void addMainFieldController(String entryKey, OnGetControlArgs e) {
        DecimalEdit decimalEdit = new DecimalEdit();
        decimalEdit.setKey(e.getKey());
        decimalEdit.setEntryKey(entryKey);
        decimalEdit.setView(this.getView());
        e.setControl((Control)decimalEdit);
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }
}

