/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.workbench;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.constant.Propagation;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class TaskUnCreate
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(TaskUnCreate.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object[] dataEntities = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String entityTypeName = this.billEntityType.getName();
        String dbRouteKey = this.billEntityType.getDBRouteKey();
        String operationKey = e.getOperationKey();
        ArrayList<String> businessInfo = new ArrayList<String>(dataEntities.length);
        ArrayList<Object> ids = new ArrayList<Object>(dataEntities.length);
        for (Object entity : dataEntities) {
            ids.add(entity.getPkValue());
            businessInfo.add(entityTypeName + "#" + entity.getPkValue());
        }
        try {
            if (dataEntities.length > 0) {
                CommonParam param = new CommonParam();
                param.put((Object)"entitytype", (Object)entityTypeName);
                param.put((Object)"ids", (Object)JSON.toJSONString(ids));
                param.put((Object)"operationKey", (Object)operationKey);
                logger.info("\u4f20\u9012\u53c2\u6570\u4e3a: id :" + JSON.toJSONString(ids) + "entryTypeName :" + entityTypeName + "operationKey :" + operationKey);
                this.execute(dbRouteKey, businessInfo, (Param)param);
            }
        }
        catch (KDBizException ex) {
            logger.error("\u6dfb\u52a0\u5de5\u4f5c\u53f0\u4efb\u52a1\u5f02\u5e38KDBizException", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error("\u6dfb\u52a0\u5de5\u4f5c\u53f0\u4efb\u52a1\u5f02\u5e38Exception", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private void execute(String dbRoute, List<String> businessInfo, Param param) {
        ECGlobalSession.begin((String)"msbd_workbench_task", (DBRoute)DBRoute.of((String)dbRoute), (Propagation)Propagation.REQUIRES_NEW);
        ECGlobalSession.register((String)"mpscmm", (String)"msbd", (String)"WorkBenchTaskUnCreateService", (Param)param, (String)"", (String)null);
        if (!CollectionUtils.isEmpty(businessInfo)) {
            ECGlobalSession.setBusinessType((String)"WorkBenchTaskUnCreate");
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.setAsync((boolean)true);
    }
}

