/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.atomop;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.ext.mmc.atomop.IAtomServLightHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AtomicServiceLightAbstractPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AtomicServiceLightAbstractPlugin.class);
    private List<IOperationServicePlugIn> workerList;

    protected abstract IAtomServLightHandler handler();

    private List<IOperationServicePlugIn> workers() {
        if (this.workerList != null) {
            return this.workerList;
        }
        logger.info("" + (Object)((Object)this));
        IAtomServLightHandler handler = this.handler();
        String opnum = (String)this.operateMeta.get("key");
        String billid = this.billEntityType.getName();
        this.workerList = handler.createWorker(billid, opnum);
        for (IOperationServicePlugIn worker : this.workerList) {
            worker.setContext(this.billEntityType, this.operateMeta, this.mergeOption(worker.getOption(), this.getOption()));
            worker.setOperateProgress(this.getOperateProgress());
        }
        return this.workerList;
    }

    private OperateOption mergeOption(OperateOption atomOption, OperateOption pluginOption) {
        Map map = atomOption.getVariables();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            pluginOption.setVariableValue(key, val);
        }
        return pluginOption;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.onPreparePropertys(e);
        }
    }

    public void initializeOperationResult(OperationResult result) {
        super.initializeOperationResult(result);
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.initializeOperationResult(result);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.onAddValidators(e);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.beforeExecuteOperationTransaction(e);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.beginOperationTransaction(e);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.endOperationTransaction(e);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.rollbackOperation(e);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List<IOperationServicePlugIn> workers = this.workers();
        for (IOperationServicePlugIn worker : workers) {
            worker.afterExecuteOperationTransaction(e);
        }
    }
}

