/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.ext.mmc.operation.bizrule.AutoGenTrackNumberOpAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public class DeleteTrackNumberOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(AutoGenTrackNumberOpAction.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        String entryName = "";
        long timer1 = System.currentTimeMillis();
        DynamicObject manuStrConfig = this.getManuStrConfig(this.billEntityType.getName());
        if (manuStrConfig == null) {
            return;
        }
        Map propertyMap = this.billEntityType.getAllEntities();
        DynamicObjectCollection entryEntitys = manuStrConfig.getDynamicObjectCollection("entryentity");
        if (entryEntitys == null) {
            return;
        }
        Object subEntryForMine = null;
        for (Object subEntry : entryEntitys) {
            if (!((DynamicObject)subEntry.get("billentity")).get("number").equals(this.billEntityType.getName())) continue;
            subEntryForMine = subEntry;
        }
        if (subEntryForMine == null) {
            return;
        }
        DynamicObjectCollection subentryEntitys = subEntryForMine.getDynamicObjectCollection("subentryentity");
        if (subentryEntitys == null) {
            return;
        }
        for (DynamicObject subEntry : subentryEntitys) {
            if (subEntry.get("dimension") == null) continue;
            String dimension = ((DynamicObject)subEntry.get("dimension")).get("number").toString();
            String[] fields = null;
            if (subEntry.get("field") == null) continue;
            fields = subEntry.get("field").toString().split("\\.");
            boolean isEntryField = this.isEntryField(propertyMap, fields);
            if (!dimension.equals("GZ001") || !isEntryField) continue;
            entryName = fields[0];
        }
        long timer2 = System.currentTimeMillis();
        log.info(String.format("DeleteTrackNumberOpAction-afterExecuteOperationTransaction-44: %s\u6beb\u79d2", timer2 - timer1));
        ArrayList<String> entryIds = new ArrayList<String>(16);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject bill = bills[i];
            if (StringUtils.isBlank((CharSequence)entryName)) {
                entryIds.add(bill.getPkValue().toString());
                continue;
            }
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection(entryName);
            if (billEntrys == null || billEntrys.size() <= 0) continue;
            for (DynamicObject billEntry : billEntrys) {
                entryIds.add(billEntry.getPkValue().toString());
            }
        }
        if (entryIds.size() > 0) {
            HashMap<String, ArrayList<String>> calparam = new HashMap<String, ArrayList<String>>();
            calparam.put("sourceentryid", entryIds);
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"delorder_deltracknumber", (String)jsonString);
        }
    }

    private boolean isEntryField(Map<String, EntityType> propertyMap, String[] fields) {
        if (fields.length > 1) {
            EntityType property = propertyMap.get(fields[0]);
            return property instanceof EntryType;
        }
        return false;
    }

    private DynamicObject getManuStrConfig(String entityName) {
        QFilter qFilter2 = new QFilter("entryentity.billentity", "=", (Object)entityName);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("status", "=", (Object)"C");
        Map manustrconfig = BusinessDataServiceHelper.loadFromCache((String)"bd_manustrconfig", (QFilter[])new QFilter[]{qFilter2, qFilter3, qFilter4});
        DynamicObject mscEntry = null;
        if (manustrconfig == null || manustrconfig.size() < 1) {
            return null;
        }
        for (Object value : manustrconfig.values()) {
            mscEntry = (DynamicObject)value;
        }
        return mscEntry;
    }
}

