/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncStatusManager;
import kd.bos.lang.Lang;

public class SyncStatusManageAction
extends AbstractOpBizRuleAction {
    private SyncStatusManager mgr;

    public void initialize(InitOperationArgs e) {
        String opKey = (String)this.operateMeta.get("key");
        Map opNameMap = (Map)this.operateMeta.get("name");
        String opName = (String)opNameMap.get(Lang.get().toString());
        this.mgr = new SyncStatusManager(this.billEntityType, opKey, opName);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        if (this.mgr.hasConfig()) {
            e.getFieldKeys().addAll(this.mgr.getProperties());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        if (this.mgr.hasConfig()) {
            List<Long> idList = Arrays.stream(e.getDataEntities()).map(o -> o.getLong("id")).collect(Collectors.toList());
            this.mgr.loadDBData(idList);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (this.mgr.hasConfig()) {
            if (this.mgr.isRevert()) {
                this.mgr.revert(Arrays.asList(dataEntities));
            } else if (this.mgr.isUpdate()) {
                ArrayList<DynamicObject> addNewList = new ArrayList<DynamicObject>(8);
                ArrayList<DynamicObject> modifyList = new ArrayList<DynamicObject>(8);
                for (DynamicObject dataEntity : dataEntities) {
                    boolean fromDb = dataEntity.getDataEntityState().getFromDatabase();
                    if (fromDb) {
                        modifyList.add(dataEntity);
                        continue;
                    }
                    addNewList.add(dataEntity);
                }
                if (addNewList.size() > 0) {
                    this.mgr.addNew(addNewList);
                }
                if (modifyList.size() > 0) {
                    this.mgr.modify(modifyList);
                }
            }
            this.mgr.commit();
        }
    }
}

