/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.function;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetSumFeeAmount
implements BOSUDFunction {
    public GetSumFeeAmount() {
    }

    public GetSumFeeAmount(ExpressionContext expContext) {
    }

    public BOSUDFunction getInstance(ExpressionContext expressionContext) {
        return new GetSumFeeAmount(expressionContext);
    }

    public String getName() {
        return "GetSumFeeAmount";
    }

    public BigDecimal call(Object ... params) {
        Object pkId = params[0];
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "=", pkId);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)"linkgen").or(new QFilter("billstatus", "=", (Object)"C").and(new QFilter("feesource", "in", Arrays.asList("hand", "batchinput", "bizpatch"))));
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,entry.srcbillid,entry.feedetailamt,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter});
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject fee : feeBills) {
            if (EmptyUtil.isNoEmpty(fee.getBigDecimal("entry.excrate"))) {
                sumAmount = sumAmount.add(fee.getBigDecimal("entry.feedetailamt").multiply(fee.getBigDecimal("entry.excrate")));
                continue;
            }
            sumAmount = sumAmount.add(fee.getBigDecimal("entry.feedetailamt"));
        }
        return sumAmount;
    }
}

