/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ElecReceiptQueryPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(ElecReceiptQueryPlugin.class);
    private static final String RECEIPT = "queryreceipt";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (RECEIPT.equals(operateKey)) {
            String billFormId;
            ArrayList<Long> pkList = new ArrayList<Long>(10);
            if (this.getView() instanceof IListView) {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                for (ListSelectedRow row : selectedRows) {
                    pkList.add((Long)row.getPrimaryKeyValue());
                }
                billFormId = list.getListModel().getEntityId();
            } else {
                pkList.add((Long)this.getModel().getDataEntity().getPkValue());
                billFormId = this.getView().getEntityId();
            }
            logger.info(billFormId + pkList + "\u8c03\u7528bei\u8054\u67e5\u7535\u5b50\u56de\u5355\u5fae\u670d\u52a1");
            Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getReceiptIdByIds", (Object[])new Object[]{billFormId, new HashSet(pkList)});
            if (result != null) {
                Map receiptMap = (Map)result;
                ArrayList<Object> receiptIds = new ArrayList<Object>(receiptMap.size());
                for (Long id : pkList) {
                    if (receiptMap.containsKey(id) && !((Set)receiptMap.get(id)).isEmpty()) {
                        receiptIds.addAll((Collection)receiptMap.get(id));
                        continue;
                    }
                    logger.warn("\u5355\u636e" + id + "\u6682\u65e0\u5bf9\u5e94\u7684\u7535\u5b50\u56de\u5355\u8bb0\u5f55");
                }
                if (receiptIds.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"ElecReceiptQueryPlugin_0", (String)"bos-ext-tmc", (Object[])new Object[0]));
                    return;
                }
                logger.info("\u67e5\u8be2\u5230" + receiptIds.size() + "\u6761\u7535\u5b50\u56de\u5355" + receiptIds);
                this.showReceipt(receiptIds);
            }
        }
    }

    private void showReceipt(List<Object> receiptIds) {
        logger.info("\u8c03\u7528bei\u83b7\u53d6\u7535\u5b50\u56de\u5355\u9884\u89c8\u94fe\u63a5\u5fae\u670d\u52a1");
        Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getReceiptPdfUrl", (Object[])new Object[]{this.getView().getPageId(), receiptIds.toArray()});
        if (result != null) {
            this.openForm(this.getView(), result.toString());
        }
    }

    private void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_printpreview");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("src", (Object)pdfUrl);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ElecReceiptQueryPlugin_1", (String)"bos-ext-tmc", (Object[])new Object[0]));
            view.getParentView().showForm(formShowParameter);
            view.sendFormAction(view.getParentView());
        }
    }
}

