/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageService {
    private static final Log logger = LogFactory.getLog((String)MessageService.class.getName());

    public static void sendScheduleShemaExecMessage(DynamicObject schemaSum, ScheduleExceOperInfo exceOperInfo) {
        DynamicObject receiver = schemaSum.getDynamicObject("inforeceiver");
        if (null == receiver) {
            logger.info("info receiver is empty");
            return;
        }
        long failLogCnt = exceOperInfo.getOperRTFC();
        if (failLogCnt > 0L) {
            String messContent = MessageService.buildMessageContent(schemaSum, exceOperInfo);
            MessageInfo waitingMessage = MessageService.buildMessage(schemaSum, messContent, exceOperInfo.getSumLogId());
            try {
                long sendMsgId = MessageCenterServiceHelper.sendMessage((MessageInfo)waitingMessage);
                logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask: %s, messageID: %s", SerializationUtils.toJsonString((Object)waitingMessage), sendMsgId));
            }
            catch (Exception e) {
                logger.error("FailedSendMessagePlanExecutionSummarySendTask: " + SerializationUtils.toJsonString((Object)waitingMessage));
            }
        }
    }

    public static void sendScheduleTaskErrorMessage(DynamicObject sche, DynamicObject taskLog) {
        DynamicObject receiver = sche.getDynamicObject("inforeceiver");
        if (null == receiver) {
            logger.info("info receiver is empty");
            return;
        }
        String messContent = String.format(ResManager.loadKDString((String)"%1$s %2$s\uff1a\u3010%3$s\u3011\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u6267\u884c\u8be6\u60c5\uff1a%4$s", (String)"MessageService_4", (String)"bos-ext-tmc", (Object[])new Object[0]), sche.getString("number"), sche.getString("name"), taskLog.getString("taskname"), taskLog.getString("executedetails"));
        MessageInfo waitingMessage = MessageService.buildTaskMessage(sche, messContent, sche.getPkValue().toString());
        try {
            long sendMsgId = MessageCenterServiceHelper.sendMessage((MessageInfo)waitingMessage);
            logger.info(String.format("successToSendMessagePlanExecutionSummarySendTask: %s, messageID: %s", SerializationUtils.toJsonString((Object)waitingMessage), sendMsgId));
        }
        catch (Exception e) {
            logger.error("FailedSendMessagePlanExecutionSummarySendTask: " + SerializationUtils.toJsonString((Object)waitingMessage));
        }
    }

    private static MessageInfo buildMessage(DynamicObject schemaSum, String messContent, Long sumLogId) {
        DynamicObject receiver = schemaSum.getDynamicObject("inforeceiver");
        MessageInfo message = new MessageInfo();
        Long schemaId = schemaSum.getLong("id");
        message.setTitle(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u65b9\u6848%s\u6267\u884c\u5f02\u5e38\u901a\u77e5", (String)"MessageService_1", (String)"bos-ext-tmc", (Object[])new Object[0]), schemaSum.getString("number")));
        message.setContent(messContent);
        message.setTag(ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u65b9\u6848", (String)"MessageService_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
        message.setUserIds(Collections.singletonList(receiver.getLong("id")));
        message.setType("warning");
        message.setEntityNumber("fcs_schedule_log");
        message.setOperation("modify");
        message.setBizDataId(schemaId);
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=list&list_formId=bos_list&sumlogid=%s", "fcs_schedule_log", sumLogId);
        message.setContentUrl(contentUrl);
        message.setNotifyType(MessageChannels.MC.getNumber());
        return message;
    }

    private static MessageInfo buildTaskMessage(DynamicObject schemaSum, String content, String redirectId) {
        DynamicObject receiver = schemaSum.getDynamicObject("inforeceiver");
        MessageInfo message = new MessageInfo();
        Long schemaId = schemaSum.getLong("id");
        message.setTitle(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u65b9\u6848%s\u6267\u884c\u5f02\u5e38\u901a\u77e5", (String)"MessageService_1", (String)"bos-ext-tmc", (Object[])new Object[0]), schemaSum.getString("number")));
        message.setContent(content);
        message.setTag(ResManager.loadKDString((String)"\u8d44\u91d1\u4efb\u52a1\u8c03\u5ea6\u65b9\u6848", (String)"MessageService_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
        message.setUserIds(Collections.singletonList(receiver.getLong("id")));
        message.setType("warning");
        message.setEntityNumber("fcs_schedule_proposal");
        message.setOperation("modify");
        message.setBizDataId(schemaId);
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=list&list_formId=bos_list&sumlogid=%s", "fcs_schedule_proposal", redirectId);
        message.setContentUrl(contentUrl);
        message.setNotifyType(MessageChannels.MC.getNumber());
        return message;
    }

    private static String buildMessageContent(DynamicObject schemaSum, ScheduleExceOperInfo exceOperInfo) {
        return String.format(ResManager.loadKDString((String)"%1$s %2$s\uff1a\u3010%3$s\u3011\u4efb\u52a1\u6267\u884c\u5f02\u5e38\u3002\u6267\u884c\u8be6\u60c5\uff1a\u672c\u4efb\u52a1\u6267\u884c\u6210\u529f\u3010%4$s\u3011\u6761\u6570\u636e\uff0c\u5f02\u5e38\u3010%5$s\u3011\u6761\u6570\u636e\u3002", (String)"MessageService_3", (String)"bos-ext-tmc", (Object[])new Object[0]), schemaSum.getString("number"), schemaSum.getString("name"), exceOperInfo.getOperName(), exceOperInfo.getOperRTSC(), exceOperInfo.getOperRTFC());
    }
}

