/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.enums.TaskExecuteStatusEnum;
import kd.bos.ext.tmc.enums.TaskQueryDerictionEnum;
import kd.bos.ext.tmc.task.thread.TaskExecutor;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.TaskFlowHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TaskExecuteImpl
extends AbstractTask {
    private static final String TASKFLOW = "taskflow";
    private List<Long> ids = new ArrayList<Long>(10);
    private Map<Object, String> errorBillnoMap = new HashMap<Object, String>(16);
    private Map<Object, Pair<Integer, String>> errorInfo = new HashMap<Object, Pair<Integer, String>>(16);
    private Map<Object, Pair<Long, Long>> costTimeMap = new HashMap<Object, Pair<Long, Long>>(16);
    private static final Log logger = LogFactory.getLog(TaskExecuteImpl.class);
    private String bizEntity;
    private Map<Long, List<Long>> relathion = new HashMap<Long, List<Long>>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext contexts, Map<String, Object> params) throws KDException {
        HashMap<String, Object> resultMap;
        Map<String, Object> taskLog;
        block13: {
            long sumLogId = DBServiceHelper.genGlobalLongId();
            String taskJson = (String)params.get(TASKFLOW);
            DynamicObject taskFlow = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)taskJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fcs_taskflow"))[0];
            long userId = contexts.getCurrUserId();
            taskLog = this.createSumTaskLog(taskFlow, sumLogId, userId);
            resultMap = new HashMap<String, Object>(16);
            try {
                this.ids = (List)params.get("ids");
                resultMap.put(TASKFLOW, taskJson);
                DynamicObjectCollection tasks = taskFlow.getDynamicObjectCollection("taskentry");
                this.bizEntity = taskFlow.getDynamicObject("bizentity").getString("number");
                boolean isRevoperate = taskFlow.getBoolean("isrevoperate");
                String queryDeriction = taskFlow.getString("queryderiction");
                boolean isUpToDownStream = isRevoperate && TaskQueryDerictionEnum.UPTODOWN.getValue().equals(queryDeriction);
                boolean isDownToUpStream = isRevoperate && TaskQueryDerictionEnum.DOWNTOUP.getValue().equals(queryDeriction);
                ArrayList<Pair<String, List<Long>>> taskExeBillIds = new ArrayList<Pair<String, List<Long>>>(tasks.size());
                if (isDownToUpStream) {
                    List<Long> billId = this.FindExeBillIdByDownToUpStream(taskExeBillIds, tasks, this.ids);
                    taskExeBillIds.clear();
                    logger.info("billId\uff1a" + billId.toString());
                    List<Long> beginBillId = this.FindExeBillIdByUpToDownStream(taskExeBillIds, tasks, billId, true);
                    logger.info("beginBillId\uff1a" + beginBillId.toString());
                    Set<Long> fitBillIds = TaskFlowHelper.getFitBillIds(taskFlow, this.bizEntity, beginBillId);
                    logger.info("fitBillIds\uff1a" + fitBillIds.toString());
                    if (fitBillIds.size() < beginBillId.size()) {
                        taskExeBillIds.clear();
                        beginBillId = new ArrayList<Long>(fitBillIds);
                        this.FindExeBillIdByRelathion(taskExeBillIds, tasks, new ArrayList<Long>(fitBillIds));
                        Collections.reverse(taskExeBillIds);
                    }
                    logger.info("\u4efb\u52a1\u89e6\u53d1\u64cd\u4f5c\u7684id\uff1a" + beginBillId.toString());
                    if (EmptyUtil.isEmpty(beginBillId)) {
                        List<String> errorInfo = Collections.singletonList(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u7f16\u6392\u65b9\u6848\u3002", (String)"TaskExecuteImpl_1", (String)"bos-ext-tmc", (Object[])new Object[0]));
                        resultMap.put("beginexception", errorInfo);
                        this.feedbackCustomdata(resultMap);
                        throw new KDBizException(errorInfo.get(0));
                    }
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    OperationResult result = OperationServiceHelper.executeOperate((String)taskFlow.getString("beginoperate"), (String)this.bizEntity, (Object[])beginBillId.toArray(), (OperateOption)option);
                    if (!result.isSuccess()) {
                        List errorInfo = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                        resultMap.put("beginexception", errorInfo);
                        this.feedbackCustomdata(resultMap);
                        List successPkIds = result.getSuccessPkIds();
                        if (successPkIds.size() == 0) {
                            throw new Exception(result.getMessage());
                        }
                        taskExeBillIds.clear();
                        this.FindExeBillIdByRelathion(taskExeBillIds, tasks, successPkIds.stream().map(s -> Long.parseLong(s.toString())).collect(Collectors.toList()));
                        Collections.reverse(taskExeBillIds);
                    }
                } else if (isUpToDownStream) {
                    this.FindExeBillIdByUpToDownStream(taskExeBillIds, tasks, this.ids, false);
                }
                for (int index = 0; index < tasks.size(); ++index) {
                    if (isRevoperate) {
                        this.RevoperateExecute(taskExeBillIds, tasks, index, resultMap, sumLogId, taskFlow, taskLog);
                        continue;
                    }
                    this.OperateExecute(tasks, index, resultMap, sumLogId, taskFlow, taskLog);
                }
                if (!isUpToDownStream) break block13;
                this.ids = (List)params.get("ids");
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)taskFlow.getString("beginoperate"), (String)this.bizEntity, (Object[])this.ids.toArray(new Object[0]), (OperateOption)option);
                if (result.isSuccess()) break block13;
                List errorInfo = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                resultMap.put("beginexception", errorInfo);
                this.feedbackCustomdata(resultMap);
            }
            catch (Exception e) {
                try {
                    taskLog.put("Exception", e.getMessage());
                    taskLog.put("Exestatus", TaskExecuteStatusEnum.FAIL.getValue());
                    logger.info("\u4efb\u52a1\u7f16\u6392\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
                    this.stop();
                }
                catch (Throwable throwable) {
                    DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveSumLogs", (Object[])new Object[]{taskLog, resultMap});
                    throw throwable;
                }
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveSumLogs", (Object[])new Object[]{taskLog, resultMap});
            }
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveSumLogs", (Object[])new Object[]{taskLog, resultMap});
    }

    private List<Long> FindExeBillIdByDownToUpStream(List<Pair<String, List<Long>>> taskExeBillIds, DynamicObjectCollection tasks, List<Long> targetBillId) {
        String lastEntityNumber = this.bizEntity;
        for (DynamicObject task : tasks) {
            String thisEntityNumber = task.getDynamicObject("mainentity").getString("number");
            if (!lastEntityNumber.equals(thisEntityNumber)) {
                logger.info("lastEntityNumber:" + lastEntityNumber);
                logger.info("thisEntityNumber:" + thisEntityNumber);
                targetBillId = this.getAllSrcBillIds(lastEntityNumber, targetBillId, thisEntityNumber);
                taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, targetBillId));
                lastEntityNumber = thisEntityNumber;
                continue;
            }
            taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, targetBillId));
        }
        return targetBillId;
    }

    private void FindExeBillIdByRelathion(List<Pair<String, List<Long>>> taskExeBillIds, DynamicObjectCollection tasks, List<Long> targetBillId) {
        String lastEntityNumber = this.bizEntity;
        for (DynamicObject task : tasks) {
            String thisEntityNumber = task.getDynamicObject("mainentity").getString("number");
            if (!lastEntityNumber.equals(thisEntityNumber)) {
                ArrayList<Long> tempList = new ArrayList<Long>(targetBillId);
                targetBillId.clear();
                tempList.forEach(id -> targetBillId.addAll((Collection)this.relathion.get(id)));
                taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, new ArrayList<Long>(targetBillId)));
                lastEntityNumber = thisEntityNumber;
                continue;
            }
            taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, new ArrayList<Long>(targetBillId)));
        }
    }

    private List<Long> FindExeBillIdByUpToDownStream(List<Pair<String, List<Long>>> taskExeBillIds, DynamicObjectCollection tasks, List<Long> srcBillId, boolean isDownToUpStream) {
        String lastEntityNumber = isDownToUpStream ? ((DynamicObject)tasks.get(tasks.size() - 1)).getDynamicObject("mainentity").getString("number") : this.bizEntity;
        for (int index = tasks.size() - 1; index >= 0; --index) {
            DynamicObject task = (DynamicObject)tasks.get(index);
            String thisEntityNumber = task.getDynamicObject("mainentity").getString("number");
            if (!lastEntityNumber.equals(thisEntityNumber)) {
                srcBillId = this.getAllTargetBillIds(lastEntityNumber, srcBillId, thisEntityNumber);
                taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, srcBillId));
                lastEntityNumber = thisEntityNumber;
                continue;
            }
            taskExeBillIds.add((Pair<String, List<Long>>)Pair.of((Object)thisEntityNumber, srcBillId));
        }
        if (isDownToUpStream && !lastEntityNumber.equals(this.bizEntity)) {
            return this.getAllTargetBillIds(lastEntityNumber, srcBillId, this.bizEntity);
        }
        return srcBillId;
    }

    private void OperateExecute(DynamicObjectCollection tasks, int index, Map<String, Object> resultMap, long sumLogId, DynamicObject taskFlow, Map<String, Object> taskLog) {
        DynamicObject task = (DynamicObject)tasks.get(index);
        if (task.getBoolean("isacrossbill")) {
            String lastEntityNumber = index > 0 ? ((DynamicObject)tasks.get(index - 1)).getDynamicObject("mainentity").getString("number") : this.bizEntity;
            String thisEntityNumber = task.getDynamicObject("mainentity").getString("number");
            this.ids = this.getAllTargetBillIds(lastEntityNumber, this.ids, thisEntityNumber);
        }
        this.executeTask(resultMap, task, index, sumLogId, taskFlow);
        this.feedbackCustomdata(resultMap);
    }

    private void RevoperateExecute(List<Pair<String, List<Long>>> taskExeBillIds, DynamicObjectCollection tasks, int index, Map<String, Object> resultMap, long sumLogId, DynamicObject taskFlow, Map<String, Object> taskLog) {
        List successIds;
        DynamicObject task = (DynamicObject)tasks.get(index);
        this.ids = (List)taskExeBillIds.get(tasks.size() - 1 - index).getRight();
        this.executeTask(resultMap, task, index, sumLogId, taskFlow);
        Map errorInfoTemp = (Map)resultMap.get("errorInfo");
        Map errorBillnoMapTemp = (Map)resultMap.get("errorBillnoMap");
        Map costTimeMapTemp = (Map)resultMap.get("costTimeMap");
        if (errorInfoTemp != null) {
            for (Map.Entry info : errorInfoTemp.entrySet()) {
                Object key = info.getKey();
                if (this.errorInfo.containsKey(key)) continue;
                this.errorInfo.put(key, (Pair<Integer, String>)info.getValue());
                this.costTimeMap.put(key, (Pair<Long, Long>)costTimeMapTemp.get(key));
            }
            this.errorBillnoMap.putAll(errorBillnoMapTemp);
        }
        if ((successIds = (List)resultMap.get("successIds")) != null) {
            for (Object successId : successIds) {
                this.errorInfo.keySet().removeIf(next -> next.toString().contains(successId.toString()));
            }
        }
        if (index == tasks.size() - 1 || ((DynamicObject)tasks.get(index + 1)).getBoolean("isacrossbill")) {
            ArrayList<Map<String, Object>> taskLogList = new ArrayList<Map<String, Object>>(this.errorInfo.size());
            for (Map.Entry<Object, Pair<Integer, String>> info : this.errorInfo.entrySet()) {
                int taskSeq = (Integer)info.getValue().getLeft();
                String exception = (String)info.getValue().getRight();
                Long billId = Long.valueOf(info.getKey().toString().split("_")[0]);
                resultMap.put("result" + taskSeq, TaskExecuteStatusEnum.FAIL.getValue());
                String errs = resultMap.containsKey("exception" + taskSeq) ? resultMap.get("exception" + taskSeq) + "\n" + exception : exception;
                resultMap.put("exception" + taskSeq, errs);
                String entityNumber = ((DynamicObject)tasks.get(taskSeq)).getDynamicObject("mainentity").getString("number");
                Pair operate = Pair.of((Object)((DynamicObject)tasks.get(taskSeq)).getString("operatekey"), (Object)((DynamicObject)tasks.get(taskSeq)).getString("operatename"));
                Map<String, Object> taskDetailLog = TaskFlowHelper.createDetailTaskLog((Long)this.costTimeMap.get(info.getKey()).getLeft(), (Long)this.costTimeMap.get(info.getKey()).getRight(), entityNumber, (Pair<String, String>)operate, sumLogId, taskFlow);
                taskDetailLog.put("BizBillId", billId);
                taskDetailLog.put("BizBillno", this.errorBillnoMap.get(billId));
                taskDetailLog.put("Result", TaskExecuteStatusEnum.FAIL.getValue());
                taskDetailLog.put("Exception", exception);
                taskLogList.add(taskDetailLog);
                taskLog.put("Exestatus", TaskExecuteStatusEnum.FAIL.getValue());
            }
            this.errorInfo.clear();
            this.feedbackCustomdata(resultMap);
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveDetailLogs", (Object[])new Object[]{taskLogList});
        }
    }

    private void executeTask(Map<String, Object> resultMap, DynamicObject task, int index, long sumLogId, DynamicObject taskFlow) {
        TaskExecutor executor = new TaskExecutor();
        if (this.ids.size() > 0) {
            resultMap.putAll(executor.execute(task, this.ids.toArray(new Object[0]), index, sumLogId, taskFlow));
            this.ids = (List)resultMap.get("successid" + index);
        } else {
            resultMap.put("result" + index, TaskExecuteStatusEnum.FAIL.getValue());
            resultMap.put("exception" + index, ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaskExecuteImpl_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> createSumTaskLog(DynamicObject taskFlow, long sumLogId, long userId) {
        HashMap<String, Object> taskLog = new HashMap<String, Object>(16);
        taskLog.put("LogType", "taskexecute");
        taskLog.put("Time", System.currentTimeMillis());
        taskLog.put("TaskName", taskFlow.getString("name"));
        taskLog.put("TaskNumber", taskFlow.getString("number"));
        taskLog.put("Executor", userId);
        taskLog.put("SumLogId", sumLogId);
        taskLog.put("SumLog", true);
        return taskLog;
    }

    private List<Long> getAllTargetBillIds(String currEntity, List<Long> currEntityId, String targetEntity) {
        HashSet ids = new HashSet(16);
        currEntityId.forEach(id -> {
            Long[] targetBillIds = TaskFlowHelper.getTargetBillIds(currEntity, id, targetEntity);
            if (targetBillIds != null && targetBillIds.length > 0) {
                Arrays.stream(targetBillIds).forEach(t -> {
                    if (this.relathion.containsKey(t)) {
                        this.relathion.get(t).add((Long)id);
                    } else {
                        ArrayList<Long> upList = new ArrayList<Long>();
                        upList.add((Long)id);
                        this.relathion.put((Long)t, (List<Long>)upList);
                    }
                });
                ids.addAll(Arrays.asList(targetBillIds));
            }
        });
        return new ArrayList<Long>(ids);
    }

    private List<Long> getAllSrcBillIds(String currEntity, List<Long> currEntityId, String srcEntity) {
        HashSet ids = new HashSet();
        currEntityId.forEach(id -> {
            Long[] targetBillIds = TaskFlowHelper.getSrcBillIds(currEntity, id, srcEntity);
            if (targetBillIds != null && targetBillIds.length > 0) {
                ids.addAll(Arrays.asList(targetBillIds));
            }
        });
        return new ArrayList<Long>(ids);
    }
}

