/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.dao.FormDesignDao;
import kd.bos.ext.tmc.dao.ScheduleSchemaExecLogDao;
import kd.bos.ext.tmc.enums.ScheduleExecuteStatus;
import kd.bos.ext.tmc.enums.ScheduleExecuteType;
import kd.bos.ext.tmc.model.ScheduleExceOperInfo;
import kd.bos.ext.tmc.model.ScheduleProposalExecInfo;
import kd.bos.ext.tmc.task.impl.VchBatchExecute;
import kd.bos.ext.tmc.utils.ScheduleExecuteUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class VoucherBatchBuildExecService {
    private static final Log LOG = LogFactory.getLog(VoucherBatchBuildExecService.class);
    private static final int MAX_PROCESS_RECORDS = 100000;
    private static final int MAX_BUSINESS_COUNT = 1000000;
    protected static final int BATCH_SIZE = 2000;
    private ScheduleProposalExecInfo schemeExecInfo;
    private List<QFilter> commonFilters;
    private String scheduleTaskId;
    private ScheduleExecuteType paramType;
    private long sumLogId;
    private long operSumLogId;
    private VchBatchExecute vchBatchExecute;

    public VoucherBatchBuildExecService(ScheduleProposalExecInfo schemeExecInfo, List<QFilter> commonDataFilters, String taskId, ScheduleExecuteType taskParamType, long sumLogId, long operSumLogId, VchBatchExecute vchBatchExecute) {
        this.schemeExecInfo = schemeExecInfo;
        this.commonFilters = commonDataFilters;
        this.scheduleTaskId = taskId;
        this.paramType = taskParamType;
        this.sumLogId = sumLogId;
        this.operSumLogId = operSumLogId;
        this.vchBatchExecute = vchBatchExecute;
    }

    public void executeBatch() {
        block4: {
            try {
                String orgFieldName = this.getEntityOrgFieldName();
                ArrayList<BillVO> waitingBills = new ArrayList<BillVO>(16);
                this.getIdByTableDapw(orgFieldName, waitingBills);
                LOG.info(" getIdByTableDapw_size {}", (Object)waitingBills.size());
                if (waitingBills.size() < 100000) {
                    this.getIdByBusinessTask(orgFieldName, waitingBills);
                    LOG.info(" getIdByBusinessTask_size {}", (Object)waitingBills.size());
                }
                if (waitingBills.size() == 0) {
                    this.getIdByBill(orgFieldName, waitingBills);
                }
                LOG.info(" waitingBills_size {}", (Object)waitingBills.size());
                HashSet<BillVO> bills = new HashSet<BillVO>(waitingBills);
                this.process(new ArrayList<BillVO>(bills));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                if (this.operSumLogId == 0L) break block4;
                this.writeErrorLog(e.getMessage());
            }
        }
    }

    private void getIdByBill(String orgFieldName, List<BillVO> waitingBills) {
        HashSet<Long> billIds = new HashSet<Long>(16);
        DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.schemeExecInfo.getExceOperInfo().getBussiness(), (String)"id", (QFilter[])this.commonFilters.toArray(new QFilter[0]), null);
        while (rows.hasNext()) {
            Row next = rows.next();
            billIds.add(next.getLong("id"));
            if (billIds.size() != 2000 && rows.hasNext()) continue;
            if (ScheduleExecuteUtil.isStopExcute(this.schemeExecInfo)) break;
            waitingBills.addAll(this.getBillVO(billIds, orgFieldName));
            billIds.clear();
        }
    }

    private void getIdByTableDapw(String orgFieldName, List<BillVO> waitingBills) {
        String tableName;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        DBRoute dbRouteKey = DBRoute.of((String)dataEntityType.getDBRouteKey());
        boolean exitsTable = DB.exitsTable((DBRoute)dbRouteKey, (String)(tableName = dataEntityType.getAlias() + "_DAPW"));
        if (exitsTable) {
            if (this.hasDAPWMaxBillType(dbRouteKey, tableName)) {
                return;
            }
            String sqlQuery = "SELECT fsourcebillid FROM " + tableName + " ORDER BY fsourcebillid DESC";
            DB.query((DBRoute)dbRouteKey, (String)sqlQuery, rs -> {
                HashSet<Long> sourcebillIdlst = new HashSet<Long>(16);
                boolean hasNext = rs.next();
                while (waitingBills.size() < 100000) {
                    if (hasNext) {
                        sourcebillIdlst.add(rs.getLong("fsourcebillid"));
                        if (sourcebillIdlst.size() % 2000 == 0 || !(hasNext = rs.next())) {
                            if (ScheduleExecuteUtil.isStopExcute(this.schemeExecInfo)) break;
                            waitingBills.addAll(this.getBillVO(sourcebillIdlst, orgFieldName));
                            sourcebillIdlst.clear();
                        }
                    }
                    if (hasNext) continue;
                    break;
                }
                return null;
            });
        }
    }

    private void getIdByBusinessTask(String orgFieldName, List<BillVO> waitingBills) {
        if (this.hasMaxBillType()) {
            return;
        }
        try (DataSet successBusinessData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"iep_businesstask", (String)"entityid", (QFilter[])new QFilter("business", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()).toArray(), (String)"entityid desc");){
            HashSet<Long> entityids = new HashSet<Long>(16);
            while (successBusinessData.hasNext()) {
                if (waitingBills.size() >= 100000) {
                    break;
                }
                entityids.add(successBusinessData.next().getLong("entityid"));
                if (entityids.size() % 2000 != 0 && successBusinessData.hasNext()) continue;
                if (ScheduleExecuteUtil.isStopExcute(this.schemeExecInfo)) {
                    break;
                }
                waitingBills.addAll(this.getBillVO(entityids, orgFieldName));
                entityids.clear();
            }
        }
    }

    private boolean hasMaxBillType() {
        IAppCache iep = AppCache.get((String)"iep");
        String key = String.format("businesstask-billtype-%s-count", this.schemeExecInfo.getExceOperInfo().getBussiness());
        Long count = (Long)iep.get(key, Long.class);
        if (Objects.isNull(iep.get(key, Long.class))) {
            count = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"iep_businesstask", (String)"entityid", (QFilter[])new QFilter("business", "=", (Object)this.schemeExecInfo.getExceOperInfo().getBussiness()).toArray(), null).count("entityid", true);
            iep.put(key, (Object)count);
        }
        LOG.info("hasMaxBillType_SIZE {}", (Object)count);
        return count > 1000000L;
    }

    private boolean hasDAPWMaxBillType(DBRoute route, String tableName) {
        IAppCache iep = AppCache.get((String)"iep");
        String key = String.format("businesstask-dapw-billtype-%s-count", tableName);
        Long count = (Long)iep.get(key, Long.class);
        if (Objects.isNull(iep.get(key, Long.class))) {
            String sql = "SELECT count(*) FROM " + tableName + "";
            count = (Long)DB.query((DBRoute)route, (String)sql, resultSet -> {
                resultSet.next();
                Long countN = resultSet.getLong(1);
                iep.put(key, (Object)countN);
                return countN;
            });
        }
        LOG.info("hasDAPWMaxBillType_SIZE {}", (Object)count);
        return count > 1000000L;
    }

    private List<BillVO> getBillVO(Set<Long> bullIds, String orgFieldName) {
        DataSet result;
        QFilter[] filters;
        ScheduleExceOperInfo exceOperInfo = this.schemeExecInfo.getExceOperInfo();
        QFilter qfId = new QFilter("id", "in", bullIds);
        if (Objects.isNull(this.commonFilters)) {
            filters = qfId.toArray();
        } else {
            ArrayList<QFilter> filter = new ArrayList<QFilter>(this.commonFilters);
            filter.add(qfId);
            filters = filter.toArray(new QFilter[0]);
        }
        if (Objects.nonNull(orgFieldName)) {
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)exceOperInfo.getBussiness(), (String)("id," + orgFieldName), (QFilter[])filters, null);
        } else {
            orgFieldName = "org";
            result = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)exceOperInfo.getBussiness(), (String)"id", (QFilter[])filters, null).addField("0", orgFieldName);
        }
        ArrayList<BillVO> waitingBills = new ArrayList<BillVO>(16);
        while (result.hasNext()) {
            Row entry = result.next();
            waitingBills.add(new BillVO(entry.getLong("id"), entry.getLong(orgFieldName)));
        }
        LOG.info(String.format("intell_bill_size: %s", waitingBills.size()));
        result.close();
        return waitingBills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(List<BillVO> bills) {
        Date execStartDate = new Date();
        ScheduleExceOperInfo exceOperInfo = this.schemeExecInfo.getExceOperInfo();
        this.schemeExecInfo.appendRecordTC(bills.size());
        ScheduleProposalExecInfo.execInfoWriteCache(this.schemeExecInfo);
        if (CollectionUtils.isEmpty(bills)) {
            LOG.info("intell_schema_build_voucher batch: 0, just tag, dont write log.");
            String bussinessName = FormDesignDao.getDesignFormName(exceOperInfo.getBussiness());
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u8be5\u65b9\u6848\u3010%1$s%2$s\u3011\u64cd\u4f5c\u7684\u524d\u7f6e\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"VoucherBatchBuildExecService_1", (String)"bos-ext-tmc", (Object[])new Object[0]), bussinessName, exceOperInfo.getOperName());
            exceOperInfo.setExecDetails(msg);
            exceOperInfo.setExecuteStatus(ScheduleExecuteStatus.FAIL);
            return;
        }
        HashMap orgBillGroup = new HashMap();
        for (BillVO billVO : bills) {
            if (!orgBillGroup.containsKey(billVO.getOrgId())) {
                orgBillGroup.put(billVO.getOrgId(), new ArrayList(16));
            }
            ((List)orgBillGroup.get(billVO.getOrgId())).add(billVO.getBillId());
        }
        List sortedOrgBills = orgBillGroup.entrySet().stream().map(x -> new OrgBillGroup((Long)x.getKey(), (List)x.getValue())).sorted().collect(Collectors.toList());
        int BATCH_SIZE = Math.max(this.schemeExecInfo.getExceOperInfo().getEachbatchsize(), 10000);
        ArrayList<Long> curBatch = new ArrayList(BATCH_SIZE);
        StringBuffer errMsg = new StringBuffer();
        StringBuffer batchErrMsg = null;
        ScheduleExecuteStatus operStatus = ScheduleExecuteStatus.FAIL;
        HashSet<ScheduleExecuteStatus> operStatusSet = new HashSet<ScheduleExecuteStatus>(3);
        try (TraceSpan submitSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)"submitData");){
            Iterator iterator = sortedOrgBills.iterator();
            while (iterator.hasNext()) {
                block49: {
                    OrgBillGroup curGroup = (OrgBillGroup)iterator.next();
                    if (curGroup.count() > BATCH_SIZE) {
                        int batchCount = (int)Math.ceil((double)curGroup.count() * 1.0 / (double)BATCH_SIZE);
                        int batchIndex = 0;
                    }
                    curBatch.addAll(curGroup.billIds);
                    batchErrMsg = new StringBuffer();
                    try {
                        try (TraceSpan batchSpan = Tracer.create((String)VoucherBatchBuildExecService.class.getSimpleName(), (String)String.format("submitBatch_%s_%s", curGroup.getOrgId(), curBatch.size()));){
                            operStatus = this.vchBatchExecute.startExecOperation(exceOperInfo.getSchemaId(), bills.size(), new Date(), errMsg, curBatch, true);
                            operStatusSet.add(operStatus);
                            exceOperInfo.setExecDetails(batchErrMsg.toString());
                            LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s, cost: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg, Tracer.getCurrentSpan().getCost()}));
                        }
                        if (ScheduleExecuteStatus.FAIL != operStatus) break block49;
                    }
                    catch (Throwable throwable) {
                        if (ScheduleExecuteStatus.FAIL != operStatus) throw throwable;
                        LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg}));
                        throw throwable;
                    }
                    LOG.info(String.format("intell_schema_build_voucher bills: %s, batch: %s, org: %s, status: %s, msg: %s", new Object[]{bills.size(), curBatch.size(), curGroup.orgId, operStatus, batchErrMsg}));
                }
                curBatch.clear();
                if (operStatusSet.contains((Object)ScheduleExecuteStatus.STOP)) {
                    operStatus = ScheduleExecuteStatus.STOP;
                } else if (operStatusSet.contains((Object)ScheduleExecuteStatus.FAIL)) {
                    operStatus = ScheduleExecuteStatus.FAIL;
                }
                exceOperInfo.setExecuteStatus(operStatus);
            }
            return;
        }
        catch (KDBizException e) {
            exceOperInfo.setExecuteStatus(ScheduleExecuteStatus.FAIL);
            LOG.error((Throwable)e);
        }
    }

    public String getEntityOrgFieldName() {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)this.schemeExecInfo.getExceOperInfo().getBussiness());
        return bizEntityType.getMainOrg();
    }

    private void writeErrorLog(String msg) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"fcs_scheduledetail_log");
                ScheduleSchemaExecLogDao.createExeLog(this.schemeExecInfo.getExceOperInfo(), new Date(), logObj, null, ScheduleExecuteStatus.FAIL.getStatus(), 0, msg, this.vchBatchExecute.traceId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
                ScheduleSchemaExecLogDao.updateOperSumLog(this.operSumLogId, ScheduleExecuteStatus.FAIL.getStatus(), new Date(), msg);
                ScheduleSchemaExecLogDao.updateExecSumLog(this.sumLogId, ScheduleExecuteStatus.FAIL.getStatus(), new Date(), msg);
            }
            catch (Exception e) {
                handle.markRollback();
                LOG.error("\u751f\u6210\u51ed\u8bc1\u5199\u9519\u8bef\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    private static class OrgBillGroup
    implements Comparable<OrgBillGroup> {
        private Long orgId;
        private List<Long> billIds;

        public OrgBillGroup(Long orgId, List<Long> billIds) {
            this.orgId = orgId;
            this.billIds = billIds;
        }

        public int count() {
            if (CollectionUtils.isEmpty(this.billIds)) {
                return 0;
            }
            return this.billIds.size();
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public List<Long> getBillIds() {
            return this.billIds;
        }

        public void setBillIds(List<Long> billIds) {
            this.billIds = billIds;
        }

        @Override
        public int compareTo(OrgBillGroup another) {
            if (Objects.isNull(another)) {
                return 1;
            }
            return Integer.compare(another.count(), this.count());
        }
    }

    private static class BillVO {
        private Long billId;
        private Long orgId;

        public BillVO(Long billId, Long orgId) {
            this.billId = billId;
            this.orgId = orgId;
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BillVO billVO = (BillVO)o;
            return Objects.equals(this.billId, billVO.billId);
        }

        public int hashCode() {
            return Objects.hash(this.billId);
        }
    }
}

