/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TaskService
implements Callable<OperationResult> {
    private static final Log logger = LogFactory.getLog(TaskService.class);
    private int taskNum;
    private String entityNumber;
    private String operate;
    private Object[] bizObject;
    private String mserviceConfig;
    private boolean isCycle;

    public TaskService(String entityNumber, String operate, String mserviceConfig, Object[] bizObject, int taskNum, boolean isCycle) {
        this.entityNumber = entityNumber;
        this.operate = operate;
        this.mserviceConfig = mserviceConfig;
        this.bizObject = bizObject;
        this.taskNum = taskNum;
        this.isCycle = isCycle;
    }

    @Override
    public OperationResult call() {
        logger.info(">>>" + this.taskNum + " \u7ebf\u7a0b\u542f\u52a8");
        Date startTime = new Date();
        OperationResult result = this.executeOperate();
        if (StringUtils.isNotBlank((CharSequence)this.mserviceConfig)) {
            Map cfg = (Map)SerializationUtils.fromJsonString((String)this.mserviceConfig, Map.class);
            Map<Object, String> mResults = this.executeMservice(result.getSuccessPkIds(), cfg);
            for (Map.Entry<Object, String> mResult : mResults.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)mResult.getValue())) continue;
                result.setSuccess(false);
                result.getSuccessPkIds().remove(mResult.getKey());
                OperateErrorInfo info1 = new OperateErrorInfo("", ErrorLevel.Error, mResult.getKey());
                info1.setMessage(mResult.getValue());
                result.getAllErrorInfo().add(info1);
            }
        }
        result.setStartTime(startTime);
        result.setFinishedTime(new Date());
        return result;
    }

    private OperationResult executeOperate() {
        long startTime = System.nanoTime();
        logger.info(this.entityNumber + "\u6267\u884c\u64cd\u4f5c\uff1a" + this.operate);
        OperationResult result = new OperationResult();
        if (this.isCycle) {
            ArrayList<OperationResult> results = new ArrayList<OperationResult>(this.bizObject.length);
            boolean isSuccess = true;
            for (Object bill : this.bizObject) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("ignoreValidation", "true");
                OperationResult tempResult = OperationServiceHelper.executeOperate((String)this.operate, (String)this.entityNumber, (Object[])new Object[]{bill}, (OperateOption)option);
                if (!tempResult.isSuccess()) {
                    isSuccess = false;
                    if (tempResult.getBillNos().size() == 0) {
                        this.creatOperationResult(tempResult);
                    }
                }
                results.add(tempResult);
            }
            result.setSuccess(isSuccess);
            ValidateResultCollection validateResults = new ValidateResultCollection();
            for (OperationResult r : results) {
                result.getSuccessPkIds().addAll(r.getSuccessPkIds());
                result.getAllErrorInfo().addAll(r.getAllErrorInfo());
                r.getValidateResult().getValidateErrors().forEach(v -> validateResults.addValidateError(v.getValidatorKey(), v));
                result.getBillNos().putAll(r.getBillNos());
            }
            result.setValidateResult(validateResults);
            result.setStartTime(((OperationResult)results.get(0)).getStartTime());
            result.setFinishedTime(((OperationResult)results.get(results.size() - 1)).getFinishedTime());
        } else {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            result = OperationServiceHelper.executeOperate((String)this.operate, (String)this.entityNumber, (Object[])this.bizObject, (OperateOption)option);
            if (!result.isSuccess() && result.getBillNos().size() == 0) {
                this.creatOperationResult(result);
            }
        }
        long time = (System.nanoTime() - startTime) / 1000L / 1000L;
        logger.info(">>>" + this.taskNum + " \u7ebf\u7a0b\u7ec8\u6b62; \u8017\u65f6\uff1a" + time + "ms");
        return result;
    }

    private void creatOperationResult(OperationResult result) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)this.entityNumber, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.bizObject)});
        result.setBillNos(bills.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.getString("billno"))));
        result.setAllErrorInfo(bills.stream().map(s -> {
            OperateErrorInfo info1 = new OperateErrorInfo("", ErrorLevel.Error, s.get("id"));
            info1.setMessage(result.getMessage());
            return info1;
        }).collect(Collectors.toList()));
    }

    private Map<Object, String> executeMservice(List<Object> ids, Map<String, Object> cfg) {
        long startTime = System.nanoTime();
        String cloudId = ((String)cfg.get("cloud")).toLowerCase();
        String appId = (String)cfg.get("appid");
        String serviceName = (String)cfg.get("servicename");
        String methodname = (String)cfg.get("methodname");
        logger.info(this.entityNumber + "\u6267\u884c\u670d\u52a1\uff1a" + serviceName);
        ArrayList params = (ArrayList)cfg.get("params");
        HashMap<Object, String> executeResult = new HashMap<Object, String>(16);
        for (Object id : ids) {
            DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.entityNumber);
            ArrayList<Object> objParams = new ArrayList<Object>(10);
            for (Map param : params) {
                String expression = (String)param.get("val");
                if (expression.startsWith("${")) {
                    List<String> propertyList = Arrays.asList(expression.substring(8, expression.length() - 1).split("\\."));
                    Object val = model.get(propertyList.get(0));
                    for (int j = 1; j < propertyList.size(); ++j) {
                        if (val instanceof DynamicObject) {
                            val = ((DynamicObject)val).get(propertyList.get(j));
                            continue;
                        }
                        if (!(val instanceof DynamicObjectCollection)) continue;
                        val = ((DynamicObject)((DynamicObjectCollection)val).get(0)).get(propertyList.get(j));
                    }
                    objParams.add(val);
                    continue;
                }
                objParams.add(expression);
            }
            try {
                this.invokeMethod(cloudId, appId, serviceName, methodname, objParams.toArray());
            }
            catch (Exception e) {
                logger.error("\u6267\u884c\u670d\u52a1\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
                executeResult.put(id, e.getMessage());
                continue;
            }
            executeResult.put(id, "");
        }
        long time = (System.nanoTime() - startTime) / 1000L / 1000L;
        logger.info(">>>" + serviceName + " \u5fae\u670d\u52a1\u7ec8\u6b62; \u8017\u65f6\uff1a" + time + "ms");
        return executeResult;
    }

    private <T> T invokeMethod(String cloudId, String appId, String serviceName, String methodName, Object ... objParams) {
        return (T)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])objParams);
    }
}

