/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.commitToBe;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CommitToBeValidator
extends AbstractValidator {
    public void validate() {
        this.tryConnect();
        Object[] payBillArr = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).toArray();
        String entity = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        DynamicObjectCollection targetBillArr = QueryServiceHelper.query((String)this.getBankEntity(entity), (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)payBillArr), new QFilter("isbitback", "=", (Object)"0"), new QFilter("billstatus", "!=", (Object)"F")});
        List waitRemovePayInfoList = targetBillArr.stream().map(s -> s.get("sourcebillid")).collect(Collectors.toList());
        for (ExtendedDataEntity data : this.getDataEntities()) {
            if (!waitRemovePayInfoList.contains(data.getBillPkId())) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6709\u672a\u5b8c\u6210\u7684\u94f6\u884c\u5355\u636e, \u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01", (String)"BankPayBillCTBValidator_0", (String)"bos-ext-tmc", (Object[])new Object[0]));
        }
    }

    private void tryConnect() {
        String message = ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\u8fde\u63a5\u5f02\u5e38\uff1a", (String)"BankPayBillCTBValidator_1", (String)"bos-ext-tmc", (Object[])new Object[0]);
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"ebTestConnectService", (String)"testConnect", (Object[])new Object[0]);
            if (((Boolean)result.get("iserror")).booleanValue()) {
                throw new KDBizException(message + result.get("message"));
            }
        }
        catch (Exception e) {
            throw new KDBizException(message + e.getMessage());
        }
    }

    protected String getBankEntity(String entity) {
        String bankEntity = "";
        switch (entity) {
            case "cas_paybill": {
                bankEntity = "bei_bankpaybill";
                break;
            }
            case "cas_agentpaybill": {
                bankEntity = "bei_bankagentpay";
                break;
            }
            case "fca_transupbill": {
                bankEntity = "bei_banktransupbill";
                break;
            }
            case "fca_transdownbill": {
                bankEntity = "bei_banktransdownbill";
                break;
            }
            case "ifm_transhandlebill": {
                bankEntity = "bei_bankpaybill";
            }
        }
        return bankEntity;
    }
}

