/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;

public class MutexServiceHelper {
    protected static final String MUTEX_DATAOBJID = "dataObjId";
    protected static final String MUTEX_GROUPID = "groupId";
    protected static final String MUTEX_ENTITYKEY = "entityKey";
    protected static final String MUTEX_OPERATIONKEY = "operationKey";
    protected static final String MUTEX_ISSTRICT = "isStrict";

    public static Map<String, Boolean> batchRequest(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRequest(ids, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRequest(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchrequire(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Map<String, Boolean> batchRelease(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRelease(ids, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRelease(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchRelease(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean request(String id, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.request(id, group, entityKey, opKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean request(String id, String group, String entityKey, String opKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            boolean bl = dataMutex.require(id, group, entityKey, opKey, true);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean release(String id, String entityKey, String operationKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            boolean bl = dataMutex.release(id, entityKey, operationKey);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }
}

