/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper.fbd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.tmc.model.fbd.AttachTypeItem;
import kd.bos.ext.tmc.model.fbd.AttachTypePanelCache;
import kd.bos.ext.tmc.model.fbd.AttachTypeSetting;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.fbd.AttachTypeHelper;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AttachTypeFactory {
    private static final String FBD_AT_CACHE_KEY = "fbd_attach_type";

    public static AttachTypePanelCache initAttachmentCache(IFormView view, String initType) {
        AttachTypeItem typeItem;
        AttachTypePanelCache cache = new AttachTypePanelCache();
        DynamicObject setting = AttachTypeFactory.getMatchAttachType(view);
        ArrayList<AttachTypeItem> typeItemList = new ArrayList<AttachTypeItem>(10);
        HashMap<Long, AttachTypeItem> typeItemMap = new HashMap<Long, AttachTypeItem>(16);
        if (EmptyUtil.isNoEmpty(setting)) {
            DynamicObjectCollection typeItems = setting.getDynamicObjectCollection("entryentity");
            for (DynamicObject item : typeItems) {
                AttachTypeItem typeItem2 = new AttachTypeItem();
                typeItem2.setAttItemId(item.getLong("id"));
                typeItem2.setAttachName(item.getString("attachname"));
                typeItem2.setAttachInfo(item.getString("attachinfo"));
                typeItem2.setMustUpload(item.getBoolean("ismustupload"));
                typeItem2.setAtCondition(item.getString("atsavecondition_tag"));
                typeItem2.setAtOperateNode(item.getString("atoperatenode"));
                typeItem2.setSeq(item.getLong("seq"));
                typeItemMap.put(typeItem2.getAttItemId(), typeItem2);
            }
            cache.setSetting(AttachTypeFactory.createAttachmentTypeSetting(setting));
        }
        HashSet itemIdSet = new HashSet(typeItemMap.keySet());
        IDataModel model = view.getModel();
        DynamicObject attachTypePanel = model.getDataEntity(true);
        DynamicObjectCollection entries = attachTypePanel.getDynamicObjectCollection("entryentity");
        HashMap<Long, AttachTypeItem> typeItemMapDb = new HashMap<Long, AttachTypeItem>(8);
        if (StringUtils.equals((CharSequence)initType, (CharSequence)"common")) {
            if (EmptyUtil.isNoEmpty(entries)) {
                for (Object e : entries) {
                    AttachTypeItem typeItem3;
                    Long attachTypeId = e.getLong("attachtypeid");
                    if (!typeItemMapDb.containsKey(attachTypeId)) {
                        typeItem3 = new AttachTypeItem();
                        typeItem3.setAttItemId(attachTypeId);
                        typeItem3.setAttachName(e.getString("attachtypename"));
                        typeItem3.setAttachInfo(e.getString("attachtypeinfo"));
                        typeItem3.setMustUpload(e.getBoolean("mustupload"));
                        typeItem3.setAtCondition("");
                        typeItem3.setAtOperateNode(e.getString("operatenode"));
                        typeItem3.setSeq(attachTypeId == 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
                    } else {
                        typeItem3 = (AttachTypeItem)typeItemMapDb.get(attachTypeId);
                    }
                    if (!EmptyUtil.isNoEmpty(e.getDynamicObject("attach"))) continue;
                    Object fileId = e.getDynamicObject("attach").getPkValue();
                    typeItem3.addFileId(fileId);
                    typeItemMapDb.put(attachTypeId, typeItem3);
                }
            }
        } else if (StringUtils.equals((CharSequence)initType, (CharSequence)"special")) {
            if (EmptyUtil.isNoEmpty(entries)) {
                typeItem = new AttachTypeItem();
                typeItem.setSeq(Integer.MIN_VALUE);
                typeItem.setAttItemId(0L);
                for (DynamicObject e : entries) {
                    if (!EmptyUtil.isNoEmpty(e.getDynamicObject("attach"))) continue;
                    Iterator fileId = e.getDynamicObject("attach").getPkValue();
                    typeItem.addFileId(fileId);
                }
                if (EmptyUtil.isNoEmpty(typeItem.getFileIdList()) || cache.getSetting() == null) {
                    typeItemMapDb.put(typeItem.getAttItemId(), typeItem);
                }
            }
        } else if (StringUtils.equals((CharSequence)initType, (CharSequence)"panel") && EmptyUtil.isEmpty(entries)) {
            typeItem = new AttachTypeItem();
            typeItem.setAttItemId(0L);
            typeItem.setSeq(Integer.MIN_VALUE);
            typeItemMapDb.put(typeItem.getAttItemId(), typeItem);
        }
        HashSet itemIdSetDb = new HashSet(typeItemMapDb.keySet());
        HashSet allItemIdSet = new HashSet();
        allItemIdSet.addAll(itemIdSet);
        allItemIdSet.addAll(itemIdSetDb);
        if (EmptyUtil.isEmpty(allItemIdSet)) {
            AttachTypeItem typeItem4 = new AttachTypeItem();
            typeItem4.setAttItemId(0L);
            typeItemList.add(typeItem4);
        } else if (allItemIdSet.contains(0L) && !StringUtils.equals((CharSequence)initType, (CharSequence)"common")) {
            AttachTypeItem firstItem = (AttachTypeItem)typeItemMapDb.get(0L);
            typeItemList.add(firstItem);
            for (Long itemId : allItemIdSet) {
                AttachTypeItem attachTypeItem;
                if (itemId == 0L || (attachTypeItem = (AttachTypeItem)typeItemMap.get(itemId)) == null) continue;
                typeItemList.add(attachTypeItem);
            }
        } else {
            for (Long itemId : allItemIdSet) {
                AttachTypeItem attachTypeItem = (AttachTypeItem)typeItemMap.get(itemId);
                AttachTypeItem attachTypeItemDb = (AttachTypeItem)typeItemMapDb.get(itemId);
                if (attachTypeItem != null && attachTypeItemDb != null) {
                    attachTypeItem.setFileIdList(attachTypeItemDb.getFileIdList());
                    typeItemList.add(attachTypeItem);
                    continue;
                }
                if (attachTypeItem != null) {
                    typeItemList.add(attachTypeItem);
                    continue;
                }
                typeItemList.add(attachTypeItemDb);
            }
        }
        cache.setId(attachTypePanel.getPkValue());
        cache.setBillNo(attachTypePanel.getString("billno"));
        typeItemList.sort(Comparator.comparing(AttachTypeItem::getSeq));
        cache.setItemList(typeItemList);
        AttachTypeFactory.putPageCache(view, cache);
        return cache;
    }

    private static AttachTypeSetting createAttachmentTypeSetting(DynamicObject settingDo) {
        AttachTypeSetting setting = new AttachTypeSetting();
        setting.setId(settingDo.getPkValue());
        setting.setNumber(settingDo.getString("number"));
        setting.setName(settingDo.getString("name"));
        setting.setBillEntity(settingDo.getString("billentity"));
        setting.setCondition(settingDo.getString("condition"));
        return setting;
    }

    public static DynamicObject getMatchAttachType(IFormView view) {
        String parentPageId = (String)view.getFormShowParameter().getCustomParam("parentPageId");
        IDataModel model = view.getViewNoPlugin(parentPageId).getModel();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObject setting = AttachTypeHelper.getInstance().getMatchAttachment(bill);
        return EmptyUtil.isNoEmpty(setting) ? BusinessDataServiceHelper.loadSingle((Object)setting.getLong("id"), (String)"fbd_attachmenttype") : null;
    }

    public static AttachTypePanelCache getAttachmentTypePanelCache(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String json = pageCache.get(FBD_AT_CACHE_KEY);
        return EmptyUtil.isBlank((CharSequence)json) ? new AttachTypePanelCache() : (AttachTypePanelCache)SerializationUtils.fromJsonString((String)json, AttachTypePanelCache.class);
    }

    public static void putPageCache(IFormView view, AttachTypePanelCache cache) {
        IPageCache pageCache = view.getPageCache();
        String cacheData = SerializationUtils.toJsonString((Object)cache);
        pageCache.put(FBD_AT_CACHE_KEY, cacheData);
    }
}

