/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.macc.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.macc.plugin.MaccMenuStructure;
import kd.bos.portal.service.IPortalAppMenuExtService;

public class MaccMenuHideExtPlugin
implements IPortalAppMenuExtService {
    public static final String ACA_APPID = "0YH2ZWPSCB+4";
    public static final String SCA_APPID = "0DDNKGUZRMR8";
    public static final String ECA_APPID = "2JQ=8RQ5NE82";

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        Map<String, Set<String>> hideMap = new HashMap<String, Set<String>>(16);
        if (userId == null || appIdAndMenuIdMap == null || appIdAndMenuIdMap.isEmpty()) {
            return hideMap;
        }
        if (appIdAndMenuIdMap.containsKey(ACA_APPID)) {
            hideMap = this.getHideMenu(userId, appIdAndMenuIdMap, "aca", ACA_APPID, hideMap);
        } else if (appIdAndMenuIdMap.containsKey(SCA_APPID)) {
            hideMap = this.getHideMenu(userId, appIdAndMenuIdMap, "sca", SCA_APPID, hideMap);
        } else if (appIdAndMenuIdMap.containsKey(ECA_APPID)) {
            hideMap = this.getHideMenu(userId, appIdAndMenuIdMap, "eca", ECA_APPID, hideMap);
        }
        return hideMap;
    }

    private Map<String, Set<String>> getHideMenu(Long userId, Map<String, Set<String>> appIdAndMenuIdMap, String appId, String APP_ID, Map<String, Set<String>> hideMap) {
        List calMenus = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        ArrayList<MaccMenuStructure> menus = new ArrayList<MaccMenuStructure>(16);
        List<MaccMenuStructure> structureMenus = this.getMenusByRecursion(APP_ID, menus, calMenus);
        HashSet<String> hideIds = new HashSet<String>(16);
        for (MaccMenuStructure structureMenu : structureMenus) {
            Boolean childMenuExist;
            if (structureMenu.getEntityNumber() == null && !(childMenuExist = this.childMenuExist(structureMenu.getChildMenus())).booleanValue()) {
                hideIds.add(structureMenu.getId());
            }
            for (MaccMenuStructure subStructureMenu : structureMenu.getChildMenus()) {
                Boolean childMenuExist2;
                if (subStructureMenu.getEntityNumber() != null || (childMenuExist2 = this.childMenuExist(subStructureMenu.getChildMenus())).booleanValue()) continue;
                hideIds.add(subStructureMenu.getId());
            }
        }
        if (hideIds.isEmpty()) {
            return super.getHideMenuIdsByBizAppIds(userId, appIdAndMenuIdMap);
        }
        hideMap.put(APP_ID, hideIds);
        return hideMap;
    }

    private List<MaccMenuStructure> getMenusByRecursion(String appId, List<MaccMenuStructure> menus, List<AppMenuInfo> appMenuInfos) {
        for (AppMenuInfo appMenuInfo : appMenuInfos) {
            if (!appMenuInfo.getParentId().equals(appId)) continue;
            MaccMenuStructure maccMenuStructure = new MaccMenuStructure();
            maccMenuStructure.setId(appMenuInfo.getId());
            maccMenuStructure.setParentId(appId);
            maccMenuStructure.setEntityNumber(appMenuInfo.getEntityNumber());
            maccMenuStructure.setName(appMenuInfo.getName());
            menus.add(maccMenuStructure);
            this.getMenusByRecursion(maccMenuStructure.getId(), maccMenuStructure.getChildMenus(), appMenuInfos);
        }
        return menus;
    }

    private Boolean childMenuExist(List<MaccMenuStructure> childMenus) {
        boolean flag = false;
        if (childMenus != null && !childMenus.isEmpty()) {
            for (MaccMenuStructure childMenu : childMenus) {
                if (childMenu.getEntityNumber() != null) {
                    flag = true;
                    continue;
                }
                if (childMenu.getChildMenus() == null || childMenu.getChildMenus().isEmpty()) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

