/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bsc.bea.operate;

import java.util.Arrays;
import kd.bos.bill.IBillView;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class BcverifyOperate
extends FormOperate {
    public static final String KEY_BILLNO = "billno";
    public static final String KEY_BIZ_BILLNO = "bizbillno";
    public static final String IDENTIFY_BEA_STC_LOG = "bea_stc_log";
    private QFilter filter;

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String billno = billModel.getValue(KEY_BILLNO) == null ? "" : billModel.getValue(KEY_BILLNO).toString();
            this.filter = new QFilter(KEY_BIZ_BILLNO, "=", (Object)billno);
            return true;
        }
        if (this.getView() instanceof IListView) {
            // empty if block
        }
        return false;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        this.openLog(this.filter);
    }

    private void openLog(QFilter filter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(IDENTIFY_BEA_STC_LOG);
        if (null != filter) {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setQFilters(Arrays.asList(filter.toArray()));
            listShowParameter.setListFilterParameter(filterParameter);
        }
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1230");
        styleCss.setHeight("690");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

