/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.upgrade;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.ssc.upgrade.UpgradeOrgInfo;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public abstract class AbstractUpgradeOrgServiceImpl
implements IUpgradeService {
    private List<UpgradeOrgInfo> upgradeOrgInfoList;
    private static final String UPDATE_SQL = "update %1s set %2s where %3s in (%4s)";
    private static final String PKNAME_DEFAULT = "fid";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        if (this.upgradeOrgInfoList == null || this.upgradeOrgInfoList.isEmpty()) {
            upgradeResult.setSuccess(true);
            upgradeResult.setLog("update org service is success,no table need update.");
            return upgradeResult;
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        for (UpgradeOrgInfo tableInfo : this.upgradeOrgInfoList) {
            String dbRoute = tableInfo.getDbRoute();
            String tableName = tableInfo.getTable();
            Set<String> orgFields = tableInfo.getOrgFields();
            String fieldValueSql = this.buildFieldValueSql(orgFields, rootOrgId);
            Set<Long> dataIds = tableInfo.getDataIds();
            String sql = String.format(UPDATE_SQL, tableName, fieldValueSql, this.getPKName(tableInfo), StringUtils.join((Object[])dataIds.toArray(), (char)','));
            DB.execute((DBRoute)DBRoute.of((String)dbRoute), (String)sql);
        }
        upgradeResult.setSuccess(true);
        upgradeResult.setLog("update org field value to rootOrg of preset data is success.");
        return upgradeResult;
    }

    public List<UpgradeOrgInfo> getUpgradeOrgInfoList() {
        return this.upgradeOrgInfoList;
    }

    public void setUpgradeOrgInfoList(List<UpgradeOrgInfo> upgradeOrgInfoList) {
        this.upgradeOrgInfoList = upgradeOrgInfoList;
    }

    private String buildFieldValueSql(Set<String> fields, long value) {
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            sb.append(field);
            sb.append("=").append(value).append(',');
        }
        String sql = sb.toString();
        return sql.substring(0, sql.length() - 1);
    }

    protected String getPKName(UpgradeOrgInfo tableInfo) {
        return PKNAME_DEFAULT;
    }
}

