/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workflow.listener;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.ssc.helper.TaskApproveSuccessHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;

public class WFTerminateDeleteTaskListener
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(WFTerminateDeleteTaskListener.class);
    private static final String TASK_TASK = "task_task";
    private static final String SSC_APPROVE = "SSCApprove";
    private static final QFilter TASK_NOTFINISH_FILTER = new QFilter("pooltype", "!=", (Object)"2");

    public void notify(AgentExecution execution) {
        log.info("--WFTerminateDeleteTaskListener--start");
        Long processInstanceId = execution.getProcessInstanceId();
        log.info(String.format("--WFTerminateDeleteTaskListener--\u6d41\u7a0b\u5b9e\u4f8b%s\u7ec8\u6b62\u8fdb\u5165\u5171\u4eab\u5220\u9664\u4efb\u52a1\u63d2\u4ef6", processInstanceId));
        if (processInstanceId.equals(0L)) {
            return;
        }
        Long processDefinitionId = execution.getProcessDefinitionId();
        if (this.containSSCApproveNode(processDefinitionId)) {
            String billEntityNumber = execution.getEntityNumber();
            String billId = execution.getBusinessKey();
            if (StringUtils.isEmpty((String)billEntityNumber) || StringUtils.isEmpty((String)billId)) {
                return;
            }
            String logPreMsg = "--WFTerminateDeleteTaskListener--" + billEntityNumber + "\u7684\u5355\u636e\uff1a" + billId;
            log.info(logPreMsg + "\u5728\u5171\u4eab\u8282\u70b9\u7ec8\u6b62\uff0c\u5f00\u59cb\u5220\u9664\u672a\u5b8c\u6210\u5171\u4eab\u4efb\u52a1\u6d41\u7a0b");
            QFilter billIdFilter = new QFilter("billid", "=", (Object)billId);
            QFilter approveTaskFilter = new QFilter("tasktypeid.qualityjudge", "!=", (Object)"1");
            DynamicObject[] notFinishTasks = BusinessDataServiceHelper.load((String)TASK_TASK, (String)"id,billtype,sscid,tasktypeid", (QFilter[])new QFilter[]{billIdFilter, TASK_NOTFINISH_FILTER, approveTaskFilter});
            if (notFinishTasks.length < 1) {
                log.info(logPreMsg + "\u4e0d\u5b58\u5728\u672a\u5b8c\u6210\u4e14\u5c5e\u6027\u4e0d\u4e3a\u8d28\u68c0\u4efb\u52a1\u7684\u5171\u4eab\u4efb\u52a1\uff0c\u5df2\u8fd4\u56de\u3002");
                return;
            }
            ArrayList<Long> needDeleteTaskIds = new ArrayList<Long>();
            HashMap<Long, List<Long>> taskIdMap = new HashMap<Long, List<Long>>(8);
            for (DynamicObject task : notFinishTasks) {
                Long billType;
                DynamicObject taskTypeDo;
                String taskProperty;
                long sscId = task.getLong("sscid.id");
                String sscType = this.getSSCType(sscId);
                if ("3".equals(sscType) && "4".equals(taskProperty = (taskTypeDo = task.getDynamicObject("tasktypeid")).getString("qualityjudge"))) {
                    log.error(logPreMsg + "\u4eba\u529b\u5171\u4eab\u4e2d\u5fc3\u7684\u529e\u7406\u7c7b\u4efb\u52a1\u4e0d\u8be5\u89e6\u53d1\u8be5\u4e8b\u4ef6");
                    continue;
                }
                if (!WFTerminateDeleteTaskListener.checkSystemParam(sscId) || !this.checkBillTypeBindEntity(billType = Long.valueOf(task.getLong("billtype.id")), billEntityNumber)) continue;
                Long taskId = task.getLong("id");
                needDeleteTaskIds.add(taskId);
                TaskApproveSuccessHelper.updateTaskIdMap(taskIdMap, sscId, taskId);
            }
            if (needDeleteTaskIds.size() < 1) {
                log.info(logPreMsg + "\u4e0d\u5b58\u5728\u672a\u5b8c\u6210\u4e14\u5c5e\u6027\u4e0d\u4e3a\u8d28\u68c0\u4efb\u52a1\u7684\u5171\u4eab\u4efb\u52a1\uff0c\u5df2\u8fd4\u56de\u3002");
                return;
            }
            this.deleteTaskBySscBatch(taskIdMap);
        }
        log.info("--WFTerminateDeleteTaskListener--end");
    }

    private void deleteTaskBySscBatch(Map<Long, List<Long>> taskIdMap) {
        Iterator<Map.Entry<Long, List<Long>>> iterator;
        if (taskIdMap.size() != 0 && (iterator = taskIdMap.entrySet().iterator()).hasNext()) {
            Map.Entry<Long, List<Long>> entry = iterator.next();
            Long sscId = entry.getKey();
            List<Long> needDeleteTaskIds = entry.getValue();
            if (CollectionUtils.isNotEmpty(needDeleteTaskIds)) {
                try {
                    Long[] successDeleteTaskIds = (Long[])DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"deleteTaskAfterProcessAbandon", (Object[])new Object[]{sscId, needDeleteTaskIds});
                    log.info("deleteTaskAfterProcessAbandon end, sscId = {}, successDeleteTaskIds = {}", (Object)sscId, (Object)JSONObject.toJSONString((Object)successDeleteTaskIds));
                }
                catch (Throwable th) {
                    log.error("deleteTaskAfterProcessAbandon error, sscId = {}, needDeleteTaskIds = {}", new Object[]{sscId, JSONObject.toJSONString(needDeleteTaskIds), th});
                }
            } else {
                log.error("deleteTaskAfterProcessAbandon empty, sscId = {}", (Object)sscId);
            }
        }
    }

    private boolean containSSCApproveNode(Long processDefinitionId) {
        List elements = WorkflowServiceHelper.getProcElementsByProcDefId((Long)processDefinitionId);
        if (elements == null) {
            return false;
        }
        for (WFFlowElement element : elements) {
            if (!SSC_APPROVE.equals(element.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean checkBillTypeBindEntity(Long billType, String entityNumber) {
        DynamicObject taskBill = BusinessDataServiceHelper.loadSingle((Object)billType, (String)"task_taskbill", (String)"bindbill.number");
        if (taskBill == null) {
            return false;
        }
        return entityNumber.equals(taskBill.getString("bindbill.number"));
    }

    private static boolean checkSystemParam(long orgId) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"autodeletetask");
        boolean result = false;
        if (null != params) {
            result = (Boolean)params;
        }
        return result;
    }

    private String getSSCType(long sscOrgId) {
        QFilter idFilter = new QFilter("sscorg", "=", (Object)sscOrgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"ssc_dutymanage", (String)"sscbusinesstype", (QFilter[])idFilter.toArray());
        return dyn == null ? "1" : dyn.getString("sscbusinesstype");
    }
}

