/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.drp.func.pos;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.GetSysParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetStoreSysParam
implements BOSUDFunction {
    private static final Log LOG = LogFactory.getLog(GetSysParam.class);
    private static final String KEY_FORM_PARAM = "ocpos_store_sysparam";
    private static final String KEY_ORG = "org";
    private static final String KEY_BRANCH = "branch";

    public GetStoreSysParam() {
    }

    public GetStoreSysParam(ExpressionContext context) {
    }

    public BOSUDFunction getInstance(ExpressionContext context) {
        return new GetStoreSysParam(context);
    }

    public String getName() {
        return "GetStoreSysParam";
    }

    public Object call(Object ... args) {
        if (args == null) {
            LOG.info("Unknown parameter type: args is null");
            return null;
        }
        if (args.length < 3) {
            LOG.info("Unknown parameter type: args.length = " + args.length);
            return null;
        }
        long orgId = this.convertObjectToLong(args[0]);
        String key = this.convertObjectToString(args[2]);
        if (orgId == 0L || StringUtils.isBlank((CharSequence)key)) {
            LOG.info("Unknown parameter type: param is blank");
            return null;
        }
        QFilter filter = new QFilter(KEY_ORG, "=", (Object)orgId);
        String selectFields = String.join((CharSequence)",", KEY_BRANCH, key);
        DynamicObjectCollection data = QueryServiceHelper.query((String)KEY_FORM_PARAM, (String)selectFields, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)data)) {
            long branchId = this.convertObjectToLong(args[1]);
            Object value = data.stream().filter(p -> p.getLong(KEY_BRANCH) == branchId).map(q -> this.getValue((DynamicObject)q, key)).findFirst().orElse(null);
            if (value == null && branchId > 0L) {
                value = data.stream().filter(p -> p.getLong(KEY_BRANCH) == 0L).map(q -> this.getValue((DynamicObject)q, key)).findFirst().orElse(null);
            }
            return value;
        }
        LOG.info("\u672a\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u3002");
        return null;
    }

    private long convertObjectToLong(Object args) {
        try {
            return Long.parseLong(this.convertObjectToString(args));
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private String convertObjectToString(Object args) {
        return args == null ? "" : args.toString();
    }

    private Object getValue(DynamicObject datum, String key) {
        Object value = datum.get(key);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue();
        }
        return value;
    }
}

