/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.dap.cache;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;

public class LocalCacheKey {
    private String cloudId;
    private String appId;
    private CacheModule module;
    private String value;

    public LocalCacheKey(String cloudId, String appId, CacheModule module) {
        this.cloudId = cloudId;
        this.appId = appId;
        this.module = module;
    }

    public String buildCacheKey() {
        StringBuilder cacheKeyBuilder = new StringBuilder();
        cacheKeyBuilder.append(this.cloudId).append("-").append(this.appId).append("-").append((Object)this.module);
        return cacheKeyBuilder.toString();
    }

    private LocalCacheKey(String value) {
        this.value = value;
    }

    public static LocalCacheKey getCacheKey(CacheKeyPrefix prefix, Object ... args) {
        if (prefix == null) {
            throw new KDException((Throwable)new Exception("The cache key prefix cannot be empty!"), BosErrorCode.systemError, new Object[0]);
        }
        if (args != null) {
            StringBuilder sb = new StringBuilder(prefix.name());
            for (Object arg : args) {
                sb.append("|").append(arg);
            }
            return new LocalCacheKey(sb.toString());
        }
        return new LocalCacheKey(prefix.name());
    }

    public String toString() {
        return this.value;
    }
}

