/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.constant.CreateXlaMode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BuildVoucher
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final int max_batch = 100000;
    private Set<Long> curr_task_billids = new HashSet<Long>();
    private static String entityName;
    private static boolean showVoucherView;
    private static Log logger;

    protected int getBatchSize() {
        return 100000;
    }

    protected void showSuccessMessage() {
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        String mode = BuildXLAAndGLUtils.createXlaMode();
        if (CreateXlaMode.DAP_NEW_CUS.getCode().equals(mode) || CreateXlaMode.DAP_REG_NEW.getCode().equals(mode) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getEntityId(), this.getSelectedBillIds())) {
            return this.buildXlaAndGLForm(result);
        }
        if (CreateXlaMode.DAP_REG_OPTION.getCode().equals(mode) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getEntityId(), this.getSelectedBillIds())) {
            String createMode = this.getOption().getVariableValue("create_mode", null);
            if (null == createMode) {
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId("fah_create_mode");
                parameters.setCustomParam("pageId", (Object)this.getView().getPageId());
                parameters.setCustomParam("operateKey", (Object)this.getOperateKey());
                parameters.setCustomParam("entityId", (Object)this.getEntityId());
                parameters.setCustomParam("operatorName", (Object)this.getOperateName().getLocaleValue());
                parameters.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_create_mode"));
                this.getView().showForm(parameters);
                return false;
            }
            if ("2".equals(createMode)) {
                return this.buildXlaAndGLForm(result);
            }
        }
        return this.generateDapVoucher(result);
    }

    private boolean generateDapVoucher(OperationResult result) {
        String tempId = this.getOption().getVariableValue("tempId", null);
        if (tempId == null) {
            DynamicObject dapConfig;
            String license = this.checkLicense();
            if (license != null) {
                this.getView().showTipNotification(license);
                return false;
            }
            if (!this.checkOneBill()) {
                return false;
            }
            entityName = this.getView().getFormShowParameter().getCaption();
            if ("ai_event".equals(this.getEntityId())) {
                Set<Long> selectedBillIds = this.getSelectedBillIds();
                Map<String, List<Long>> billTypeGroup = ExtDataQueryHelper.groupByBillType(selectedBillIds);
                if (billTypeGroup.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u4e0d\u540c\u6a21\u578b\u4e0b\u7684\u5916\u90e8\u6570\u636e\u751f\u6210\u51ed\u8bc1\u3002", (String)"BuildVoucher_12", (String)"bos-ext-fi", (Object[])new Object[0]));
                    return false;
                }
                String billType = billTypeGroup.keySet().iterator().next();
                if ("ai_event".equals(billType)) {
                    Long eventClass = this.getEventClass();
                    dapConfig = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"isselecttemp,notshowvoucher", (QFilter[])new QFilter[]{new QFilter("billentity", "=", (Object)"ai_eventclass"), new QFilter("isdap", "=", (Object)Character.valueOf('1')), new QFilter("eventclass", "=", (Object)eventClass)});
                } else {
                    dapConfig = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"isselecttemp,notshowvoucher", (QFilter[])new QFilter[]{new QFilter("billentity", "=", (Object)billType), new QFilter("isdap", "=", (Object)Character.valueOf('1'))});
                }
            } else {
                dapConfig = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"isselecttemp,notshowvoucher", (QFilter[])new QFilter[]{new QFilter("billentity", "=", (Object)this.getEntityId()), new QFilter("isdap", "=", (Object)Character.valueOf('1'))});
            }
            if (dapConfig == null) {
                if (!"ai_event".equals(this.getEntityId())) {
                    this.getView().showTipNotification(this.getEntityName() + ":" + ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7c7b\u578b\u7684\u3010\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3011\u6309\u94ae\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u51ed\u8bc1\u6a21\u677f\u5217\u8868\u8bbe\u7f6e\u3002", (String)"BuildVoucher_10", (String)"bos-ext-fi", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5916\u90e8\u6570\u636e\u7c7b\u578b\u7684\u3010\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3011\u6309\u94ae\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u51ed\u8bc1\u6a21\u677f\u5217\u8868\u8bbe\u7f6e\u3002", (String)"BuildVoucher_11", (String)"bos-ext-fi", (Object[])new Object[0]));
                }
                return false;
            }
            boolean isselecttem = dapConfig.getBoolean("isselecttemp");
            boolean bl = showVoucherView = !dapConfig.getBoolean("notshowvoucher");
            if (isselecttem) {
                Object tempIds;
                try {
                    tempIds = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"SelectTemplteService", (String)"getNewSelectVchtemplate", (Object[])new Object[]{this.getEntityId(), this.curr_task_billids, true});
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                    return false;
                }
                Map temp = (Map)tempIds;
                if (temp.get("useTemp") != null) {
                    FormShowParameter formShow = new FormShowParameter();
                    formShow.setFormId("ai_selecttemplate");
                    formShow.setCustomParam("tempId", (Object)SerializationUtils.toJsonString((Object)temp));
                    formShow.setCustomParam("sourceId", (Object)SerializationUtils.toJsonString(this.curr_task_billids));
                    formShow.setCustomParam("entityname", (Object)this.getEntityId());
                    formShow.setCustomParam("pageId", (Object)this.getView().getPageId());
                    formShow.setCustomParam("operationKey", (Object)this.getOperateKey());
                    formShow.setCustomParam("create_mode", (Object)this.getOption().getVariableValue("create_mode", null));
                    formShow.getOpenStyle().setShowType(ShowType.Modal);
                    formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selecttmp"));
                    this.getView().showForm(formShow);
                    return false;
                }
            }
        }
        this.curr_task_billids = this.getSelectedBillIds();
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        this.getView().getPageCache().put("cacheName", this.getEntityId());
        OperateOption option = this.getOption();
        option = option == null ? OperateOption.create() : option;
        Map optionMap = option.getVariables();
        logger.info("--DAP--BuildVoucher:" + optionMap);
        return this.invokeGenerateTipTask(optionMap);
    }

    private boolean buildXlaAndGLForm(OperationResult result) {
        if (!LicenseServiceHelper.getLicenseModules().contains("2FMS=8GUFGGN")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u4e2d\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BuildVoucher_21", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        String returnDataMapStr = this.getOption().getVariableValue("SubmitPopWinValue", null);
        if (null != returnDataMapStr || BuildXLAAndGLUtils.createXlaWay()) {
            OperateOption option = this.getOption();
            option = option == null ? OperateOption.create() : option;
            Map optionMap = option.getVariables();
            logger.info("--XLA--EventAndXla:{}", (Object)optionMap);
            return this.invokeBuildXlaAndGlTipTask(optionMap);
        }
        Set<Long> selectedBillIds = this.getSelectedBillIds();
        String realEntity = this.getEntityId();
        if ("ai_event".equals(this.getEntityId())) {
            if (selectedBillIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\uff0c\u5916\u90e8\u6570\u636e\u4ec5\u652f\u6301\u5217\u8868\u9009\u62e9\u5355\u636e\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u3002", (String)"BuildVoucher_13", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(selectedBillIds);
            if (billTypeGroups.containsKey("ai_event")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e7\u6a21\u578b\u5916\u90e8\u6570\u636e\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u3002", (String)"BuildVoucher_14", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            if (billTypeGroups.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u6a21\u578b\u5916\u90e8\u6570\u636e\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u3002", (String)"BuildVoucher_15", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            LinkedList<String> notRegExtData = new LinkedList<String>();
            Iterator<String> iterator = billTypeGroups.keySet().iterator();
            while (iterator.hasNext()) {
                String billType;
                realEntity = billType = iterator.next();
                boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(billType);
                if (hasReg) continue;
                notRegExtData.add(billType);
            }
            if (!notRegExtData.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u5916\u90e8\u6570\u636e\u672a\u8fdb\u884c\u6ce8\u518c\u3002", (String)"BuildVoucher_16", (String)"bos-ext-fi", (Object[])new Object[0]), String.join((CharSequence)",", notRegExtData)));
                return false;
            }
        } else {
            boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(realEntity);
            if (!hasReg) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)realEntity);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%1$s[%2$s]\u672a\u8fdb\u884c\u6ce8\u518c\u3002", (String)"BuildVoucher_17", (String)"bos-ext-fi", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), realEntity));
                return false;
            }
        }
        this.showParamPage(realEntity, selectedBillIds);
        return false;
    }

    private boolean invokeBuildXlaAndGlTipTask(Map<String, String> optionMap) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fah_build_xla_gl_tip");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getCustomParams().put("ids", FahSerializeHelper.getInstance().toJSONString(this.getSelectedBillIds()));
        param.getCustomParams().put("option", FahSerializeHelper.getInstance().toJSONString(optionMap));
        param.getCustomParams().put("entityId", this.getEntityId());
        param.getCustomParams().put("pageId", this.getView().getPageId());
        param.getCustomParams().put("operateKey", this.getOperateKey());
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_build_xla_gl_tip"));
        this.getView().showForm(param);
        return false;
    }

    private void showParamPage(String realEntity, Set<Long> selectedBillIds) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("fah_evt_create_param");
        parameters.setCustomParam("pageId", (Object)this.getView().getPageId());
        parameters.setCustomParam("operateKey", (Object)this.getOperateKey());
        parameters.setCustomParam("operatorName", (Object)this.getOperateName().getLocaleValue());
        parameters.setCustomParam("entityId", (Object)realEntity);
        parameters.setCustomParam("isSelectNoData", (Object)"false");
        parameters.setCustomParam("hide_bill_range", (Object)"true");
        parameters.setCustomParam("hide_tips", (Object)(selectedBillIds.size() > 1000 ? "false" : "true"));
        parameters.setCustomParam("create_mode", (Object)this.getOption().getVariableValue("create_mode", null));
        parameters.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_evt_create_param"));
        this.getView().showForm(parameters);
    }

    private boolean invokeGenerateTipTask(Map<String, String> optionMap) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ai_genvchtip");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getCustomParams().put("ids", SerializationUtils.toJsonString(this.curr_task_billids));
        param.getCustomParams().put("option", SerializationUtils.toJsonString(optionMap));
        param.getCustomParams().put("entityid", this.getEntityId());
        param.getCustomParams().put("pageid", this.getView().getPageId());
        param.getCustomParams().put("operateKey", this.getOperateKey());
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_genvchtip"));
        this.getView().showForm(param);
        return false;
    }

    private Long getEventClass() {
        IBillView billView;
        IBillModel billModel;
        Object ec;
        Long result = 0L;
        if (this.getView() instanceof IListView) {
            DynamicObject e;
            Object object;
            DynamicObject ec2 = BusinessDataServiceHelper.loadSingleFromCache((Object)this.curr_task_billids.toArray()[0], (String)"ai_event");
            if (ec2 != null && (object = (e = ec2).get("eventclass")) != null) {
                DynamicObject ee = (DynamicObject)object;
                result = Long.parseLong(ee.getPkValue().toString());
            }
        } else if (this.getView() instanceof IBillView && (ec = (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getValue("eventclass")) != null) {
            DynamicObject e = (DynamicObject)ec;
            result = Long.parseLong(e.getPkValue().toString());
        }
        return result;
    }

    private boolean checkOneBill() {
        boolean exists;
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"BuildVoucher_0", (String)"bos-ext-fi", (Object[])new Object[0]) + this.getEntityName());
                return false;
            }
        }
        this.curr_task_billids = this.getSelectedBillIds();
        if (this.curr_task_billids.isEmpty()) {
            return false;
        }
        if (this.curr_task_billids.size() == 1 && !"ai_event".equals(this.getEntityId()) && !(exists = QueryServiceHelper.exists((String)this.getEntityId(), (Object)this.curr_task_billids.toArray()[0]))) {
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86", (String)"BuildVoucher_7", (String)"bos-ext-fi", (Object[])new Object[0])});
        }
        return true;
    }

    private String getEntityName() {
        return entityName == null ? "" : entityName;
    }

    private String checkLicense() {
        LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"83bfebc8000017ac", (String)"gl_voucher", (Long)Long.valueOf(RequestContext.get().getUserId()));
        String msg = null;
        if (!result.getHasLicense().booleanValue()) {
            String version;
            switch (version = LicenseServiceHelper.getProductVersion()) {
                case "1.0": 
                case "2.0": 
                case "3.0": {
                    msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8d22\u52a1\u4f1a\u8ba1\u4e13\u4e1a\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BuildVoucher_22", (String)"bos-ext-fi", (Object[])new Object[0]);
                    break;
                }
            }
        }
        return msg;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected void afterOperationClose(OperationResult result) {
    }

    protected Set<Long> getSelectedBillIds() {
        IBillModel billModel;
        Object pkValue;
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            HashSet<Long> billIds = new HashSet<Long>(listView.getSelectedRows().size());
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Object pkValue2 = row.getPrimaryKeyValue();
                if (!(pkValue2 instanceof Long)) continue;
                billIds.add((Long)pkValue2);
            }
            return billIds;
        }
        if (this.getView() instanceof IBillView && (pkValue = (billModel = (IBillModel)this.getView().getModel()).getPKValue()) instanceof Long) {
            return Collections.singleton((Long)pkValue);
        }
        return Collections.emptySet();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        switch (key = evt.getActionId()) {
            case "selecttmp": {
                String returnData = evt.getReturnData() + "";
                Map map = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
                if (map == null) break;
                String pageId = (String)map.get("pageId");
                OperateOption create = OperateOption.create();
                create.setVariableValue("create_mode", (String)map.get("create_mode"));
                create.setVariableValue("tempId", (String)map.get("souandtemp"));
                String genKey = (String)map.get("operationKey");
                genKey = genKey == null ? BuildVoucher.getGenVoucherKey((String)map.get("entityname")) : genKey;
                IFormView view = SessionManager.getCurrent().getView(pageId);
                view.invokeOperation(genKey, create);
                break;
            }
            case "ai_genvchtip": {
                Map map;
                String data = (String)evt.getReturnData();
                if (data == null || (map = (Map)SerializationUtils.fromJsonString((String)data, Map.class)) == null) break;
                String error = (String)map.get("error");
                String or = (String)map.get("OperationResult");
                String billIdStr = (String)map.get("billids");
                IFormView view = SessionManager.getCurrent().getView((String)map.get("pageid"));
                if (or != null) {
                    OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)or, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                    Set sourceId = new HashSet(8);
                    if (billIdStr != null) {
                        sourceId = (Set)SerializationUtils.fromJsonString((String)billIdStr, Set.class);
                    }
                    if (opResult.isSuccess()) {
                        view.showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"BuildVoucher_2", (String)"bos-ext-fi", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"BuildVoucher_6", (String)"bos-ext-fi", (Object[])new Object[0]), Integer.valueOf(15000));
                        this.refreshData(view);
                        if (!showVoucherView) break;
                        this.showVoucherView(opResult, sourceId, view);
                        break;
                    }
                    view.showOperationResult(opResult, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"BuildVoucher_2", (String)"bos-ext-fi", (Object[])new Object[0]));
                    this.refreshData(view);
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)error)) {
                    view.showErrorNotification(error);
                    break;
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"BuildVoucher_2", (String)"bos-ext-fi", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"BuildVoucher_6", (String)"bos-ext-fi", (Object[])new Object[0]));
                this.refreshData(view);
                break;
            }
            case "fah_create_mode": {
                String returnData = (String)evt.getReturnData();
                Map map = FahSerializeHelper.fromJsonString(returnData, Map.class);
                if (map == null) break;
                String pageId = (String)map.get("pageId");
                OperateOption create = OperateOption.create();
                create.setVariableValue("create_mode", (String)map.get("create_mode"));
                String genKey = (String)map.get("operateKey");
                genKey = genKey == null ? BuildVoucher.getGenVoucherKey((String)map.get("operatorName")) : genKey;
                IFormView view = SessionManager.getCurrent().getView(pageId);
                view.invokeOperation(genKey, create);
                break;
            }
            case "fah_evt_create_param": {
                Object retData = evt.getReturnData();
                logger.info("buildEventData_BuildEventAndXLA,ActionId:{}, returnData: {}", (Object)evt.getActionId(), retData);
                if (!(retData instanceof Map)) {
                    return;
                }
                Map returnDataMap = (Map)retData;
                String pageId = (String)returnDataMap.get("pageId");
                OperateOption create = OperateOption.create();
                create.setVariableValue("SubmitPopWinValue", FahSerializeHelper.toJsonString(returnDataMap));
                create.setVariableValue("create_mode", (String)returnDataMap.get("create_mode"));
                String createKey = (String)returnDataMap.get("operateKey");
                createKey = createKey == null ? BuildVoucher.getGenVoucherKey((String)returnDataMap.get("entityId")) : createKey;
                IFormView view = SessionManager.getCurrent().getView(pageId);
                view.getPageCache().put("isPreview" + pageId, (String)returnDataMap.get("isPreview"));
                view.invokeOperation(createKey, create);
                break;
            }
            case "fah_build_xla_gl_tip": {
                Map map;
                String data = (String)evt.getReturnData();
                if (data == null || (map = FahSerializeHelper.fromJsonString(data, Map.class)) == null) break;
                String error = (String)map.get("error");
                String or = (String)map.get("operationResult");
                IFormView currentView = SessionManager.getCurrent().getView((String)map.get("pageId"));
                String isPreview = currentView.getPageCache().get("isPreview" + (String)map.get("pageId"));
                String msg = "true".equalsIgnoreCase(isPreview) ? ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u6210\u529f\u3002", (String)"BuildVoucher_20", (String)"bos-ext-fi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u6210\u529f\u3002", (String)"BuildVoucher_18", (String)"bos-ext-fi", (Object[])new Object[0]);
                if (or != null) {
                    OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)or, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                    if (opResult.isSuccess()) {
                        currentView.showSuccessNotification(msg, Integer.valueOf(15000));
                    } else {
                        currentView.showOperationResult(opResult, ResManager.loadKDString((String)"\u521b\u5efa\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26", (String)"BuildVoucher_19", (String)"bos-ext-fi", (Object[])new Object[0]));
                    }
                    this.refreshData(currentView);
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)error)) {
                    currentView.showTipNotification(error);
                    break;
                }
                currentView.showSuccessNotification(msg);
                this.refreshData(currentView);
                break;
            }
        }
    }

    private void showVoucherView(OperationResult opResult, Set<? extends Object> sourceId, IFormView view) {
        if (sourceId != null) {
            Map<String, List<Long>> billTypeGroup;
            String sql = "select fvalue from t_ai_sysparam where fkey = 'vchshowvoucherlistmaxsize';";
            int max_size = 1000;
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operate.BuildVoucher", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
                Iterator iterator = queryDataSet.iterator();
                while (iterator.hasNext()) {
                    max_size = ((Row)iterator.next()).getInteger("fvalue");
                }
            }
            if (sourceId.size() > max_size) {
                return;
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("sourcebillid", "in", sourceId));
            String entityid = view.getPageCache().get("cacheName");
            if ("ai_event".equals(entityid) && (billTypeGroup = ExtDataQueryHelper.groupByBillType(sourceId.stream().map(e -> (Long)e).collect(Collectors.toList()))).size() > 0) {
                entityid = billTypeGroup.keySet().iterator().next();
            }
            DapVoucherUtil.addBillTypeFilter(entityid, filterList);
            DynamicObject[] daptrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid,booktype", (QFilter[])filterList.toArray(new QFilter[0]));
            if (daptrackers == null || daptrackers.length == 0) {
                return;
            }
            HashSet<Object> pks = new HashSet<Object>(daptrackers.length);
            for (DynamicObject tracker : daptrackers) {
                pks.add(tracker.get("voucherid"));
            }
            Long voucherID = daptrackers[0].getLong("voucherid");
            String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{voucherID});
            if (pks.size() > 1000) {
                return;
            }
            if (pks.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                long count = (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select count(1) as c from t_" + entity + "entry where fid = ? "), (Object[])new Object[]{voucherID}, e -> {
                    if (e.next()) {
                        return e.getLong("c");
                    }
                    return 0L;
                });
                if (count > 10000L) {
                    return;
                }
                showParameter.setPkId((Object)voucherID);
                showParameter.setFormId(entity);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long userId = Long.parseLong(RequestContext.get().getUserId());
                long orgId = 0L;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"buildVoucher_queryvoucher", (String)entity, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherID)}, null);){
                    for (Row row : ds) {
                        orgId = row.getLong("org");
                    }
                }
                int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)entity, (String)"4715a0df000000ac");
                Boolean isbizvoucher = DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam(orgId);
                if (!(i != 1 || isbizvoucher.booleanValue() && "gl_voucher".equals(entity))) {
                    showParameter.setStatus(OperationStatus.EDIT);
                } else {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                showParameter.setHasRight(true);
                view.showForm((FormShowParameter)showParameter);
                opResult.setShowMessage(false);
            } else {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId(entity);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                for (Object e2 : pks) {
                    showParameter.addLinkQueryPkId(e2);
                }
                showParameter.getCustomParams().put("org", "");
                showParameter.getCustomParams().put("booktype", "");
                view.showForm((FormShowParameter)showParameter);
                opResult.setShowMessage(false);
            }
        }
    }

    private static String getGenVoucherKey(String entityname) {
        List opts = EntityMetadataCache.getDataEntityOperate((String)entityname);
        String genVoucherOptName = "generatevoucher";
        for (Map opt : opts) {
            String optKey = (String)opt.get("type");
            if (!optKey.equalsIgnoreCase("generatevoucher")) continue;
            genVoucherOptName = (String)opt.get("key");
        }
        return genVoucherOptName;
    }

    private void refreshData(IFormView view) {
        if (view instanceof IListView) {
            ((IListView)view).refreshWithSelected();
        } else {
            view.invokeOperation("refresh");
        }
    }

    static {
        showVoucherView = true;
        logger = LogFactory.getLog(BuildVoucher.class);
    }
}

