/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.BookdateRecondsParam;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.ext.fi.entity.property.BookdateProp;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BackTransBookdateService
extends EntityOperateService {
    private static Log logger = LogFactory.getLog(BackTransBookdateService.class);
    private String billType;
    private String bookdate;

    protected void preparePropertys(List<String> fieldKeys) {
        this.billType = this.billEntityType.getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.billType);
        DataEntityPropertyCollection propertys = mainEntityType.getProperties();
        for (IDataEntityProperty property : propertys) {
            if (!(property instanceof BookdateProp)) continue;
            this.bookdate = property.getName();
            fieldKeys.add(this.bookdate);
        }
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        validators.add(new AbstractValidator(){

            public void validate() {
                HashSet listinTx;
                ExtendedDataEntity[] entities = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(entities);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                ArrayList<String> ids = new ArrayList<String>(pkIds.size());
                HashSet<Long> inRecondsList = new HashSet<Long>(DapVoucherUtil.getBookdateSourceIds(pkIds, BackTransBookdateService.this.billType));
                for (ExtendedDataEntity entity : entities) {
                    Long tempId = (Long)entity.getBillPkId();
                    if (StringUtils.isBlank((CharSequence)BackTransBookdateService.this.bookdate)) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u8bb0\u8d26\u65e5\u671f\u7c7b\u578b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u6267\u884c\u53d6\u6d88\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"BackTransBookdateService_1", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    if (!inRecondsList.contains(tempId)) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u672a\u6267\u884c\u8fdb\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"BackTransBookdateService_2", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    ids.add(tempId.toString());
                }
                if (!pkIds.isEmpty() && (listinTx = new HashSet(TxCheckUtil.loadUnfinishedTx((String)"transbookdate", ids))) != null && listinTx.size() > 0) {
                    for (ExtendedDataEntity entity : this.dataEntities) {
                        DynamicObject v = entity.getDataEntity();
                        if (!listinTx.contains(v.getString("id"))) continue;
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u8fd8\u5728\u5206\u5e03\u5f0f\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u8f6c\u5165\u4e0b\u6708\u3002", (String)"BackTransBookdateService_3", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
        ArrayList<Long> sourcebillids = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        ArrayList<String> sourcebillidStrings = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntitie : dataEntities) {
            sourcebillids.add(dataEntitie.getLong("id"));
            sourcebillidStrings.add(dataEntitie.getString("id"));
        }
        List<HashMap<String, Object>> indexLists = DapVoucherUtil.getBookdateReconds(sourcebillids, this.billType);
        block16: for (int i = 0; i < dataEntities.length; ++i) {
            Long id = dataEntities[i].getLong("id");
            boolean flag = true;
            for (HashMap<String, Object> map : indexLists) {
                if (id.equals(map.get("sourcebillid"))) {
                    ids.add((Long)map.get("id"));
                    dataEntities[i].set(this.bookdate, map.get("oldbookdate"));
                    flag = false;
                }
                if (flag) continue;
                continue block16;
            }
        }
        ECSession ecSession = DtxFactory.createEC((String)"backtrans_bookdate");
        ecSession.setDbRoute(DBRoute.of((String)"fi"));
        try (TXHandle h = TX.requiresNew();){
            try {
                ecSession.setBusinessType("transbookdate");
                ecSession.setBusinessInfo(sourcebillidStrings);
                ecSession.begin();
                String cloudId = "fi";
                String appId = "ai";
                BookdateRecondsParam param = new BookdateRecondsParam();
                param.setOperation(VoucherOperation.BackTransBookdate);
                param.setMap(null);
                param.setList(ids);
                ecSession.register(cloudId, appId, "TransbookdateUtilService", (Param)param, null, sourcebillidStrings);
                SaveServiceHelper.save((DynamicObject[])dataEntities);
            }
            catch (Throwable e) {
                h.markRollback();
                try {
                    ecSession.rollback();
                }
                catch (Exception exception) {
                    logger.error("tcc rollback error.", (Throwable)exception);
                }
                throw e;
            }
        }
        try {
            ecSession.commit();
        }
        catch (Exception e) {
            logger.error("tcc commit error.", (Throwable)e);
        }
    }
}

