/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.operation.DapOperationResultHelper;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.constant.BuildVoucherServiceParamConstants;
import kd.bos.ext.fi.ai.v2.fah.constant.CreateXlaMode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.DapEntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BuildVoucherService
extends DapEntityOperateService {
    private static final Log log = LogFactory.getLog(BuildVoucherService.class);
    private Set<Long> billIds;
    private String GenerateProcessKey = "";

    @Override
    public OperationResult excute(Object[] ids) throws Exception {
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("false".equalsIgnoreCase(buildMode)) {
            return this.getVoucherOperationResult(ids);
        }
        if ("true".equalsIgnoreCase(buildMode)) {
            return this.getXlaOperationResult(ids);
        }
        String mode = BuildXLAAndGLUtils.createXlaMode();
        if (CreateXlaMode.DAP_NEW_CUS.getCode().equals(mode) || (CreateXlaMode.DAP_REG_NEW.getCode().equals(mode) || CreateXlaMode.DAP_REG_OPTION.getCode().equals(mode)) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getOperationContext().getEntityTypeId(), BuildXLAAndGLUtils.buildSetData(ids))) {
            return this.getXlaOperationResult(ids);
        }
        return this.getVoucherOperationResult(ids);
    }

    private OperationResult getVoucherOperationResult(Object[] ids) throws Exception {
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (Object id : ids) {
            billIds.add(Long.valueOf(id.toString()));
        }
        this.billIds = billIds;
        long superStart = System.currentTimeMillis();
        this.setGenerateProKey();
        log.info("--DAP--GenerateProcessKey:{};ids.size:{}", (Object)this.GenerateProcessKey, (Object)ids.length);
        OperationResult sr = super.excute(ids);
        log.info("super.excute+\u751f\u6210\u51ed\u8bc1\u5408\u8ba1\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - superStart));
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String cacheData = distributeCache.get(this.GenerateProcessKey);
        Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
        if (cacheData != null) {
            cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(100)));
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        cacheDataMap.put("OperationResult", DataEntitySerializer.serializerToString((Object)sr, (DataEntitySerializerOption)option));
        distributeCache.put(this.GenerateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        return sr;
    }

    private OperationResult getXlaOperationResult(Object[] ids) throws Exception {
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (Object id : ids) {
            billIds.add(Long.valueOf(id.toString()));
        }
        this.billIds = billIds;
        long superStart = System.currentTimeMillis();
        this.setGenerateProKey();
        log.info("--XlaAndGl--GenerateProcessKey:{};ids.size:{}", (Object)this.GenerateProcessKey, (Object)ids.length);
        OperationResult sr = super.excute(ids);
        log.info("super.excute+\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u5408\u8ba1\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - superStart));
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String cacheData = distributeCache.get(this.GenerateProcessKey);
        Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
        if (cacheData != null) {
            cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(100)));
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        cacheDataMap.put("operationResult", DataEntitySerializer.serializerToString((Object)sr, (DataEntitySerializerOption)option));
        distributeCache.put(this.GenerateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        return sr;
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] sd = super.callOperation(objs);
        List succids = this.getOperationResult().getSuccessPkIds();
        HashSet succIdSet = new HashSet(succids);
        DynamicObject[] rel = (DynamicObject[])Stream.of(sd).filter(d -> succids.contains(d.getPkValue())).toArray(DynamicObject[]::new);
        succids.removeAll(Stream.of(rel).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        IDataEntityProperty billNoProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = "ai_event".equals(this.subEntityType.getName()) ? this.subEntityType.findProperty("number") : this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
        }
        List errors = this.getOperationResult().getAllErrorInfo();
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(sd.length);
        for (DynamicObject dd : sd) {
            dataMap.put(dd.getPkValue(), dd);
        }
        for (OperateErrorInfo error : errors) {
            String billNo;
            DynamicObject errorObj = (DynamicObject)dataMap.get(error.getPkValue());
            if (errorObj == null) continue;
            String string = billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)errorObj);
            if (billNo == null) {
                error.setMessage(String.format(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff1a%s", (String)"VoucherStateValidator_4", (String)"bos-ext-fi", (Object[])new Object[0]), error.getMessage()));
                continue;
            }
            error.setMessage(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff1a%2$s", (String)"VoucherStateValidator_5", (String)"bos-ext-fi", (Object[])new Object[0]), billNo, error.getMessage()));
        }
        return rel;
    }

    protected void executeOperate(DynamicObject[] arg0) {
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("false".equalsIgnoreCase(buildMode)) {
            this.doGenerateVoucher(arg0);
        } else if ("true".equalsIgnoreCase(buildMode)) {
            this.doBuildXlaAndGlExecuteOperate(arg0);
        } else {
            String mode = BuildXLAAndGLUtils.createXlaMode();
            if (CreateXlaMode.DAP_NEW_CUS.getCode().equals(mode) || (CreateXlaMode.DAP_REG_NEW.getCode().equals(mode) || CreateXlaMode.DAP_REG_OPTION.getCode().equals(mode)) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getOperationContext().getEntityTypeId(), BuildXLAAndGLUtils.buildSetData(arg0))) {
                this.doBuildXlaAndGlExecuteOperate(arg0);
            } else {
                this.doGenerateVoucher(arg0);
            }
        }
    }

    private void doGenerateVoucher(DynamicObject[] arg0) {
        long startTime = System.currentTimeMillis();
        OperationResult sr = this.getOperationResult();
        if (sr.getAllErrorOrValidateInfo().size() > 0) {
            this.billIds.removeAll(sr.getValidateResult().getErrorPkIds());
        }
        DBRoute route = DBRoute.of((String)this.billEntityType.getDBRouteKey());
        String tableName = this.billEntityType.getAlias();
        ArrayList<Object> idList = new ArrayList<Object>(16);
        for (Long object : this.billIds) {
            idList.add(object);
        }
        List<Long> inDapn = DapVoucherUtil.getNogenVch(route, idList, tableName);
        if (this.billIds.size() == inDapn.size()) {
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5df2\u7ecf\u8bbe\u7f6e\u4e0d\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"BuildVoucherService_01", (String)"bos-ext-fi", (Object[])new Object[0]));
            error.setErrorLevel(ErrorLevel.Warning.name());
            sr.getAllErrorInfo().add(error);
            sr.setSuccess(false);
            return;
        }
        this.billIds.removeAll(inDapn);
        String paramStr = this.parseParams(this.operateMetaMap.get("parameter"), this.operationKey);
        log.info("--DAP--parseParams--GenerateProcessKey:" + this.GenerateProcessKey);
        log.info("\u89e3\u6790\u751f\u6210\u51ed\u8bc1\u64cd\u4f5c\u53c2\u6570\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        Date start = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(start);
        date.set(13, date.get(13) - 1);
        startTime = System.currentTimeMillis();
        String error = this.dispatchGenVoucher(this.billIds, paramStr);
        log.info("\u751f\u6210\u51ed\u8bc1\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
        startTime = System.currentTimeMillis();
        OperationResult buildResult = DapOperationResultHelper.buildResult(this.billIds.toArray(new Long[0]), error, sr, date.getTime(), this.getOption().containsVariable("preBuild"));
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String cacheData = distributeCache.get(this.GenerateProcessKey);
        Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
        if (cacheData != null) {
            cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(99)));
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        cacheDataMap.put("OperationResult", DataEntitySerializer.serializerToString((Object)buildResult, (DataEntitySerializerOption)option));
        distributeCache.put(this.GenerateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        log.info("\u5904\u7406\u751f\u6210\u51ed\u8bc1\u64cd\u4f5c\u7ed3\u679c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void doBuildXlaAndGlExecuteOperate(DynamicObject[] arg0) {
        OperationResult sr = this.getOperationResult();
        if (!sr.getAllErrorOrValidateInfo().isEmpty()) {
            this.billIds.removeAll(sr.getValidateResult().getErrorPkIds());
        }
        String paramStr = this.parseXlaParams();
        log.info("--XLA--parseXlaParams--paramStr:{}", (Object)paramStr);
        long startTime = System.currentTimeMillis();
        String returnData = this.dispatchBuildXlaAndGl(this.billIds, paramStr);
        Set<Long> ids = BuildXLAAndGLUtils.buildSetData(arg0);
        BuildXLAAndGLUtils.buildXlaResult(ids, returnData, this.getOperationResult());
        log.info("\u751f\u6210\u5b50\u5206\u7c7b\u548c\u603b\u8d26\u51ed\u8bc1\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private String dispatchBuildXlaAndGl(Set<Long> billIds, String paramStr) {
        StringBuilder error = new StringBuilder();
        if ("ai_event".equals(this.getOperationContext().getEntityTypeId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IBuildXLAAndGLService", (String)"buildXLAAndGL", (Object[])new Object[]{billTypeGroup.getKey(), new HashSet(billTypeGroup.getValue()), paramStr});
                if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                error.append(errorMsg);
            }
        } else {
            String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IBuildXLAAndGLService", (String)"buildXLAAndGL", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), billIds, paramStr});
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                error.append(errorMsg);
            }
        }
        log.info("#####dispatchBuildXlaAndGl--error:{}", (Object)error);
        return error.toString();
    }

    private String parseXlaParams() {
        HashMap<String, String> param = new HashMap<String, String>(16);
        String varStr = this.getOption().getVariableValue("SubmitPopWinValue", null);
        if (varStr != null) {
            Map returnParamMap = FahSerializeHelper.fromJsonString(varStr, Map.class);
            param.putAll(returnParamMap);
        } else {
            param.put("isPreview", "false");
            param.put("includeTaskGrp", BuildVoucherServiceParamConstants.TaskGrps_Bill_To_GL);
        }
        varStr = this.getOption().getVariableValue("GenerateProcessKey", null);
        if (varStr != null) {
            param.put("GenerateProcessKey", varStr);
        }
        return FahSerializeHelper.getInstance().toJSONString(param);
    }

    private String splitEventBuildVoucher(Set<Long> billIds, String paramStr) {
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        DynamicObjectCollection events = QueryServiceHelper.query((String)"ai_event", (String)"id,eventclass", (QFilter[])new QFilter("id", "in", billIds).toArray());
        for (DynamicObject event : events) {
            Set set = map.computeIfAbsent(event.getLong("eventclass"), fun -> new HashSet());
            set.add(event.getLong("id"));
        }
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Long, Set<Long>> entry : map.entrySet()) {
            String error = this.eventBuildVoucher(paramStr, entry);
            if (!StringUtils.isNotBlank((CharSequence)error)) continue;
            str.append(error);
        }
        return str.toString();
    }

    private String eventBuildVoucher(String paramStr, Map.Entry<Long, Set<Long>> entry) {
        return (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"eventBuildVoucher", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), entry.getValue(), paramStr, entry.getKey()});
    }

    private String parseParams(Object params, String opr) {
        String mergeCode;
        String paramStr;
        Map param = params != null ? ((paramStr = SerializationUtils.toJsonString((Object)params)) != null ? (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class) : new HashMap()) : new HashMap();
        if (this.getOption().containsVariable("multidap")) {
            String parameter = (String)param.get("parameter");
            if (parameter != null) {
                Map multidapParam = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
                multidapParam.put("multidap", Boolean.valueOf(this.getOption().getVariableValue("multidap")));
                param.put("parameter", SerializationUtils.toJsonString((Object)multidapParam));
            } else {
                param.put("multidap", Boolean.valueOf(this.getOption().getVariableValue("multidap")));
            }
        } else {
            Object parmeter1;
            Object parmeter = this.operateMetaMap.get("parameter");
            if (parmeter != null && (parmeter1 = ((Map)parmeter).get("parameter")) != null) {
                Map parmeter2 = (Map)SerializationUtils.fromJsonString((String)parmeter1.toString(), Map.class);
                param.put("multidap", Boolean.valueOf((Boolean)parmeter2.get("multidap")));
            }
        }
        if (this.getOption().containsVariable("tempId")) {
            param.put("tempInfo", this.getOption().getVariableValue("tempId"));
        }
        if (this.getOption().containsVariable("ignoretemplateunique")) {
            param.put("ignoretemplateunique", this.getOption().getVariableValue("ignoretemplateunique"));
        }
        if (this.getOption().containsVariable("mergeCode") && StringUtils.isNotEmpty((CharSequence)(mergeCode = this.getOption().getVariableValue("mergeCode")))) {
            Map mergeCodeMap = (Map)SerializationUtils.fromJsonString((String)mergeCode, Map.class);
            param.putAll(mergeCodeMap);
        }
        if (this.getOption().containsVariable("GenerateProcessKey")) {
            String generateProcessKey;
            this.GenerateProcessKey = generateProcessKey = this.getOption().getVariableValue("GenerateProcessKey");
            param.put("GenerateProcessKey", generateProcessKey);
        }
        if (this.getOption().containsVariable("gl_intellexecschema")) {
            param.put("buildType", "B");
        }
        if (this.getOption().containsVariable("ai_buildvchwizard")) {
            param.put("buildType", "C");
        }
        if (this.getOption().containsVariable("BuildVoucherType")) {
            param.put("BuildVoucherType", "1");
        }
        if (this.getOption().containsVariable("isBizGenerateVoucher")) {
            param.put("isBizGenerateVoucher", this.getOption().getVariableValue("isBizGenerateVoucher"));
        }
        if (this.getOption().containsVariable("buildBizvoucherFromMidle")) {
            param.put("buildBizvoucherFromMidle", this.getOption().getVariableValue("buildBizvoucherFromMidle"));
        }
        if (this.getOption().containsVariable("isopenmutexlock")) {
            param.put("isopenmutexlock", this.getOption().getVariableValue("isopenmutexlock"));
        }
        if (this.getOption().containsVariable("openalltemplate")) {
            param.put("openalltemplate", this.getOption().getVariableValue("openalltemplate"));
        }
        log.info("--DAP--start--ignorebillstatus1:" + this.getOption().containsVariable("ignorebillstatus"));
        if (this.getOption().containsVariable("ignorebillstatus")) {
            param.put("ignorebillstatus", this.getOption().getVariableValue("ignorebillstatus"));
            log.info("--DAP--start--ignorebillstatus2:" + this.getOption().getVariableValue("ignorebillstatus"));
        }
        if (this.getOption().containsVariable("preBuild")) {
            param.put("preBuild", "preBuild");
        }
        param.put("operationKey", this.operationKey);
        if (opr != null) {
            param.put("opr", opr);
        }
        return SerializationUtils.toJsonString(param);
    }

    private String dispatchGenVoucher(Set<Long> billIds, String paramStr) {
        StringBuilder error = new StringBuilder();
        if ("ai_event".equals(this.getOperationContext().getEntityTypeId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String errorMsg = "ai_event".equals(billTypeGroup.getKey()) ? this.splitEventBuildVoucher(billIds, paramStr) : this.buildVoucher(billTypeGroup.getKey(), new HashSet<Long>((Collection)billTypeGroup.getValue()), paramStr);
                if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                error.append(errorMsg);
            }
        } else {
            String errorMsg = this.buildVoucher(this.getOperationContext().getEntityTypeId(), billIds, paramStr);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                error.append(errorMsg);
            }
        }
        log.info("#####dispatchGenVoucher--error:" + error);
        return error.toString();
    }

    private String buildVoucher(String billType, Set<Long> billIds, String paramStr) {
        String errorMsg;
        if (this.getOption().containsVariable("scheme")) {
            String schemeStr = this.getOption().getVariableValue("scheme");
            errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"buildVoucher", (Object[])new Object[]{billType, billIds, paramStr, schemeStr});
        } else if (this.getOption().containsVariable("onTime") && "true".equals(this.getOption().getVariableValue("onTime"))) {
            String ontimeoperatekey = null;
            if (this.getOption().containsVariable("ontimeoperatekey")) {
                ontimeoperatekey = this.getOption().getVariableValue("ontimeoperatekey");
            }
            errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"onTimeBuildVoucher", (Object[])new Object[]{billType, ontimeoperatekey, billIds, paramStr});
        } else {
            errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"buildVoucher", (Object[])new Object[]{billType, billIds, paramStr});
        }
        return errorMsg;
    }

    private void setGenerateProKey() {
        if (this.getOption().containsVariable("GenerateProcessKey")) {
            String generateProcessKey;
            this.GenerateProcessKey = generateProcessKey = this.getOption().getVariableValue("GenerateProcessKey");
        }
    }

    @Override
    public String getGenerateProcessKey() {
        return this.GenerateProcessKey;
    }
}

