/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;

public class DeleteVoucherValidator
extends AbstractValidator {
    public void validate() {
        MainEntityType type = this.validateContext.getBillEntityType();
        ArrayList<Long> idList = new ArrayList<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            idList.add((Long)dataObj.getBillPkId());
        }
        Set<Object> vPks = new HashSet(idList.size());
        if ("ai_event".equals(this.entityKey)) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(idList);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                List<Long> subIdList = billTypeGroup.getValue();
                String billType = billTypeGroup.getKey();
                Set<Long> buildVchedBills = this.getBuildVchedBills(subIdList, billType);
                vPks.addAll(buildVchedBills);
            }
        } else {
            vPks = this.getBuildVchedBills(idList, type.getName());
        }
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            if (vPks.contains(dataObj.getBillPkId())) continue;
            if ("ai_event".equals(this.entityKey)) {
                this.addErrorMessage(dataObj, String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\uff1a\u5c1a\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"DeleteVoucherService_1", (String)"bos-ext-fi", (Object[])new Object[0]), dataObj.getValue("number")));
                continue;
            }
            this.addErrorMessage(dataObj, ResManager.loadKDString((String)"\u5c1a\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"DeleteVoucherService_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
    }

    private Set<Long> getBuildVchedBills(Collection<Long> billPks, String billType) {
        int size = billPks.size();
        if (size > 2000) {
            HashSet<Long> vchids = new HashSet<Long>(billPks.size());
            HashSet<Long> cache = new HashSet<Long>(billPks.size());
            int i = 0;
            for (Long billid : billPks) {
                cache.add(billid);
                if (++i % 2000 != 0 && i != size) continue;
                String joinids = StringUtils.join((Object[])cache.toArray(), (char)',');
                Set<Long> vchidsTmp = this.getVchedIds(billType, joinids);
                vchids.addAll(vchidsTmp);
                cache.clear();
            }
            return vchids;
        }
        String joinids = StringUtils.join((Object[])billPks.toArray(), (char)',');
        return this.getVchedIds(billType, joinids);
    }

    private Set<Long> getVchedIds(String billType, String joinids) {
        Set result = (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fsourcebillid from t_ai_daptracker where fsourcebillid in (" + joinids + ") and fbilltype = ?"), (Object[])new Object[]{billType}, e -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (e.next()) {
                idSet.add(e.getLong("fsourcebillid"));
            }
            return idSet;
        });
        Set result_event = (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fsrc_billid from t_fah_evt_tracker where fsrc_billid in (" + joinids + ") and fsrc_billtype = ? and fstatus = '4'"), (Object[])new Object[]{billType}, e -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (e.next()) {
                idSet.add(e.getLong("fsrc_billid"));
            }
            return idSet;
        });
        result.addAll(result_event);
        return result;
    }
}

