/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.service.operation.EntityOperateService;

public class NoGenVoucherService
extends EntityOperateService {
    private String billType;
    private DBRoute route;
    private String tableName;
    private DistributeCache cache = new DistributeCache(CacheModule.DAPNTABLEIDS);
    private static final String NOVOUCHERBILLIDS = "novoucherbill_ids";

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add("id");
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        this.route = DBRoute.of((String)this.billEntityType.getDBRouteKey());
        this.tableName = this.billEntityType.getAlias();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                HashSet<Long> inDap = new HashSet<Long>(DapVoucherUtil.getBuildedBill(pkIds, NoGenVoucherService.this.billType));
                HashSet<Long> inDapn = new HashSet<Long>(DapVoucherUtil.getNogenVch(NoGenVoucherService.this.route, pkIds, NoGenVoucherService.this.tableName));
                for (ExtendedDataEntity exData : exDatas) {
                    Long tempId = (Long)exData.getBillPkId();
                    if (inDap.contains(tempId)) {
                        this.addMessage(exData, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u9700\u518d\u8bbe\u7f6e\u4e0d\u751f\u6210\u51ed\u8bc1\u3002", (String)"NoGenVoucherService_01", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (!inDapn.contains(tempId)) continue;
                    this.addMessage(exData, ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u4e0d\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u9700\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"NoGenVoucherService_02", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
        OperationResult sr = this.getOperationResult();
        String entityName = this.billEntityType.getName();
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey(entityName)), (String)DapBuildVoucherCommonUtil.getBlackTableName(entityName));
        if (!exitsTable) {
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7c7b\u578b\u7684\u3010\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3011\u6309\u94ae\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u51ed\u8bc1\u6a21\u677f\u5217\u8868\u8bbe\u7f6e\u3002", (String)"BuildVoucher_10", (String)"bos-ext-fi", (Object[])new Object[0]));
            error.setErrorLevel(ErrorLevel.Warning.name());
            sr.getAllErrorInfo().add(error);
            sr.setSuccess(false);
            return;
        }
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        int count = dataEntities.length;
        long[] pkIds = DB.genLongIds((String)(this.tableName + "_dapn"), (int)count);
        ArrayList<Object[]> params = new ArrayList<Object[]>(count);
        ArrayList<Long> deleteparams = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            Object[] obj = new Object[7];
            obj[0] = pkIds[i];
            obj[1] = dataEntities[i].getLong("id");
            DynamicObject dynamicObject = (DynamicObject)dataEntities[i].get(this.billEntityType.getMainOrg());
            obj[2] = dynamicObject.getLong("id");
            obj[3] = date;
            obj[4] = Long.parseLong(userId);
            obj[5] = dataEntities[i].get("billno");
            obj[6] = dataEntities[i].getDataEntityType().getName();
            params.add(obj);
            deleteparams.add(dataEntities[i].getLong("id"));
        }
        String string = "insert into %s_dapn (fid,fsourcebillid,forgid,fcreatetime,fcreatorid,fsourcebillno,fbilltype) values (?,?,?,?,?,?,?)";
        String insertsql = String.format(string, this.tableName);
        String joinids = StringUtils.join((Object[])deleteparams.toArray(), (char)',');
        String deletestring = " delete from %s_dapw where fsourcebillid in (%s)";
        String deletesql = String.format(deletestring, this.tableName, joinids);
        try (TXHandle h = TX.required();){
            DB.executeBatch((DBRoute)this.route, (String)insertsql, params);
            DB.execute((DBRoute)this.route, (String)deletesql);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cache.get(NOVOUCHERBILLIDS))) {
            this.cache.remove(NOVOUCHERBILLIDS);
        }
    }
}

