/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.v2.fah.DataModelDaoImpl;
import kd.bos.ext.fi.ai.v2.fah.constant.AppVersionEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ExtDataQueryHelper {
    private static Boolean metaUpdated = null;

    public static Map<String, List<Long>> groupByBillType(Collection<Long> ids) {
        HashMap<String, List<Long>> billTypeGroup = new HashMap<String, List<Long>>(8);
        if (!ExtDataQueryHelper.checkMetaUpdated()) {
            billTypeGroup.put("ai_event", new LinkedList<Long>(ids));
            return billTypeGroup;
        }
        DynamicObjectCollection events = QueryServiceHelper.query((String)"ai_event", (String)"id, eventclass.number eventclassnum, eventclass.appversion appversion", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        for (DynamicObject event : events) {
            long id = event.getLong("id");
            String appVersion = event.getString("appversion");
            String billType = DataModelDaoImpl.getTableName(event.getString("eventclassnum"));
            if (!String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(appVersion)) {
                billType = "ai_event";
            }
            billTypeGroup.computeIfAbsent(billType, k -> new LinkedList()).add(id);
        }
        return billTypeGroup;
    }

    private static boolean checkMetaUpdated() {
        if (null == metaUpdated) {
            MainEntityType aiEventclassType = MetadataServiceHelper.getDataEntityType((String)"ai_eventclass");
            DynamicProperty property = aiEventclassType.getProperty("appversion");
            metaUpdated = null != property;
        }
        return metaUpdated;
    }
}

