/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.ext.fi.botp.info.AdminDivision;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BaseDataHelper {
    public static final String SETTLECATE_COMMERCE = "5";
    public static final String SETTLECATE_BANK = "6";
    public static final String SETTLECATE_PROM = "1";
    public static final String SETTLECATE_CHECK = "2";

    public static Pair<String, BigDecimal> getExchangeRateByTable(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date exratedate, Long exchangeRateTableId) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quteType = "0";
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return Pair.of((Object)quteType, (Object)exchangeRate);
        }
        if (sourceCurrencyId.longValue() == targetCurrencyId.longValue()) {
            return Pair.of((Object)quteType, (Object)exchangeRate);
        }
        if (exchangeRateTableId == 0L || CasHelper.isEmpty(exchangeRateTableId)) {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable(orgId).getLong("id");
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)sourceCurrencyId, (Long)targetCurrencyId, (Long)exchangeRateTableId, (Date)exratedate);
        Object qt = exchangeRateMap.get("quoteType");
        Object er = exchangeRateMap.get("exchangeRate");
        if (qt != null && ((Boolean)qt).booleanValue()) {
            quteType = SETTLECATE_PROM;
        }
        if (er != null) {
            exchangeRate = (BigDecimal)er;
        }
        return Pair.of((Object)quteType, (Object)exchangeRate);
    }

    public static DynamicObject getDefaultSettleType() {
        QFilter[] filters = new QFilter[]{new QFilter("isdefault", "=", (Object)SETTLECATE_PROM), new QFilter("enable", "=", (Object)1)};
        return BusinessDataServiceHelper.loadSingle((String)"bd_settlementtype", (String)"id, name, number, ispaythroughbe, settlementtype", (QFilter[])filters);
    }

    public static DynamicObject getInternalOrg(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        String entity = basedata.getDataEntityType().getName();
        if ((basedata = BusinessDataServiceHelper.loadSingleFromCache((Object)basedata.getPkValue(), (String)entity, (String)"internal_company")) == null) {
            return null;
        }
        return basedata.getDynamicObject("internal_company");
    }

    public static AdminDivision getAdminDivision(String beBankNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)beBankNumber)};
        DynamicObject beBank = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"name,city,basedatafield1", (QFilter[])filters);
        return BaseDataHelper.getAdminDivision(beBank);
    }

    public static AdminDivision getAdminDivision(DynamicObject beBank) {
        if (beBank == null) {
            return null;
        }
        beBank = BusinessDataServiceHelper.loadSingleFromCache((Object)beBank.getPkValue(), (String)beBank.getDataEntityType().getName());
        String province2 = null;
        String city2 = null;
        DynamicObject adminDivision = null;
        IDataEntityProperty cityProp = (IDataEntityProperty)beBank.getDataEntityType().getProperties().get((Object)"city");
        if (cityProp == null) {
            cityProp = (IDataEntityProperty)beBank.getDataEntityType().getProperties().get((Object)"basedatafield1");
            if (cityProp == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u65e2\u6ca1\u6709city,\u4e5f\u6ca1\u6709basedatafield1,\u4f60\u5230\u5e95\u8981\u95f9\u54ea\u6837\u513f\uff01\uff01\uff01", (String)"BaseDataHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
            }
            adminDivision = beBank.getDynamicObject("basedatafield1");
        } else {
            adminDivision = beBank.getDynamicObject("city");
        }
        if (adminDivision == null) {
            return null;
        }
        adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivision.getLong("id"), (String)"bd_admindivision");
        DynamicObject country = adminDivision.getDynamicObject("country");
        int level = adminDivision.getInt("level");
        if (level == 1) {
            province2 = adminDivision.getString("name");
        } else if (level == 2) {
            province2 = adminDivision.getString("parent.name");
            city2 = adminDivision.getString("name");
        } else if (level == 3) {
            DynamicObject city = BusinessDataServiceHelper.loadSingle((Object)adminDivision.getLong("parent.id"), (String)"bd_admindivision", (String)"id, name, level, iscity, basedatafield.id, basedatafield.name, parent.id, parent.name,country");
            province2 = city.getString("parent.name");
            city2 = city.getString("name");
        }
        AdminDivision adminDivision2 = new AdminDivision();
        adminDivision2.setCountry(country);
        adminDivision2.setProvince(province2);
        adminDivision2.setCity(city2);
        return adminDivision2;
    }

    public static boolean isSettleTypeCash(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return "0".equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeDraft(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return SETTLECATE_COMMERCE.equals(settleType.getString("settlementtype")) || SETTLECATE_BANK.equals(settleType.getString("settlementtype")) || SETTLECATE_PROM.equals(settleType.getString("settlementtype")) || SETTLECATE_CHECK.equals(settleType.getString("settlementtype"));
    }

    public static boolean isSettleTypeVirtual(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return "14".equals(settleType.getString("settlementtype"));
    }

    public static String getPictureUrl(Long basedataId, String basedataType) {
        DynamicObject user;
        if (CasHelper.isEmpty(basedataId)) {
            return null;
        }
        if ("bd_supplier".equals(basedataType) || "bd_customer".equals(basedataType)) {
            DynamicObject baseData = BusinessDataServiceHelper.loadSingle((Object)basedataId, (String)basedataType, (String)"picturefield");
            if (baseData != null && !CasHelper.isEmpty(baseData.get("picturefield"))) {
                return (String)baseData.get("picturefield");
            }
        } else if ("bos_user".equals(basedataType) && (user = BusinessDataServiceHelper.loadSingle((Object)basedataId, (String)basedataType, (String)"picturefield")) != null && !CasHelper.isEmpty(user.get("picturefield"))) {
            return (String)user.get("picturefield");
        }
        return null;
    }
}

