/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.function;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;

public class GetCostAccountFirstDay
implements BOSUDFunction,
IBatchFunctionHandler {
    public GetCostAccountFirstDay() {
    }

    public GetCostAccountFirstDay(ExpressionContext expContext) {
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetCostAccountFirstDay(expContext);
    }

    public Object call(Object ... arg) {
        Object costAccountId = arg[0];
        if (costAccountId == null) {
            return null;
        }
        return GetCostAccountFirstDay.getStartDateByAccount(costAccountId);
    }

    public String getName() {
        return "GetCostAccountFirstDay";
    }

    public static Date getStartDateByAccount(Object costAccountID) {
        try {
            QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)Long.parseLong(costAccountID.toString()));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.begindate as begindate", (QFilter[])new QFilter[]{filter});
            if (dynamicObject == null) {
                return null;
            }
            return dynamicObject.getDate("begindate");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<Function, Object> execute(Set<Function> param) {
        HashMap<Function, Object> resultMap = new HashMap<Function, Object>(param.size());
        HashSet<Long> accountIds = new HashSet<Long>(param.size());
        for (Function arg : param) {
            if (arg.getParams().get(0) == null) continue;
            accountIds.add(Long.parseLong(arg.getParams().get(0).toString()));
        }
        if (!accountIds.isEmpty()) {
            HashMap<Long, Date> dateMap = new HashMap<Long, Date>(param.size());
            QFilter filter = new QFilter("entry.costaccount.id", "in", accountIds);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount.id accountId,entry.currentperiod.begindate as begindate", (QFilter[])new QFilter[]{filter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                dateMap.put(dynamicObject.getLong("accountId"), dynamicObject.getDate("begindate"));
            }
            for (Function arg : param) {
                long accountId;
                if (arg.getParams().get(0) == null || dateMap.get(accountId = Long.parseLong(arg.getParams().get(0).toString())) == null) continue;
                resultMap.put(arg, dateMap.get(accountId));
            }
        }
        return resultMap;
    }
}

