/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.eb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.RadioGroupEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;

public class RejectOnReportPagePlugin
extends AbstractWorkflowPlugin {
    private static final Log log = LogFactory.getLog(RejectOnReportPagePlugin.class);
    private static final String CUSTOM_PARAM_FLEX_PANEL = "customeparamflexpanel";
    private static final String RADIO_GROUP = "epm_radiogroup";
    private static final String FLEX_REJECT_TYPE = "epm_flex_reject_type";
    private static final String LABEL_REJECT_TYPE = "epm_label_reject_type";
    private static final String FLEX_RADIO_GROUP = "epm_flex_radiogroup";
    private static final String LABEL_REPORT_OPINION = "epm_label_report_opinion";
    private static final String LABEL_REPORT = "epm_label_report";
    private static final String FLEX_REPORT_OPINION = "epm_flex_report_opinion";
    private static final String FLEX_REPORT = "epm_flex_report";
    private static final String REJECT_CALLBACK = "epm_reject_callback";
    private static final String OPINION_CALLBACK = "epm_opinion_callback";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            ComboProp groupProp = new ComboProp();
            groupProp.setName(RADIO_GROUP);
            ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(2);
            comboItems.add(new ValueMapItem("", "all", new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u62a5\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]))));
            comboItems.add(new ValueMapItem("", "part", new LocaleString(ResManager.loadKDString((String)"\u6309\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]))));
            groupProp.setComboItems(comboItems);
            groupProp.setDbIgnore(true);
            newEntityType.addProperty((DynamicProperty)groupProp);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (LABEL_REPORT.equals(key)) {
            Label reportLabel = new Label();
            reportLabel.setKey(key);
            reportLabel.setView(this.getView());
            reportLabel.setModel(this.getModel());
            reportLabel.addClickListener((ClickListener)this);
            e.setControl((Control)reportLabel);
        } else if (RADIO_GROUP.equals(key)) {
            RadioGroupEdit groupEdit = new RadioGroupEdit();
            groupEdit.setKey(key);
            groupEdit.setView(this.getView());
            groupEdit.setModel(this.getModel());
            e.setControl((Control)groupEdit);
        } else if (LABEL_REPORT_OPINION.equals(key)) {
            Label reportOpinionLabel = new Label();
            reportOpinionLabel.setKey(key);
            reportOpinionLabel.setView(this.getView());
            reportOpinionLabel.setModel(this.getModel());
            reportOpinionLabel.addClickListener((ClickListener)this);
            e.setControl((Control)reportOpinionLabel);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(RADIO_GROUP, (Object)"all");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_REPORT, FLEX_REPORT_OPINION, "flexpanelap6"});
        this.getPageCache().put("isNewApprovePage", "true");
        this.createFlexPanelAp();
        log.info("RejectOnReportPagePlugin#afterCreateNewData executed");
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (LABEL_REPORT.equals(key)) {
            HashMap<String, Object> customMap = new HashMap<String, Object>(16);
            customMap.put("relateApproveBills", SerializationUtils.toJsonString(Collections.singletonList(this.getApproveBillId())));
            customMap.put("defaultAlternative", "3");
            ArrayList<String> invisibleObjects = new ArrayList<String>(4);
            invisibleObjects.add("auditpasspanel");
            invisibleObjects.add("flexpanelap");
            invisibleObjects.add("opinionpanel");
            HashMap alterRelateInvisibleMap = new HashMap(1);
            ArrayList<String> reportObjects = new ArrayList<String>(16);
            reportObjects.add("btn_reject");
            reportObjects.add("mustreject");
            alterRelateInvisibleMap.put("3", reportObjects);
            customMap.put("invisible_object", SerializationUtils.toJsonString(invisibleObjects));
            customMap.put("alterRelateInvisible", SerializationUtils.toJsonString(alterRelateInvisibleMap));
            customMap.put("modelId", this.getModelId());
            customMap.put("rejectNode", this.getRejectNode());
            customMap.put("rejectOpinion", this.getRejectOpinion());
            customMap.put("isFromAuditPage", "true");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setAppId("eb");
            showParameter.setFormId("eb_approveopconfirm");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u90e8\u5206\u62a5\u8868", (String)"RejectOnReportPagePlugin_2", (String)"bos-ext-fi", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(customMap);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REJECT_CALLBACK));
            this.getView().showForm(showParameter);
        } else if (LABEL_REPORT_OPINION.equals(key)) {
            HashMap<String, Object> customMap = new HashMap<String, Object>(16);
            customMap.put("relateApproveBills", SerializationUtils.toJsonString(Collections.singletonList(this.getApproveBillId())));
            customMap.put("defaultAlternative", "0");
            ArrayList<String> invisibleObjects = new ArrayList<String>(4);
            invisibleObjects.add("auditpasspanel");
            invisibleObjects.add("flexpanelap");
            invisibleObjects.add("opinionpanel");
            HashMap alterRelateInvisibleMap = new HashMap(1);
            ArrayList<String> opinionObjects = new ArrayList<String>(16);
            opinionObjects.add("rejectnode");
            opinionObjects.add("status");
            opinionObjects.add("tip");
            opinionObjects.add("btn_reject");
            alterRelateInvisibleMap.put("0", opinionObjects);
            customMap.put("invisible_object", SerializationUtils.toJsonString(invisibleObjects));
            customMap.put("alterRelateInvisible", SerializationUtils.toJsonString(alterRelateInvisibleMap));
            customMap.put("modelId", this.getModelId());
            customMap.put("rejectNode", this.getRejectNode());
            customMap.put("rejectOpinion", this.getRejectOpinion());
            customMap.put("isFromAuditPage", "true");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("eb_approveopconfirm");
            showParameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165\u9a73\u56de\u4fe1\u606f", (String)"RejectOnReportPagePlugin_3", (String)"bos-ext-fi", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams(customMap);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPINION_CALLBACK));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (REJECT_CALLBACK.equals(actionId)) {
            int rejectRptCounts = this.countRejectRptIds(this.getApproveBillId());
            Label reportLabel = (Label)this.getView().getControl(LABEL_REPORT);
            reportLabel.setText(ResManager.loadResFormat((String)"\u5df2\u9a73\u56de%1\u5f20\u62a5\u8868", (String)"RejectOnReportPagePlugin_4", (String)"bos-ext-fi", (Object[])new Object[]{rejectRptCounts}));
        } else if (OPINION_CALLBACK.equals(actionId)) {
            String rejectOpinions;
            Map savedInfos;
            String saveRejectInfo;
            int opinionCounts = 0;
            if (this.getView().getParentView() != null && StringUtils.isNotEmpty((String)(saveRejectInfo = this.getView().getParentView().getPageCache().getBigObject("saveRejectInfo"))) && (savedInfos = (Map)SerializationUtils.fromJsonString((String)saveRejectInfo, HashMap.class)) != null && StringUtils.isNotEmpty((String)(rejectOpinions = (String)savedInfos.get("rejectopinion")))) {
                Map rejectOpinionMap = (Map)SerializationUtils.fromJsonString((String)rejectOpinions, HashMap.class);
                opinionCounts = rejectOpinionMap.size();
            }
            Label reportOpinionLabel = (Label)this.getView().getControl(LABEL_REPORT_OPINION);
            reportOpinionLabel.setText(ResManager.loadResFormat((String)"\u5df2\u5f55\u5165%1\u6761\u610f\u89c1", (String)"RejectOnReportPagePlugin_9", (String)"bos-ext-fi", (Object[])new Object[]{opinionCounts}));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("combo_decision".equals(key)) {
            String value = (String)newValue;
            if (value.contains("reject")) {
                boolean isOpenRejectOpinion = this.isOpenRejectOpinion();
                this.getPageCache().put("isOpenRejectOpinion", isOpenRejectOpinion ? "true" : "false");
                boolean isOpenRejectOnReport = this.isOpenRejectOnReport();
                log.info("RejectOnReportPagePlugin#propertyChanged isOpenRejectOpinion={}, isOpenRejectOnReport={}", (Object)isOpenRejectOpinion, (Object)isOpenRejectOnReport);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{CUSTOM_PARAM_FLEX_PANEL});
                if (isOpenRejectOpinion) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_REPORT_OPINION});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_REPORT_OPINION});
                }
                if (isOpenRejectOnReport) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{LABEL_REJECT_TYPE, FLEX_RADIO_GROUP});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{LABEL_REJECT_TYPE, FLEX_RADIO_GROUP});
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{CUSTOM_PARAM_FLEX_PANEL});
            }
        } else if (RADIO_GROUP.equals(key)) {
            String value = (String)newValue;
            if ("part".equals(value)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_REPORT});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_REPORT_OPINION});
                int rejectRptCounts = this.countRejectRptIds(this.getApproveBillId());
                Label reportLabel = (Label)this.getView().getControl(LABEL_REPORT);
                if (rejectRptCounts == 0) {
                    reportLabel.setText(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868", (String)"RejectOnReportPagePlugin_8", (String)"bos-ext-fi", (Object[])new Object[0]));
                } else {
                    reportLabel.setText(ResManager.loadResFormat((String)"\u5df2\u9a73\u56de%1\u5f20\u62a5\u8868", (String)"RejectOnReportPagePlugin_4", (String)"bos-ext-fi", (Object[])new Object[]{rejectRptCounts}));
                }
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_REPORT});
                boolean isOpenRejectOpinion = Boolean.parseBoolean(this.getPageCache().get("isOpenRejectOpinion"));
                this.getView().setVisible(Boolean.valueOf(isOpenRejectOpinion), new String[]{FLEX_REPORT_OPINION});
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e instanceof BeforeSubmitCustomEventArgs) {
            String rejectType;
            BeforeSubmitCustomEventArgs args = (BeforeSubmitCustomEventArgs)e;
            Map submitParams = args.getSubmitParams();
            Object auditType = submitParams.get("auditType");
            if (auditType == null) {
                log.error("ReportRejectPagePlugin#customEvent auditType is null");
                args.setCancel(true);
                return;
            }
            if (!"approve".equals(auditType.toString()) && !"reject".equals(auditType.toString())) {
                log.error("ReportRejectPagePlugin#customEvent auditType is {}", (Object)auditType.toString());
                args.setCancel(true);
                return;
            }
            log.info("ReportRejectPagePlugin#customEvent auditType={}", auditType);
            if ("reject".equals(auditType.toString()) && "part".equals(rejectType = (String)this.getModel().getValue(RADIO_GROUP))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u9a73\u56de\u7684\u62a5\u8868\u3002", (String)"RejectOnReportPagePlugin_5", (String)"bos-ext-fi", (Object[])new Object[0]));
                return;
            }
            Long approveBillId = this.getApproveBillId();
            try {
                Set notDealProcesses = (Set)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"getNotDealProcesses", (Object[])new Object[]{approveBillId, auditType.toString()});
                if (notDealProcesses.size() != 0) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868: \r\n%s", (String)"ApprovalPagePlugin_0", (String)"bos-ext-fi", (Object[])new Object[]{String.join((CharSequence)"\r\n", notDealProcesses)}));
                    return;
                }
            }
            catch (Exception ex) {
                log.error("ReportRejectPagePlugin#customEvent getNotDealProcesses error: {}", (Throwable)ex);
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u9a73\u56de\u6821\u9a8c\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ApprovalPagePlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
                return;
            }
            if ("reject".equals(auditType.toString())) {
                this.rejectAllReports(approveBillId);
            }
        }
    }

    private void createFlexPanelAp() {
        Container container = (Container)this.getView().getControl(CUSTOM_PARAM_FLEX_PANEL);
        ArrayList<Map> items = new ArrayList<Map>(16);
        container.addControls(items);
        LabelAp rejectTypeLabelAp = new LabelAp();
        rejectTypeLabelAp.setId(LABEL_REJECT_TYPE);
        rejectTypeLabelAp.setKey(LABEL_REJECT_TYPE);
        rejectTypeLabelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u65b9\u5f0f", (String)"RejectOnReportPagePlugin_6", (String)"bos-ext-fi", (Object[])new Object[0])));
        FlexPanelAp rejectTypeFlexPanelAp = new FlexPanelAp();
        rejectTypeFlexPanelAp.setKey(FLEX_REJECT_TYPE);
        rejectTypeFlexPanelAp.setGrow(0);
        rejectTypeFlexPanelAp.setShrink(0);
        rejectTypeFlexPanelAp.setDirection("row");
        rejectTypeFlexPanelAp.setAlignItems("center");
        rejectTypeFlexPanelAp.setForeColor("#000000");
        rejectTypeFlexPanelAp.getItems().add(rejectTypeLabelAp);
        items.add(rejectTypeFlexPanelAp.createControl());
        FlexPanelAp groupFlexPanelAp = new FlexPanelAp();
        groupFlexPanelAp.setKey(FLEX_RADIO_GROUP);
        groupFlexPanelAp.setGrow(0);
        groupFlexPanelAp.setShrink(0);
        groupFlexPanelAp.setDirection("row");
        groupFlexPanelAp.setAlignItems("center");
        RadioGroupField radioGroupField = new RadioGroupField();
        radioGroupField.setId(RADIO_GROUP);
        radioGroupField.setKey(RADIO_GROUP);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        comboItemList.add(new ComboItem(0, new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u62a5\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_0", (String)"bos-ext-fi", (Object[])new Object[0])), "all"));
        comboItemList.add(new ComboItem(1, new LocaleString(ResManager.loadKDString((String)"\u6309\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_1", (String)"bos-ext-fi", (Object[])new Object[0])), "part"));
        radioGroupField.setDefValue("all");
        radioGroupField.setItems(comboItemList);
        FieldAp groupFieldAp = new FieldAp();
        groupFieldAp.setId(RADIO_GROUP);
        groupFieldAp.setKey(RADIO_GROUP);
        groupFieldAp.setField((Field)radioGroupField);
        groupFlexPanelAp.getItems().add(groupFieldAp);
        RadioField allRadioField = new RadioField();
        allRadioField.setId("all");
        allRadioField.setKey("all");
        allRadioField.setGroup(RADIO_GROUP);
        allRadioField.setItems("all");
        FieldAp allFieldAp = new FieldAp();
        allFieldAp.setId("all");
        allFieldAp.setKey("all");
        allFieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u62a5\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_0", (String)"bos-ext-fi", (Object[])new Object[0])));
        allFieldAp.setFireUpdEvt(true);
        allFieldAp.setWidth(new LocaleString("100px"));
        allFieldAp.setField((Field)allRadioField);
        groupFlexPanelAp.getItems().add(allFieldAp);
        RadioField partRadioField = new RadioField();
        partRadioField.setId("part");
        partRadioField.setKey("part");
        partRadioField.setGroup(RADIO_GROUP);
        partRadioField.setItems("part");
        FieldAp partFieldAp = new FieldAp();
        partFieldAp.setId("part");
        partFieldAp.setKey("part");
        partFieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u6309\u8868\u9a73\u56de", (String)"RejectOnReportPagePlugin_1", (String)"bos-ext-fi", (Object[])new Object[0])));
        partFieldAp.setFireUpdEvt(true);
        partFieldAp.setField((Field)partRadioField);
        partFieldAp.setWidth(new LocaleString("100px"));
        groupFlexPanelAp.getItems().add(partFieldAp);
        items.add(groupFlexPanelAp.createControl());
        FlexPanelAp reportOpinionFlexPanelAp = new FlexPanelAp();
        reportOpinionFlexPanelAp.setKey(FLEX_REPORT_OPINION);
        reportOpinionFlexPanelAp.setDirection("row");
        reportOpinionFlexPanelAp.setAlignItems("center");
        LabelAp reportOpinionAp = new LabelAp();
        reportOpinionAp.setId(LABEL_REPORT_OPINION);
        reportOpinionAp.setKey(LABEL_REPORT_OPINION);
        reportOpinionAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5f55\u5165\u9a73\u56de\u610f\u89c1", (String)"RejectOnReportPagePlugin_7", (String)"bos-ext-fi", (Object[])new Object[0])));
        reportOpinionAp.setForeColor("#0e5fd8");
        reportOpinionAp.setClickable(true);
        reportOpinionFlexPanelAp.getItems().add(reportOpinionAp);
        items.add(reportOpinionFlexPanelAp.createControl());
        FlexPanelAp reportFlexPanelAp = new FlexPanelAp();
        reportFlexPanelAp.setKey(FLEX_REPORT);
        reportFlexPanelAp.setDirection("row");
        reportFlexPanelAp.setAlignItems("center");
        LabelAp reportAp = new LabelAp();
        reportAp.setId(LABEL_REPORT);
        reportAp.setKey(LABEL_REPORT);
        reportAp.setName(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868", (String)"RejectOnReportPagePlugin_8", (String)"bos-ext-fi", (Object[])new Object[0])));
        reportAp.setForeColor("#0e5fd8");
        reportAp.setClickable(true);
        reportFlexPanelAp.getItems().add(reportAp);
        items.add(reportFlexPanelAp.createControl());
    }

    private Long getApproveBillId() {
        String businessKey = this.getView().getPageCache().get("EPM_APPROVEBILL_KEY");
        if (StringUtils.isEmpty((String)businessKey)) {
            return 0L;
        }
        return Long.parseLong(businessKey);
    }

    private Long getModelId() {
        String modelIdKey = this.getView().getPageCache().get("EPM_MODEL_KEY");
        if (StringUtils.isEmpty((String)modelIdKey)) {
            return 0L;
        }
        return Long.parseLong(modelIdKey);
    }

    private String getRejectNode() {
        String nodeValue = (String)this.getModel().getValue("textfield_nextnodevalue");
        if (StringUtils.isEmpty((String)nodeValue)) {
            return "";
        }
        String[] nodeValueArr = nodeValue.split("_and_");
        if (nodeValueArr.length < 2) {
            return "";
        }
        String userStr = nodeValueArr[0].trim().replaceAll("\u3001", "_");
        String nodeId = nodeValueArr[1];
        if (StringUtils.isNotEmpty((String)userStr)) {
            nodeId = nodeId + "#" + userStr.substring(0, userStr.length() - 1);
        }
        return nodeId;
    }

    private String getRejectOpinion() {
        OrmLocaleValue rejectOpinionValue = (OrmLocaleValue)this.getModel().getValue("msg_approval");
        return rejectOpinionValue.getLocaleValue() == null ? "" : rejectOpinionValue.getLocaleValue();
    }

    private boolean isOpenRejectOpinion() {
        boolean isOpenRejectOpinion = false;
        try {
            isOpenRejectOpinion = (Boolean)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"isOpenRejectOpinion", (Object[])new Object[]{this.getModelId()});
        }
        catch (Exception ex) {
            log.error("RejectOnReportPagePlugin==>isOpenRejectOnReport error: ", (Object)ex.getMessage());
        }
        return isOpenRejectOpinion;
    }

    private boolean isOpenRejectOnReport() {
        boolean isOpenRejectOnReport = false;
        try {
            isOpenRejectOnReport = (Boolean)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"isOpenRejectOnReport", (Object[])new Object[]{this.getModelId()});
        }
        catch (Exception ex) {
            log.error("RejectOnReportPagePlugin==>isOpenRejectOnReport error: ", (Object)ex.getMessage());
        }
        return isOpenRejectOnReport;
    }

    private int countRejectRptIds(Long approveBillId) {
        int rejectRptCounts;
        try {
            rejectRptCounts = (Integer)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"countRejectRptIds", (Object[])new Object[]{approveBillId});
        }
        catch (Exception ex) {
            rejectRptCounts = 0;
            log.error("RejectOnReportPagePlugin==>countRejectRptIds error: ", (Object)ex.getMessage());
        }
        return rejectRptCounts;
    }

    private void rejectAllReports(Long approveBillId) {
        String saveRejectInfo = "";
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            saveRejectInfo = parentView.getPageCache().getBigObject("saveRejectInfo");
        }
        String nodeValue = (String)this.getModel().getValue("textfield_nextnodevalue");
        try {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"WorkFlowBizService", (String)"saveRejectOpinions", (Object[])new Object[]{approveBillId, saveRejectInfo, nodeValue});
        }
        catch (Exception ex) {
            log.error("RejectOnReportPagePlugin==>rejectAllReports error: ", (Throwable)ex);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().removeBigObject("saveRejectInfo");
        }
    }
}

