/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.eb.operate;

import java.util.HashMap;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;

public class QueryBudget
extends FormOperate {
    private long pkid;

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                // empty if block
            }
            if (billModel.getPKValue() instanceof Long) {
                this.pkid = (Long)billModel.getPKValue();
            }
            return true;
        }
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows == null || selectedRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e", (String)"QueryBudget_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            if (listSelectedRow.getPrimaryKeyValue() instanceof Long) {
                this.pkid = (Long)listSelectedRow.getPrimaryKeyValue();
            }
            return true;
        }
        return false;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        String formid = "eb_bgavailbalance";
        boolean isModel = false;
        String modelType = this.getView().getFormShowParameter().getFormConfig().getModelType();
        if ("mobilebase".equalsIgnoreCase(modelType) || "mobilebill".equalsIgnoreCase(modelType) || "mobileform".equalsIgnoreCase(modelType) || "mobilelist".equalsIgnoreCase(modelType)) {
            formid = "eb_bgavailbalance_mb";
            isModel = true;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formid);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entityNumber", this.getEntityId());
        params.put("bizId", this.pkid);
        showParameter.setCustomParams(params);
        if (isModel) {
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u9884\u7b97", (String)"QueryBudget_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        this.getView().showForm(showParameter);
    }
}

