/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.invoice;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ext.fi.gl.invoice.PluginRegister;
import kd.bos.ext.fi.invoice.IViewInvoicePlugin;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class InvoiceViewer {
    private static final Log logger = LogFactory.getLog(InvoiceViewer.class);

    public List<InvoiceResult> getInvoiceInfo(String appId, Map<String, List<Long>> billMap) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        IViewInvoicePlugin pluginInstane = PluginRegister.getPluginInstane(appId);
        logger.info("---showinvoice---find plugin={} by appid={}", (Object)pluginInstane.getClass().getName(), (Object)appId);
        return pluginInstane.view(billMap);
    }

    public List<InvoiceResult> buildErrorResult(Map<String, List<Long>> billMap, String errorMsg) {
        return billMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(id -> {
            InvoiceResult invoiceResult = new InvoiceResult();
            invoiceResult.setEntityId((String)entry.getKey());
            invoiceResult.setBillId((Long)id);
            invoiceResult.setSuccess(false);
            invoiceResult.setErrorMsg(errorMsg);
            return invoiceResult;
        })).collect(Collectors.toList());
    }
}

